/*
 * Decompiled with CFR 0.152.
 */
package ga.poglej.recycler.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import ga.poglej.recycler.RecyclerMod;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.BlastingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class BlastingRecyclingRecipe
extends BlastingRecipe {
    private int maxOutput;
    private NonNullList<ItemStack> results;

    private BlastingRecyclingRecipe(ResourceLocation idIn, String groupIn, Ingredient ingredientIn, NonNullList<ItemStack> results, float experienceIn, int cookTimeIn, int maxOutput) {
        super(idIn, groupIn, ingredientIn, ItemStack.field_190927_a, experienceIn, cookTimeIn);
        this.maxOutput = maxOutput;
        this.results = results;
    }

    public boolean func_192399_d() {
        return true;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public ItemStack func_77572_b(IInventory inv) {
        ItemStack input = inv.func_70301_a(0);
        double percentDamage = (double)(input.func_77958_k() - input.func_77952_i()) / (double)input.func_77958_k();
        double percentResources = percentDamage * (double)this.maxOutput;
        List resultAmounts = this.results.stream().map(stack -> (double)stack.func_190916_E() * percentResources).collect(Collectors.toList());
        Optional<Integer> index = IntStream.range(0, resultAmounts.size()).boxed().filter(i -> (Double)resultAmounts.get((int)i) >= 1.0).min(Comparator.comparing(resultAmounts::get));
        if (!index.isPresent()) {
            index = IntStream.range(0, this.results.size()).boxed().filter(i -> !((ItemStack)this.results.get(i.intValue())).func_190926_b()).max(Comparator.comparing(i -> ((ItemStack)this.results.get(i.intValue())).func_190916_E()));
        }
        if (!index.isPresent()) {
            return ItemStack.field_190927_a;
        }
        ItemStack result = ((ItemStack)this.results.get(index.get().intValue())).func_77946_l();
        result.func_190920_e(Math.max(((Double)resultAmounts.get(index.get())).intValue(), 1));
        return result;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return RecyclerMod.Objects.BLASTING_RECYCLING;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<BlastingRecyclingRecipe> {
        public BlastingRecyclingRecipe read(ResourceLocation recipeId, JsonObject json) {
            String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            JsonArray jsonIngredient = JSONUtils.func_151202_d((JsonObject)json, (String)"ingredient") ? JSONUtils.func_151214_t((JsonObject)json, (String)"ingredient") : JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient");
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)jsonIngredient);
            JsonArray jsonResults = JSONUtils.func_151214_t((JsonObject)json, (String)"results");
            if (jsonResults.size() < 1) {
                throw new JsonSyntaxException("Need at least one result in results array");
            }
            NonNullList results = NonNullList.func_191197_a((int)jsonResults.size(), (Object)ItemStack.field_190927_a);
            for (int i = 0; i < jsonResults.size(); ++i) {
                JsonElement jsonResult = jsonResults.get(i);
                if (jsonResult.isJsonObject()) {
                    results.set(i, (Object)ShapedRecipe.func_199798_a((JsonObject)((JsonObject)jsonResult)));
                    continue;
                }
                String itemName = JSONUtils.func_151206_a((JsonElement)jsonResult, (String)"result");
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName));
                if (item == null) {
                    throw new JsonSyntaxException("Unknown item '" + itemName + "'");
                }
                results.set(i, (Object)new ItemStack((IItemProvider)item));
            }
            float experience = JSONUtils.func_151221_a((JsonObject)json, (String)"experience", (float)0.0f);
            int cookTime = JSONUtils.func_151208_a((JsonObject)json, (String)"cookingtime", (int)100);
            int maxOutput = JSONUtils.func_151208_a((JsonObject)json, (String)"max_output", (int)1);
            return new BlastingRecyclingRecipe(recipeId, group, ingredient, results, experience, cookTime, maxOutput);
        }

        public BlastingRecyclingRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            String group = buffer.func_150789_c(Short.MAX_VALUE);
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            int resultsSize = buffer.func_150792_a();
            NonNullList results = NonNullList.func_191197_a((int)resultsSize, (Object)ItemStack.field_190927_a);
            for (int i = 0; i < results.size(); ++i) {
                results.set(i, (Object)buffer.func_150791_c());
            }
            float experience = buffer.readFloat();
            int cookTime = buffer.func_150792_a();
            int maxOutput = buffer.func_150792_a();
            return new BlastingRecyclingRecipe(recipeId, group, ingredient, results, experience, cookTime, maxOutput);
        }

        public void write(PacketBuffer buffer, BlastingRecyclingRecipe recipe) {
            buffer.func_180714_a(recipe.field_222141_c);
            recipe.field_222142_d.func_199564_a(buffer);
            buffer.func_150787_b(recipe.results.size());
            for (ItemStack result : recipe.results) {
                buffer.func_150788_a(result);
            }
            buffer.writeFloat(recipe.field_222144_f);
            buffer.func_150787_b(recipe.field_222145_g);
            buffer.func_150787_b(recipe.maxOutput);
        }
    }
}

