/*
 * Decompiled with CFR 0.152.
 */
package com.naxanria.mappy.util;

import com.naxanria.mappy.util.BiInteger;
import net.minecraft.util.math.BlockPos;

public class MathUtil {
    public static int clamp(int val, int min, int max) {
        return val < min ? min : (val > max ? max : val);
    }

    public static float clamp(float val, float min, float max) {
        return val < min ? min : (val > max ? max : val);
    }

    public static double getDistance(BlockPos a, BlockPos b) {
        return MathUtil.getDistance(a, b, false);
    }

    public static double getDistance(BlockPos a, BlockPos b, boolean horizontalOnly) {
        int distX = a.func_177958_n() - b.func_177958_n();
        int distZ = a.func_177952_p() - b.func_177952_p();
        int dist = distX * distX + distZ * distZ;
        if (!horizontalOnly) {
            int distY = a.func_177956_o() - b.func_177956_o();
            dist += distY * distY;
        }
        return Math.sqrt(dist);
    }

    public static double getDistanceSqrd(BlockPos a, BlockPos b) {
        return MathUtil.getDistanceSqrd(a, b, false);
    }

    public static double getDistanceSqrd(BlockPos a, BlockPos b, boolean horizontalOnly) {
        int distX = a.func_177958_n() - b.func_177958_n();
        int distZ = a.func_177952_p() - b.func_177952_p();
        int dist = distX * distX + distZ * distZ;
        if (!horizontalOnly) {
            int distY = a.func_177956_o() - b.func_177956_o();
            dist += distY * distY;
        }
        return dist;
    }

    public static boolean isInRange(BlockPos a, BlockPos b, double range) {
        return MathUtil.isInRange(a, b, range, false);
    }

    public static boolean isInRange(BlockPos a, BlockPos b, double range, boolean horizontalOnly) {
        return MathUtil.getDistanceSqrd(a, b, horizontalOnly) <= range * range;
    }

    public static BiInteger getXZInChunk(BlockPos pos) {
        return new BiInteger(pos.func_177958_n() & 0xF, pos.func_177952_p() & 0xF);
    }
}

