/*
 * Decompiled with CFR 0.152.
 */
package com.naxanria.mappy.util;

import com.naxanria.mappy.util.MathUtil;

public class ColorUtil {
    public static int BGRtoRGB(int col) {
        int r = col & 0xFF;
        int g = col >> 8 & 0xFF;
        int b = col >> 16 & 0xFF;
        return r << 16 | g << 8 << b;
    }

    public static int BGRAtoARGB(int col) {
        int a = col & 0xFF;
        int r = col >> 8 & 0xFF;
        int g = col >> 16 & 0xFF;
        int b = col >> 24 & 0xFF;
        return a << 24 | r << 16 | g << 8 << b;
    }

    public static int ABGRtoARGB(int col) {
        int r = col & 0xFF;
        int g = col >> 8 & 0xFF;
        int b = col >> 16 & 0xFF;
        int a = col >> 24 & 0xFF;
        return a << 24 | r << 16 | g << 8 << b;
    }

    public static int multiply(int col, float amount) {
        int r = (int)MathUtil.clamp((float)(col >> 16 & 0xFF) * amount, 0.0f, 255.0f);
        int g = (int)MathUtil.clamp((float)(col >> 8 & 0xFF) * amount, 0.0f, 255.0f);
        int b = (int)MathUtil.clamp((float)(col & 0xFF) * amount, 0.0f, 255.0f);
        return (col & 0xFF000000) + (r << 16) + (g << 8) + b;
    }

    public static int rgb(float r, float g, float b) {
        return ColorUtil.rgb((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f));
    }

    public static int rgb(int r, int g, int b) {
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public static float[] toFloats(int color) {
        float[] floats = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
        return floats;
    }

    public static float[] rgbToHsv(int color) {
        float[] rgb = ColorUtil.toFloats(color);
        return ColorUtil.rgbToHsv(rgb[0], rgb[1], rgb[2]);
    }

    public static float[] rgbToHsv(float r, float g, float b) {
        float min = r < g ? r : g;
        min = min > b ? min : b;
        float max = r > g ? r : g;
        float v = max = max > b ? max : b;
        float delta = max - min;
        if ((double)delta < 1.0E-5) {
            float s = 0.0f;
            float h = 0.0f;
            return new float[]{h, s, v};
        }
        if (!(max > 0.0f)) {
            float s = 0.0f;
            float h = 0.0f;
            return new float[]{h, s, v};
        }
        float s = delta / max;
        float h = r > max ? (g - b) / delta : (g > max ? 2.0f + (b - r) / delta : 4.0f + (r - b) / delta);
        h *= 60.0f;
        if (h < 0.0f) {
            h += 360.0f;
        }
        return new float[]{h, s, v};
    }

    public static int hsvToRgbInt(float h, float s, float v) {
        float[] rgb = ColorUtil.hsvToRgb(h, s, v);
        return ColorUtil.rgb(rgb[0], rgb[1], rgb[2]);
    }

    public static float[] hsvToRgb(float h, float s, float v) {
        float b;
        float g;
        float r;
        if (s <= 0.0f) {
            float r2 = v;
            float g2 = v;
            float b2 = v;
            return new float[]{r2, g2, b2};
        }
        float hh = h;
        if (hh >= 360.0f) {
            hh = 0.0f;
        }
        long i = (long)(hh /= 60.0f);
        float ff = hh - (float)i;
        float p = v * (1.0f - s);
        float q = v * (1.0f - s * ff);
        float t = v * (1.0f - s * (1.0f - ff));
        switch ((int)i) {
            case 0: {
                r = v;
                g = t;
                b = p;
                break;
            }
            case 1: {
                r = q;
                g = v;
                b = p;
                break;
            }
            case 2: {
                r = p;
                g = v;
                b = t;
                break;
            }
            case 3: {
                r = p;
                g = q;
                b = v;
                break;
            }
            case 4: {
                r = t;
                g = p;
                b = v;
                break;
            }
            default: {
                r = v;
                g = p;
                b = q;
            }
        }
        return new float[]{r, g, b};
    }

    public static int[] toInts(int color) {
        return new int[]{color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, color >> 24 & 0xFF};
    }
}

