/*
 * Decompiled with CFR 0.152.
 */
package com.naxanria.mappy.map.waypoint;

import com.naxanria.mappy.gui.DrawableHelperBase;
import com.naxanria.mappy.map.waypoint.WayPoint;
import com.naxanria.mappy.map.waypoint.WayPointManager;
import com.naxanria.mappy.util.MathUtil;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;

public class WayPointRenderer
extends DrawableHelperBase {
    private static WayPointRenderer renderer;
    private static WayPointManager manager;

    public static void render(float delta) {
        if (renderer == null) {
            renderer = new WayPointRenderer();
        }
        if (WayPointRenderer.client.field_71441_e == null || WayPointRenderer.client.field_71439_g == null || WayPointRenderer.client.field_71462_r != null) {
            return;
        }
        List<WayPoint> wayPoints = manager.getWaypointsToRender(WayPointRenderer.client.field_71441_e.field_73011_w.func_186058_p().func_186068_a());
        for (WayPoint wp : wayPoints) {
            renderer.renderWaypoint(wp, (PlayerEntity)WayPointRenderer.client.field_71439_g);
        }
    }

    private void renderWaypoint(WayPoint wayPoint, PlayerEntity player) {
        float dx = (float)Math.abs((double)wayPoint.pos.func_177958_n() - player.field_70165_t);
        float dy = (float)Math.abs((double)wayPoint.pos.func_177952_p() - player.field_70161_v);
        float viewAngle = Math.abs(player.field_71109_bG % 360.0f);
        float viewFov = 90.0f;
        float waypointAngle = (float)(Math.atan2(dy, dx) * 57.29577951308232);
        float angleStart = viewAngle - viewFov / 2.0f;
        float angleEnd = viewAngle + viewFov / 2.0f;
        float angle = waypointAngle % (angleEnd - angleStart) + angleStart;
        float scale = angle / viewFov;
        int size = 12;
        int x = (int)MathUtil.clamp((float)WayPointRenderer.client.field_195558_d.func_198107_o() * scale - (float)(size / 2), 0.0f, (float)(WayPointRenderer.client.field_195558_d.func_198107_o() - size));
        int y = 4;
        WayPointRenderer.diamond(x, y, size, size, wayPoint.color);
        int dist = (int)MathUtil.getDistance(wayPoint.pos, player.func_180425_c());
        this.drawStringCenteredBound(WayPointRenderer.client.field_71466_p, dist + "m", x + size / 2, y, 0, WayPointRenderer.client.field_195558_d.func_198107_o(), -1);
    }

    static {
        manager = WayPointManager.INSTANCE;
    }
}

