/*
 * Decompiled with CFR 0.152.
 */
package com.naxanria.mappy.map.waypoint;

import com.naxanria.mappy.map.waypoint.WayPoint;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.server.integrated.IntegratedServer;

public enum WayPointManager {
    INSTANCE;

    private Map<Integer, List<WayPoint>> wayPoints = new HashMap<Integer, List<WayPoint>>();

    private CompoundNBT writeToNBT(CompoundNBT tag) {
        if (tag == null) {
            tag = new CompoundNBT();
        }
        ArrayList<Integer> dimList = new ArrayList<Integer>();
        for (Integer dimension : this.wayPoints.keySet()) {
            List<WayPoint> wps = this.wayPoints.get(dimension);
            if (wps.size() == 0) continue;
            ListNBT wpsTags = new ListNBT();
            for (WayPoint wp : wps) {
                CompoundNBT wpTag = new CompoundNBT();
                wp.writeToNBT(wpTag);
                wpsTags.add((Object)wpTag);
            }
            tag.func_218657_a("wps" + dimension, (INBT)wpsTags);
            dimList.add(dimension);
        }
        tag.func_197646_b("dimensions", dimList);
        return tag;
    }

    private void readFromNBT(CompoundNBT tag) {
        int[] dimList;
        if (tag == null) {
            return;
        }
        this.wayPoints.clear();
        if (!tag.func_74764_b("dimensions")) {
            return;
        }
        for (int dim : dimList = tag.func_74759_k("dimensions")) {
            String tagName = "wps" + dim;
            if (!tag.func_74764_b(tagName)) continue;
            ListNBT wps = tag.func_150295_c(tagName, (int)tag.func_74732_a());
            for (int i = 0; i < wps.size(); ++i) {
                CompoundNBT wpsTag = wps.func_150305_b(i);
                WayPoint wayPoint = new WayPoint().readFromNBT(wpsTag);
                this.add(wayPoint);
            }
        }
    }

    public void load() {
        try {
            CompoundNBT tag = CompressedStreamTools.func_74797_a((File)this.getSaveFile());
            if (tag != null && !tag.isEmpty()) {
                this.readFromNBT(tag);
                System.out.println("Loaded waypoints");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void save() {
        try {
            CompressedStreamTools.func_74793_a((CompoundNBT)this.writeToNBT(new CompoundNBT()), (File)this.getSaveFile());
            System.out.println("Saved waypoints");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private File getSaveFile() {
        ServerData serverData;
        IntegratedServer server;
        Minecraft client = Minecraft.func_71410_x();
        File mappyDir = new File(client.field_71412_D.getAbsolutePath() + "/mappy");
        mappyDir.mkdirs();
        File saveDir = client.func_71356_B() ? ((server = Minecraft.func_71410_x().func_71401_C()) != null ? new File(mappyDir, "/local/" + server.func_71270_I() + "/") : new File(mappyDir, "/local/UNKNOWN/")) : ((serverData = client.func_147104_D()) != null ? new File(mappyDir, "/servers/" + Integer.toHexString(serverData.field_78845_b.hashCode()) + "/") : new File(mappyDir, "/servers/UNKNOWN/"));
        File saveFile = new File(saveDir, "waypoints.dat");
        saveDir.mkdirs();
        if (!saveFile.exists()) {
            try {
                saveFile.createNewFile();
                CompoundNBT emptyTag = new CompoundNBT();
                CompressedStreamTools.func_74793_a((CompoundNBT)emptyTag, (File)saveFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return saveFile;
    }

    public void add(WayPoint wayPoint) {
        Integer dimension = wayPoint.dimension;
        List<WayPoint> wps = this.getWaypoints(dimension);
        wps.add(wayPoint);
    }

    public void remove(WayPoint wayPoint) {
        Integer dimension = wayPoint.dimension;
        this.getWaypoints(dimension).remove(wayPoint);
    }

    public List<WayPoint> getWaypoints(int dimension) {
        if (!this.wayPoints.containsKey(dimension)) {
            ArrayList<WayPoint> list = new ArrayList<WayPoint>();
            this.wayPoints.put(dimension, list);
            return list;
        }
        return this.wayPoints.get(dimension);
    }

    public List<WayPoint> getWaypointsToRender(int dimension) {
        List<WayPoint> list = this.getWaypoints(dimension).stream().filter(WayPoint::show).collect(Collectors.toList());
        return list;
    }

    public List<Integer> getWaypointDimensions() {
        return new ArrayList<Integer>(this.wayPoints.keySet());
    }
}

