/*
 * Decompiled with CFR 0.152.
 */
package com.naxanria.mappy.map.waypoint;

import com.naxanria.mappy.Mappy;
import com.naxanria.mappy.gui.DrawableHelperBase;
import com.naxanria.mappy.gui.ScreenBase;
import com.naxanria.mappy.map.waypoint.WayPoint;
import com.naxanria.mappy.map.waypoint.WayPointEditor;
import com.naxanria.mappy.map.waypoint.WayPointManager;
import com.naxanria.mappy.util.BiValue;
import com.naxanria.mappy.util.MathUtil;
import com.naxanria.mappy.util.RandomUtil;
import com.naxanria.mappy.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.world.dimension.DimensionType;

public class WayPointListEditor
extends ScreenBase {
    public static final ResourceLocation DEFAULT_IDENTIFIER = new ResourceLocation("textures/block/dirt.png");
    public static final HashMap<String, BiValue<String, ResourceLocation>> DIMENSION_INFO = new HashMap<String, BiValue<String, ResourceLocation>>(){
        {
            this.put("minecraft:overworld", new BiValue<String, ResourceLocation>("mappy.dim.overworld", new ResourceLocation("textures/block/stone.png")));
            this.put("minecraft:the_nether", new BiValue<String, ResourceLocation>("mappy.dim.nether", new ResourceLocation("textures/block/nether_bricks.png")));
            this.put("minecraft:the_end", new BiValue<String, ResourceLocation>("mappy.dim.the_end", new ResourceLocation("textures/block/end_stone_bricks.png")));
        }
    };
    private static final TextComponent title = new StringTextComponent("Waypoints");
    private WayPointManager manager = WayPointManager.INSTANCE;
    private int currentDim = 0;
    private int currentDimIndex = 0;
    private List<Integer> dimensions;
    private List<WayPoint> wayPoints;
    private List<Entry> entries = new ArrayList<Entry>();
    private BiValue<String, ResourceLocation> info;
    private int scrollAmount = 0;
    private int maxScroll = 0;
    private Button prevDimensionButton;
    private Button nextDimensionButton;
    private Button addButton;
    private Button closeButton;
    private int x;
    private int y;
    private int width;
    private int height;
    private boolean canTeleport = false;

    public WayPointListEditor(Screen parent) {
        super(title, parent);
        if (this.minecraft == null) {
            this.minecraft = Minecraft.func_71410_x();
        }
        this.dimensions = this.manager.getWaypointDimensions();
        int overWorldId = DimensionType.field_223227_a_.func_186068_a();
        int netherId = DimensionType.field_223228_b_.func_186068_a();
        int theEndId = DimensionType.field_223229_c_.func_186068_a();
        if (!this.dimensions.contains(overWorldId)) {
            this.dimensions.add(overWorldId);
        }
        if (!this.dimensions.contains(netherId)) {
            this.dimensions.add(netherId);
        }
        if (!this.dimensions.contains(theEndId)) {
            this.dimensions.add(theEndId);
        }
        this.currentDim = this.minecraft.field_71439_g.field_71093_bK.func_186068_a();
        this.currentDimIndex = this.getDimIndex(this.currentDim);
    }

    protected void init() {
        this.width = Math.max(300, this.minecraft.field_195558_d.func_198107_o() / 2);
        this.height = this.minecraft.field_195558_d.func_198087_p();
        this.x = this.minecraft.field_195558_d.func_198107_o() / 2 - this.width / 2;
        this.prevDimensionButton = new Button(this.x + 10, 10, 20, 20, "<", b -> this.cycleDimension(-1));
        this.nextDimensionButton = new Button(this.x + this.width - 20 - 10, 10, 20, 20, ">", b -> this.cycleDimension(1));
        this.addButton = new Button(this.x + 10, this.height - 25, 60, 20, this.lang("create"), b -> this.add());
        this.closeButton = new Button(this.x + 15 + this.addButton.getWidth(), this.height - 25, 60, 20, this.lang("close"), b -> this.onClose());
        this.reset();
    }

    private void createEntries() {
        this.entries.clear();
        int y = 40;
        for (WayPoint wp : this.wayPoints) {
            Entry entry = new Entry(this, this.x + 10, this.scrollAmount + y, this.width - 10 - 10, 20, wp);
            this.entries.add(entry);
            y += entry.height;
        }
    }

    private void updateEntries() {
        int y = 40;
        for (Entry entry : this.entries) {
            entry.setPosition(this.x + 10, this.scrollAmount + y);
            y += entry.height;
        }
    }

    private void cycleDimension(int i) {
        this.currentDimIndex += i;
        if (this.currentDimIndex >= this.dimensions.size()) {
            this.currentDimIndex = 0;
        } else if (this.currentDimIndex < 0) {
            this.currentDimIndex = this.dimensions.size() - 1;
        }
        this.currentDim = this.dimensions.get(this.currentDimIndex);
        this.reset();
    }

    private int getDimIndex(int dim) {
        for (int i = 0; i < this.dimensions.size(); ++i) {
            int dimId = this.dimensions.get(i);
            if (dimId != dim) continue;
            return i;
        }
        return 0;
    }

    public void reset() {
        this.info = this.getDimensionInfo(this.currentDim);
        this.wayPoints = this.manager.getWaypoints(this.currentDim);
        this.createEntries();
        this.maxScroll = this.wayPoints.size() * 20;
        this.children.clear();
        this.children.addAll(this.entries);
        this.children.add(this.addButton);
        this.children.add(this.closeButton);
        this.children.add(this.prevDimensionButton);
        this.children.add(this.nextDimensionButton);
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        WayPointListEditor.fill((int)this.x, (int)0, (int)(this.x + this.width), (int)this.height, (int)0x33444444);
        this.entries.forEach(e -> e.render(mouseX, mouseY, partialTicks));
        this.drawBorders(mouseX, mouseY, partialTicks);
        this.prevDimensionButton.render(mouseX, mouseY, partialTicks);
        String dimensionName = this.info == null ? this.lang("unknown") : I18n.func_135052_a((String)((String)this.info.A), (Object[])new Object[0]);
        this.drawCenteredString(this.font, dimensionName, 65 + this.prevDimensionButton.x + this.prevDimensionButton.getWidth(), 15, -1);
        this.nextDimensionButton.render(mouseX, mouseY, partialTicks);
        this.addButton.render(mouseX, mouseY, partialTicks);
        this.closeButton.render(mouseX, mouseY, partialTicks);
        this.drawScrollBar();
    }

    private BiValue<String, ResourceLocation> getDimensionInfo(int dim) {
        ResourceLocation rl;
        DimensionType type = DimensionType.func_186069_a((int)dim);
        String key = "unknown";
        if (type != null && (rl = DimensionType.func_212678_a((DimensionType)type)) != null) {
            key = rl.toString();
        }
        if (key.equals("unknown")) {
            Mappy.LOGGER.warn("Unknown dim: " + dim);
        }
        return DIMENSION_INFO.getOrDefault(key, new BiValue<String, ResourceLocation>(key, DEFAULT_IDENTIFIER));
    }

    private void drawScrollBar() {
    }

    private void drawBorders(int mouseX, int mouseY, float delta) {
        ResourceLocation id;
        if (this.info != null) {
            id = (ResourceLocation)this.info.B;
            if (id == null) {
                id = DEFAULT_IDENTIFIER;
            }
        } else {
            id = DEFAULT_IDENTIFIER;
        }
        this.renderTextureRepeating(this.x, 0, this.width, 40, 16, 16, id);
        this.renderTextureRepeating(this.x, this.height - 40, this.width, 40, 16, 16, id);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private void edit(WayPoint wayPoint) {
        this.minecraft.func_147108_a((Screen)new WayPointEditor(wayPoint, this, null));
    }

    private boolean canTeleport() {
        return true;
    }

    private void teleport(WayPoint wayPoint) {
        Mappy.LOGGER.info("Teleporting");
        if (this.canTeleport()) {
            BlockPos pos = wayPoint.pos;
            this.minecraft.field_71439_g.func_71165_d("/tp " + pos.func_177958_n() + " " + pos.func_177956_o() + " " + pos.func_177952_p());
            this.minecraft.func_147108_a(null);
            Mappy.LOGGER.info("Teleported to " + pos.func_177958_n() + " " + pos.func_177956_o() + " " + pos.func_177952_p());
        }
    }

    private void toChat(WayPoint wp) {
    }

    private void add() {
        WayPoint wayPoint = new WayPoint();
        wayPoint.dimension = this.currentDim;
        wayPoint.color = RandomUtil.getElement(WayPoint.WAYPOINT_COLORS);
        wayPoint.pos = this.minecraft.field_71439_g.func_180425_c();
        wayPoint.name = "Waypoint";
        this.minecraft.func_147108_a((Screen)new WayPointEditor(wayPoint, this, this.manager::add));
    }

    private void delete(WayPoint wayPoint) {
        this.manager.remove(wayPoint);
        this.manager.save();
        this.reset();
    }

    public boolean mouseScrolled(double double_1, double double_2, double double_3) {
        this.scrollAmount = MathUtil.clamp(this.scrollAmount + (int)(double_3 * 12.0), -this.maxScroll + 80, 0);
        this.updateEntries();
        return true;
    }

    private static class Entry
    extends DrawableHelperBase
    implements IGuiEventListener {
        private static Minecraft minecraft = Minecraft.func_71410_x();
        private int x;
        private int y;
        private int width;
        private int height;
        private WayPoint wayPoint;
        private Button editButton;
        private Button deleteButton;
        private Button teleportButton;
        private WayPointListEditor wayPointListEditor;

        public Entry(WayPointListEditor wayPointListEditor, int x, int y, int width, int height, WayPoint wayPoint) {
            this.width = width;
            this.height = height;
            this.wayPoint = wayPoint;
            this.wayPointListEditor = wayPointListEditor;
            this.editButton = new Button(0, 0, 40, height, wayPointListEditor.lang("edit"), b -> wayPointListEditor.edit(wayPoint));
            this.deleteButton = new Button(0, 0, 40, height, wayPointListEditor.lang("delete"), b -> wayPointListEditor.delete(wayPoint));
            this.teleportButton = new Button(0, 0, 40, height, wayPointListEditor.lang("teleport"), b -> wayPointListEditor.teleport(wayPoint));
            this.setPosition(x, y);
        }

        public void setPosition(int x, int y) {
            this.x = x;
            this.y = y;
            this.rightAlign(this.teleportButton, x + this.width);
            this.rightAlign(this.deleteButton, this.teleportButton);
            this.rightAlign(this.editButton, this.deleteButton);
            this.editButton.y = y;
            this.deleteButton.y = y;
            this.teleportButton.y = y;
        }

        public void render(int mouseX, int mouseY, float delta) {
            FontRenderer font = Entry.minecraft.field_71466_p;
            boolean hover = this.isMouseOver(mouseX, mouseY);
            int bgColor = hover ? -2002081110 : -2009910477;
            Entry.fill((int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)bgColor);
            int size = this.height - 2;
            this.wayPoint.iconType.draw(this.x + size / 2, this.y + 1 + size / 2, this.wayPoint.color);
            int stringY = this.y + 6;
            int nameX = this.x + size + 2;
            this.drawString(font, this.wayPoint.name, nameX, stringY, -1);
            int posX = this.editButton.x - 2;
            this.drawRightAlignedString(font, Util.prettyFy(this.wayPoint.pos), posX, stringY, -1);
            this.teleportButton.render(mouseX, mouseY, delta);
            this.editButton.render(mouseX, mouseY, delta);
            this.deleteButton.render(mouseX, mouseY, delta);
        }

        public boolean mouseClicked(double double_1, double double_2, int int_1) {
            return this.editButton.mouseClicked(double_1, double_2, int_1) || this.deleteButton.mouseClicked(double_1, double_2, int_1) || this.teleportButton.mouseClicked(double_1, double_2, int_1);
        }

        public boolean mouseReleased(double double_1, double double_2, int int_1) {
            return this.editButton.mouseReleased(double_1, double_2, int_1) || this.deleteButton.mouseReleased(double_1, double_2, int_1) || this.teleportButton.mouseReleased(double_1, double_2, int_1);
        }

        public boolean isMouseOver(double mouseX, double mouseY) {
            return mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.height);
        }

        private void rightAlign(Button toAlign, Button from) {
            toAlign.x = from.x - toAlign.getWidth();
        }

        private void rightAlign(Button toAlign, int right) {
            toAlign.x = right - toAlign.getWidth();
        }
    }
}

