/*
 * Decompiled with CFR 0.152.
 */
package com.naxanria.mappy.map.waypoint;

import com.naxanria.mappy.gui.ScreenBase;
import com.naxanria.mappy.gui.widget.TitledWidget;
import com.naxanria.mappy.gui.widget.WaypointTypeSelectorWidget;
import com.naxanria.mappy.map.waypoint.WayPoint;
import com.naxanria.mappy.map.waypoint.WayPointManager;
import com.naxanria.mappy.util.Predicates;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;

public class WayPointEditor
extends ScreenBase {
    private static final StringTextComponent title = new StringTextComponent("Edit Waypoint");
    private final WayPoint wayPoint;
    private int colorIndex;
    private TitledWidget<TextFieldWidget> nameField;
    private Button prevColorButton;
    private Button nextColorButton;
    private WaypointTypeSelectorWidget typeSelectorWidget;
    private TextFieldWidget xField;
    private TextFieldWidget yField;
    private TextFieldWidget zField;
    private Button saveButton;
    private Button cancelButton;
    private Consumer<WayPoint> onSaveCallback;

    public WayPointEditor(WayPoint wayPoint, Screen parent, Consumer<WayPoint> onSaveCallback) {
        super((TextComponent)title, parent);
        this.wayPoint = wayPoint;
        this.colorIndex = this.getColorIndex(wayPoint.color);
        this.onSaveCallback = onSaveCallback;
    }

    public void init() {
        int halfWidth = this.width / 2;
        int halfW = 75;
        int h = 20;
        int x = halfWidth - halfW;
        this.nameField = new TitledWidget<TextFieldWidget>(this.font, new TextFieldWidget(this.font, 0, 0, 100, 12, "Name"), x, 50, 180, h, "", this.lang("name"));
        this.nameField.changeFocus(true);
        ((TextFieldWidget)this.nameField.widget).func_146203_f(12);
        ((TextFieldWidget)this.nameField.widget).func_146180_a(this.wayPoint.name);
        this.children.add(this.nameField);
        Predicate<String> validNumber = s -> Predicates.or(s, Predicates.isInteger, Predicates.isEmpty);
        int pw = 60;
        this.xField = new TextFieldWidget(this.font, x, 70, pw, h, "");
        this.xField.func_200675_a(validNumber);
        this.xField.func_146203_f(7);
        this.xField.func_146180_a(this.wayPoint.pos.func_177958_n() + "");
        this.yField = new TextFieldWidget(this.font, x + pw, 70, pw, h, "");
        this.yField.func_200675_a(validNumber);
        this.yField.func_146203_f(7);
        this.yField.func_146180_a(this.wayPoint.pos.func_177956_o() + "");
        this.zField = new TextFieldWidget(this.font, x + pw + pw, 70, pw, h, "");
        this.zField.func_200675_a(validNumber);
        this.zField.func_146203_f(7);
        this.zField.func_146180_a(this.wayPoint.pos.func_177952_p() + "");
        this.children.add(this.xField);
        this.children.add(this.yField);
        this.children.add(this.zField);
        int bw = 20;
        this.prevColorButton = new Button(x, 92, bw, h, "<", b -> this.cycleColor(-1));
        this.children.add(this.prevColorButton);
        this.nextColorButton = new Button(x + halfWidth - bw - 30, 92, bw, h, ">", b -> this.cycleColor(1));
        this.children.add(this.nextColorButton);
        this.typeSelectorWidget = new WaypointTypeSelectorWidget(x, 114, "", this);
        this.children.add(this.typeSelectorWidget);
        int by = this.height - 90;
        this.saveButton = new Button(x, by, 60, h, this.lang("save"), b -> {
            this.save();
            this.onClose();
        });
        this.children.add(this.saveButton);
        this.cancelButton = new Button(x + 62, by, 60, h, this.lang("cancel"), b -> this.onClose());
        this.children.add(this.cancelButton);
        this.setFocused((IGuiEventListener)this.nameField);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private void cycleColor(int i) {
        this.colorIndex += i;
        if (this.colorIndex < 0) {
            this.colorIndex = WayPoint.WAYPOINT_COLORS.length - 1;
        } else if (this.colorIndex >= WayPoint.WAYPOINT_COLORS.length) {
            this.colorIndex = 0;
        }
    }

    private void save() {
        this.wayPoint.name = ((TextFieldWidget)this.nameField.widget).func_146179_b();
        this.wayPoint.color = WayPoint.WAYPOINT_COLORS[this.colorIndex];
        int xPos = this.xField.func_146179_b().isEmpty() ? 0 : Integer.parseInt(this.xField.func_146179_b());
        int yPos = this.yField.func_146179_b().isEmpty() ? 0 : Integer.parseInt(this.yField.func_146179_b());
        int zPos = this.zField.func_146179_b().isEmpty() ? 0 : Integer.parseInt(this.zField.func_146179_b());
        this.wayPoint.pos = new BlockPos(xPos, yPos, zPos);
        this.wayPoint.iconType = this.typeSelectorWidget.getSelectedType();
        if (this.onSaveCallback != null) {
            this.onSaveCallback.accept(this.wayPoint);
        }
        WayPointManager.INSTANCE.save();
    }

    @Override
    public void onClose() {
        this.minecraft.func_147108_a(this.parent);
    }

    @Override
    public void renderForeground() {
        int x = this.prevColorButton.x + this.prevColorButton.getWidth() + 2;
        int w = this.nextColorButton.x - x - 2;
        int y = this.prevColorButton.y + 3;
        int h = 12;
        int col = this.getPreviewColor();
        this.borderedRect(x, y, w, h, col, 2, -3355444);
    }

    public void tick() {
    }

    private void rect(int x, int y, int w, int h, int color) {
        WayPointEditor.fill((int)x, (int)y, (int)(x + w), (int)(y + h), (int)color);
    }

    private void borderedRect(int x, int y, int w, int h, int color, int borderColor) {
        this.borderedRect(x, y, w, h, color, 2, borderColor);
    }

    private void borderedRect(int x, int y, int w, int h, int color, int border, int borderColor) {
        int hb = border >> 1;
        this.rect(x, y, w, h, borderColor);
        this.rect(x + hb, y + hb, w - border, h - border, color);
    }

    private int getColorIndex(int color) {
        for (int i = 0; i < WayPoint.WAYPOINT_COLORS.length; ++i) {
            if (WayPoint.WAYPOINT_COLORS[i] != color) continue;
            return i;
        }
        return 0;
    }

    public boolean keyPressed(int int_1, int int_2, int int_3) {
        if (int_1 == 257) {
            this.save();
            this.onClose();
            return true;
        }
        return super.keyPressed(int_1, int_2, int_3);
    }

    public WayPoint getWaypoint() {
        return this.wayPoint;
    }

    public int getPreviewColor() {
        return WayPoint.WAYPOINT_COLORS[this.colorIndex];
    }
}

