/*
 * Decompiled with CFR 0.152.
 */
package com.naxanria.mappy.map.waypoint;

import com.naxanria.mappy.map.waypoint.IconType;
import com.naxanria.mappy.util.MathUtil;
import com.naxanria.mappy.util.Serializable;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;

public class WayPoint
implements Serializable<WayPoint> {
    public static final Integer[] WAYPOINT_COLORS = new Integer[]{-1, -65536, -256, -16711681, -16711936, -16733696, -16776961, -30720, -65281, -16777216, -5635926, -7829368, -21846, -5570646, -5592321};
    public String name = "";
    public BlockPos pos = new BlockPos(0, 0, 0);
    public int dimension;
    public int color;
    public boolean showAlways;
    public boolean hidden;
    public int showRange = 5000;
    public IconType iconType = IconType.DIAMOND;
    public boolean deathPoint = false;

    public boolean show() {
        return !this.hidden && (this.showAlways || MathUtil.getDistance(this.pos, Minecraft.func_71410_x().field_71439_g.func_180425_c(), true) <= (double)this.showRange);
    }

    @Override
    public WayPoint writeToNBT(CompoundNBT tag) {
        if (tag != null) {
            tag.func_74778_a("name", this.name);
            tag.func_218657_a("pos", (INBT)NBTUtil.func_186859_a((BlockPos)this.pos));
            tag.func_74768_a("dimension", this.dimension);
            tag.func_74768_a("color", this.color);
            tag.func_74757_a("showAlways", this.showAlways);
            tag.func_74757_a("hidden", this.hidden);
            tag.func_74768_a("showRange", this.showRange);
            tag.func_74768_a("icon", this.iconType.ordinal());
            tag.func_74757_a("death", this.deathPoint);
        }
        return this;
    }

    @Override
    public WayPoint readFromNBT(CompoundNBT tag) {
        if (tag != null) {
            this.name = tag.func_74779_i("name");
            this.pos = NBTUtil.func_186861_c((CompoundNBT)tag.func_74775_l("pos"));
            this.dimension = tag.func_74762_e("dimension");
            this.color = tag.func_74762_e("color");
            this.showAlways = tag.func_74767_n("showAlways");
            this.hidden = tag.func_74767_n("hidden");
            this.showRange = tag.func_74762_e("showRange");
            int icon = 0;
            if (tag.func_74764_b("icon")) {
                icon = tag.func_74762_e("icon");
            }
            this.iconType = IconType.values()[icon];
            this.deathPoint = tag.func_74764_b("death") && tag.func_74767_n("death");
        }
        return this;
    }
}

