/*
 * Decompiled with CFR 0.152.
 */
package com.naxanria.mappy.map.waypoint;

import com.mojang.blaze3d.platform.GlStateManager;
import com.naxanria.mappy.gui.DrawableHelperBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;

public enum IconType {
    DIAMOND(null, 8),
    SQUARE(null, 8),
    TRIANGLE(null, 8),
    SKULL(new ResourceLocation("mappy", "textures/icons/skull.png"), 8),
    HOUSE(new ResourceLocation("mappy", "textures/icons/house.png"), 8);

    ResourceLocation texture;
    int size;

    private IconType(ResourceLocation texture, int size) {
        this.texture = texture;
        this.size = size;
    }

    public void draw(int x, int y, int color) {
        IconType.draw(this, x, y, color);
    }

    public static void draw(IconType type, int x, int y, int color) {
        int size = type.size;
        int hsize = size / 2;
        GlStateManager.pushMatrix();
        switch (type) {
            case DIAMOND: {
                DrawableHelperBase.diamond(x - hsize, y - hsize, size, size, color);
                break;
            }
            case SQUARE: {
                DrawableHelperBase.fill((int)(x - hsize), (int)(y - hsize), (int)(x + hsize), (int)(y + hsize), (int)color);
                break;
            }
            case TRIANGLE: {
                DrawableHelperBase.triangle(x - hsize, y + hsize, x + hsize, y + hsize, x, y - hsize, color);
                break;
            }
            default: {
                ResourceLocation texture = type.texture;
                if (texture == null) {
                    IconType.draw(SQUARE, x, y, -65281);
                    break;
                }
                Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder builder = tessellator.func_178180_c();
                builder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                double z = 0.0;
                builder.func_181662_b((double)(x -= hsize), (double)((y -= hsize) + size), z).func_187315_a(0.0, 1.0).func_181669_b(255, 255, 255, 255).func_181675_d();
                builder.func_181662_b((double)(x + size), (double)(y + size), z).func_187315_a(1.0, 1.0).func_181669_b(255, 255, 255, 255).func_181675_d();
                builder.func_181662_b((double)(x + size), (double)y, z).func_187315_a(1.0, 0.0).func_181669_b(255, 255, 255, 255).func_181675_d();
                builder.func_181662_b((double)x, (double)y, z).func_187315_a(0.0, 0.0).func_181669_b(255, 255, 255, 255).func_181675_d();
                tessellator.func_78381_a();
            }
        }
        GlStateManager.popMatrix();
    }
}

