/*
 * Decompiled with CFR 0.152.
 */
package com.naxanria.mappy.map.chunk;

import com.naxanria.mappy.map.chunk.ChunkData;
import com.naxanria.mappy.util.Position2D;
import com.naxanria.mappy.util.Serializable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;

public class SuperChunk
implements Serializable<SuperChunk> {
    private Position2D position;
    private ChunkData[] chunks;
    private int dimension;
    boolean toSave = false;

    public SuperChunk(int x, int z) {
        this.position = new Position2D(x, z);
        this.prepareChunksList();
    }

    public SuperChunk(CompoundNBT tag) {
        this.prepareChunksList();
        this.readFromNBT(tag);
    }

    public ChunkData getChunk(int chunkX, int chunkZ) {
        int x = chunkX & 0xF;
        int z = chunkZ & 0xF;
        int pos = x + z * 16;
        return this.chunks[pos];
    }

    void setChunk(ChunkData data) {
        this.chunks[this.getListPosition((ChunkData)data)] = data;
    }

    @Override
    public SuperChunk writeToNBT(CompoundNBT tag) {
        tag.func_74768_a("X", this.position.getX());
        tag.func_74768_a("Z", this.position.getY());
        tag.func_74768_a("Dimension", this.dimension);
        ListNBT nbtList = new ListNBT();
        for (int i = 0; i < this.chunks.length; ++i) {
            ChunkData chunkData = this.chunks[i];
            if (chunkData == null) continue;
            nbtList.add((Object)ChunkData.toTag(chunkData));
        }
        tag.func_218657_a("Chunks", (INBT)nbtList);
        return this;
    }

    @Override
    public SuperChunk readFromNBT(CompoundNBT tag) {
        int x = tag.func_74762_e("X");
        int z = tag.func_74762_e("Z");
        int dim = tag.func_74762_e("Dimension");
        this.position = new Position2D(x, z);
        this.dimension = dim;
        ListNBT chunksList = tag.func_150295_c("Chunks", 10);
        this.prepareChunksList();
        for (int i = 0; i < chunksList.size(); ++i) {
            CompoundNBT chunkCompound = chunksList.func_150305_b(i);
            ChunkData chunkData = ChunkData.fromTag(chunkCompound, null);
            if (chunkData == null) continue;
            this.setChunk(chunkData);
        }
        return this;
    }

    public int getDimension() {
        return this.dimension;
    }

    private void prepareChunksList() {
        if (this.chunks == null) {
            this.chunks = new ChunkData[256];
        }
        for (int i = 0; i < 256; ++i) {
            this.chunks[i] = null;
        }
    }

    private int getListPosition(ChunkData data) {
        return this.getListPosition(data.cx, data.cz);
    }

    private int getListPosition(int cx, int cz) {
        return (cx & 0xF) + (cz & 0xF) * 16;
    }

    public int getX() {
        return this.position.getX();
    }

    public int getZ() {
        return this.position.getY();
    }

    public static Position2D getSuperChunkPosition(BlockPos pos) {
        int cx = pos.func_177958_n() / 16;
        int cz = pos.func_177952_p() / 16;
        return new Position2D(cx / 16, cz / 16);
    }

    public static Position2D getSuperChunkPosition(ChunkPos pos) {
        return new Position2D(pos.field_77276_a / 16, pos.field_77275_b / 16);
    }

    public static Position2D getSuperChunkPosition(int chunkX, int chunkZ) {
        return new Position2D(chunkX / 16, chunkZ / 16);
    }
}

