/*
 * Decompiled with CFR 0.152.
 */
package com.naxanria.mappy.map.chunk;

import com.naxanria.mappy.Mappy;
import com.naxanria.mappy.map.chunk.SuperChunk;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;

public class ChunkIOManager {
    private static int nextID = 0;
    private File subDir;
    Thread thread;
    private List<SuperChunk> toSave = new ArrayList<SuperChunk>();
    private List<SuperChunk> nextToSave = new ArrayList<SuperChunk>();
    private boolean saving = false;
    private boolean watching = true;
    public final int ID = ChunkIOManager.getID();

    private static int getID() {
        return nextID++;
    }

    public ChunkIOManager(File subDir) {
        Mappy.LOGGER.info("Started chunk manager #" + this.ID);
        this.subDir = subDir;
        this.thread = new Thread(this::run);
        this.thread.start();
    }

    public void MarkForSave(SuperChunk chunk) {
        if (chunk.toSave) {
            return;
        }
        chunk.toSave = true;
        this.toSave.add(chunk);
    }

    public void startSave() {
        this.saving = true;
    }

    private void run() {
        while (this.watching) {
            if (this.saving) {
                this.saveAll();
                this.saving = false;
            }
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void stop() {
        Mappy.LOGGER.info("Stopping IOManager #" + this.ID);
        this.watching = false;
    }

    private void saveAll() {
        List<SuperChunk> temp = this.nextToSave;
        this.nextToSave = this.toSave;
        this.toSave = temp;
        int s = this.nextToSave.size();
        if (s == 0) {
            return;
        }
        long start = System.currentTimeMillis();
        int n = 0;
        for (int i = 0; i < this.nextToSave.size() && n < 100; ++i, ++n) {
            SuperChunk superChunk = this.nextToSave.get(i);
            if (superChunk != null) {
                this.save(superChunk);
                superChunk.toSave = false;
            }
            this.nextToSave.remove(i--);
        }
        long time = System.currentTimeMillis() - start;
        Mappy.LOGGER.info("Saved " + n + " [" + s + "] chunks in " + time + "ms");
    }

    private void save(SuperChunk superChunk) {
        File file = this.getFile(superChunk.getDimension(), superChunk.getX(), superChunk.getZ());
        CompoundNBT tag = new CompoundNBT();
        superChunk.writeToNBT(tag);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            CompressedStreamTools.func_74793_a((CompoundNBT)tag, (File)file);
        }
        catch (IOException e) {
            Mappy.LOGGER.error("Failed to write chunk data to '" + file + "'");
            e.printStackTrace();
        }
    }

    SuperChunk load(File file) {
        if (!file.exists()) {
            return null;
        }
        try {
            CompoundNBT tag = CompressedStreamTools.func_74797_a((File)file);
            if (tag != null) {
                Mappy.LOGGER.info("Loading " + tag.func_74762_e("X") + "," + tag.func_74762_e("Z"));
                return new SuperChunk(tag);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    File getFile(int worldId, int cx, int cz) {
        String id = "sc_" + cx + "_" + cz + ".dat";
        File subDir = this.subDir;
        if (!subDir.exists()) {
            Mappy.LOGGER.info("Creating folder 'data'");
            subDir.mkdir();
        }
        if (!(subDir = new File(subDir, worldId + "/")).exists()) {
            Mappy.LOGGER.info("Creating folder '" + worldId + "'");
            subDir.mkdir();
        }
        return new File(subDir, id);
    }
}

