/*
 * Decompiled with CFR 0.152.
 */
package com.naxanria.mappy.map.chunk;

import com.naxanria.mappy.config.MappyConfig;
import com.naxanria.mappy.map.MapLayer;
import com.naxanria.mappy.map.MapLayerProcessor;
import com.naxanria.mappy.util.BiValue;
import com.naxanria.mappy.util.MathUtil;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.Heightmap;

public class ChunkData {
    public int cx;
    public int cz;
    public int[] heightmap;
    public NativeImage image = new NativeImage(NativeImage.PixelFormat.RGBA, 16, 16, false);
    public long time;
    public MapLayer layer;
    public Chunk chunk;
    private boolean nether;
    private boolean updating;

    private ChunkData() {
    }

    public ChunkData(Chunk chunk, MapLayer layer) {
        ChunkPos pos = chunk.func_76632_l();
        this.cx = pos.field_77276_a;
        this.cz = pos.field_77275_b;
        this.time = System.currentTimeMillis();
        this.layer = layer;
        this.chunk = chunk;
        this.nether = chunk.func_177412_p().func_201675_m().func_186058_p() == DimensionType.field_223228_b_;
        this.heightmap = new int[256];
        Arrays.fill(this.heightmap, -1);
    }

    void setChunk(Chunk chunk) {
        this.chunk = chunk;
    }

    public boolean update() {
        if (this.updating) {
            return false;
        }
        long now = System.currentTimeMillis();
        this.updating = true;
        boolean change = false;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int col = -16777216;
                int oldCol = this.image.func_195709_a(x, z);
                int oldHeight = this.heightmap[x + z * 16];
                switch (this.layer) {
                    case TOP_VIEW: {
                        if (this.nether) {
                            col = MapLayerProcessor.processTopViewNether(this, x, (int)Minecraft.func_71410_x().field_71439_g.field_70163_u - 1, z);
                        } else {
                            this.heightmap[x + z * 16] = MappyConfig.forceHeightmap ? this.chunk.func_177412_p().func_201676_a(Heightmap.Type.WORLD_SURFACE, this.cx * 16 + x, this.cz * 16 + z) - 1 : MapLayerProcessor.getHeight(this.chunk.func_177412_p(), this.getPosition(x, 0, z), false);
                            col = MapLayerProcessor.processTopView(this, x, z);
                        }
                        if (this.heightmap[x + z * 16] == oldHeight && col == oldCol) break;
                        change = true;
                        break;
                    }
                }
                if (!this.updating) {
                    this.time = now;
                    return false;
                }
                this.image.func_195700_a(x, z, col);
                if (!MappyConfig.shaded) continue;
                this.image.func_195718_b(x, z, MapLayerProcessor.shadeTopView(this, x, z));
            }
        }
        this.time = now;
        this.updating = false;
        return change;
    }

    public BlockPos getPosition(int xOff, int y, int zOff) {
        ChunkPos chunkPos = this.chunk.func_76632_l();
        return new BlockPos(chunkPos.field_77276_a * 16 + xOff, y, chunkPos.field_77275_b * 16 + zOff);
    }

    public static ChunkData fromTag(CompoundNBT tag, World world) {
        ChunkData data = new ChunkData();
        data.cx = tag.func_74762_e("CX");
        data.cz = tag.func_74762_e("CZ");
        data.layer = MapLayer.values()[MathUtil.clamp(tag.func_74762_e("MAP_LAYER"), 0, MapLayer.values().length - 1)];
        if (!tag.func_74764_b("DATA")) {
            return null;
        }
        BiValue<int[], NativeImage> unpackedData = ChunkData.loadDataArray(tag.func_74759_k("DATA"));
        data.heightmap = (int[])unpackedData.A;
        data.image = (NativeImage)unpackedData.B;
        return data;
    }

    public static CompoundNBT toTag(ChunkData data) {
        return ChunkData.toTag(data, null);
    }

    public static CompoundNBT toTag(ChunkData data, CompoundNBT tag) {
        if (tag == null) {
            tag = new CompoundNBT();
        }
        tag.func_74768_a("CX", data.cx);
        tag.func_74768_a("CZ", data.cz);
        tag.func_74768_a("MAP_LAYER", data.layer.ordinal());
        tag.func_74783_a("DATA", ChunkData.getDataArray(data.heightmap, data.image));
        return tag;
    }

    private static int[] getDataArray(int[] heightmap, NativeImage image) {
        int[] baseData = new int[256];
        for (int i = 0; i < baseData.length; ++i) {
            baseData[i] = image.func_195709_a(i % 16, i / 16) >> 8 << 8 | heightmap[i];
        }
        return baseData;
    }

    private static BiValue<int[], NativeImage> loadDataArray(int[] dataArray) {
        int[] heightmap = new int[256];
        NativeImage image = new NativeImage(NativeImage.PixelFormat.RGBA, 16, 16, true);
        for (int i = 0; i < heightmap.length; ++i) {
            int data = dataArray[i];
            int height = data & 0xFF;
            int col = data << 8 | 0xFF;
            image.func_195700_a(i % 16, i / 16, col);
            heightmap[i] = height;
        }
        return new BiValue<int[], NativeImage>(heightmap, image);
    }

    public int cancelUpdate() {
        this.updating = false;
        return -1;
    }
}

