/*
 * Decompiled with CFR 0.152.
 */
package com.naxanria.mappy.map.chunk;

import com.naxanria.mappy.Mappy;
import com.naxanria.mappy.config.MappyConfig;
import com.naxanria.mappy.map.Map;
import com.naxanria.mappy.map.MapLayer;
import com.naxanria.mappy.map.chunk.ChunkData;
import com.naxanria.mappy.map.chunk.ChunkIOManager;
import com.naxanria.mappy.map.chunk.SuperChunk;
import com.naxanria.mappy.util.BiInteger;
import com.naxanria.mappy.util.ImageUtil;
import com.naxanria.mappy.util.MappyFileUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class ChunkCache {
    private static final NativeImage BLACK_IMAGE = new NativeImage(NativeImage.PixelFormat.RGBA, 16, 16, false);
    private static MapLayer currentLayer = MapLayer.TOP_VIEW;
    private static HashMap<Integer, HashMap<MapLayer, ChunkCache>> instances = new HashMap();
    public final MapLayer layer;
    public World world;
    private HashMap<BiInteger, SuperChunk> data = new HashMap();
    private ChunkIOManager ioManager;
    private int updateIndex = 0;
    private int updatePerCycle = 10;
    private long lastPrune = 0L;
    private long lastSave = 0L;
    private long pruneDelay = 1000L;
    private int pruneAmount = 500;

    public static void setCurrentLayer(MapLayer layer) {
        currentLayer = layer;
    }

    public static MapLayer getCurrentLayer() {
        return currentLayer;
    }

    public static ChunkCache getPreLoader(World world, MapLayer layer) {
        MapLayer temp = currentLayer;
        currentLayer = layer;
        ChunkCache loader = ChunkCache.getPreLoader(world);
        currentLayer = temp;
        return loader;
    }

    public static ChunkCache getPreLoader(World world) {
        int dimId = world.field_73011_w.func_186058_p().func_186068_a();
        HashMap<MapLayer, ChunkCache> layers = ChunkCache.getLayers(dimId);
        if (layers.containsKey((Object)currentLayer)) {
            ChunkCache loader = layers.get((Object)currentLayer);
            if (loader.world != world) {
                loader.world = world;
                loader.clear();
                NativeImage img = Mappy.map.getImage();
                img.func_195715_a(0, 0, img.func_195702_a(), img.func_195714_b(), -16777216);
                System.out.println("Updated world " + world + " " + dimId);
            }
            return loader;
        }
        ChunkCache loader = new ChunkCache(currentLayer, world);
        layers.put(currentLayer, loader);
        return loader;
    }

    private void clear() {
        this.data.clear();
    }

    private static HashMap<MapLayer, ChunkCache> getLayers(int dimId) {
        if (instances.containsKey(dimId)) {
            return instances.get(dimId);
        }
        HashMap<MapLayer, ChunkCache> layers = new HashMap<MapLayer, ChunkCache>();
        instances.put(dimId, layers);
        return layers;
    }

    private ChunkCache(MapLayer layer, World world) {
        this.layer = layer;
        this.world = world;
        this.ioManager = new ChunkIOManager(MappyFileUtil.createSubDir(MappyFileUtil.getSaveDirectory(), "/data/"));
    }

    public void update(Map map, int x, int z) {
        this.update(map.getImage(), map.getSize(), x, z);
    }

    public void update(NativeImage image, int size, int x, int z) {
        this.updatePerCycle = MappyConfig.updatePerCycle;
        this.pruneDelay = MappyConfig.pruneDelay * 1000;
        this.pruneAmount = MappyConfig.pruneAmount;
        int chunksSize = size / 16 + 4;
        int cxStart = x / 16 - 2;
        int cxEnd = cxStart + chunksSize;
        int czStart = z / 16 - 2;
        int czEnd = czStart + chunksSize;
        int xOff = cxStart * 16 - x;
        int zOff = czStart * 16 - z;
        long now = System.currentTimeMillis();
        int i = 0;
        int px = 0;
        for (int cx = cxStart; cx < cxEnd; ++cx) {
            int pz = 0;
            for (int cz = czStart; cz < czEnd; ++cz) {
                ChunkData chunkData = this.getChunk(cx, cz);
                if (++i >= this.updateIndex && i <= this.updateIndex + this.updatePerCycle && now - chunkData.time >= 100L) {
                    Chunk chunk;
                    if (chunkData.chunk.func_76621_g() && !(chunk = this.world.func_212866_a_(cx, cz)).func_76621_g()) {
                        chunkData.chunk = chunk;
                        chunkData.cx = chunk.func_76632_l().field_77276_a;
                        chunkData.cz = chunk.func_76632_l().field_77275_b;
                    }
                    if (!chunkData.chunk.func_76621_g() && chunkData.update()) {
                        this.markForSave(chunkData);
                    }
                }
                ImageUtil.writeIntoImage(chunkData.image, image, px * 16 + xOff, pz * 16 + zOff);
                ++pz;
            }
            ++px;
        }
        this.updateIndex += this.updatePerCycle;
        if (this.updateIndex >= chunksSize * chunksSize) {
            this.updateIndex = 0;
        }
        if (MappyConfig.enableWorldMapKey && now - this.lastSave > 120000L) {
            this.ioManager.startSave();
            this.lastSave = now;
        }
    }

    private void prune(int max) {
    }

    public SuperChunk getSuperChunk(int cx, int cz) {
        BiInteger key = new BiInteger(cx / 16, cz / 16);
        if (this.data.containsKey(key)) {
            return this.data.get(key);
        }
        SuperChunk loaded = null;
        if (MappyConfig.enableWorldMapKey) {
            loaded = this.ioManager.load(this.ioManager.getFile(this.world.field_73011_w.func_186058_p().func_186068_a(), (Integer)key.A, (Integer)key.B));
        }
        if (loaded == null) {
            loaded = new SuperChunk((Integer)key.A, (Integer)key.B);
            this.ioManager.MarkForSave(loaded);
        }
        this.data.put(key, loaded);
        return loaded;
    }

    public void markForSave(ChunkData chunkData) {
        if (MappyConfig.enableWorldMapKey) {
            SuperChunk superChunk = this.getSuperChunk(chunkData.cx, chunkData.cz);
            this.ioManager.MarkForSave(superChunk);
        }
    }

    public ChunkData getChunk(int cx, int cz) {
        return this.getChunk(cx, cz, true);
    }

    public ChunkData getChunk(int cx, int cz, boolean update) {
        SuperChunk superChunk = this.getSuperChunk(cx, cz);
        ChunkData data = superChunk.getChunk(cx, cz);
        if (data != null) {
            if (update) {
                if (data.chunk == null) {
                    data.chunk = this.world.func_212866_a_(cx, cz);
                }
                ChunkPos pos = data.chunk.func_76632_l();
                if (pos.field_77276_a == cx && pos.field_77275_b == cz) {
                    return data;
                }
                data.cx = cx;
                data.cz = cz;
                this.ioManager.MarkForSave(superChunk);
            } else {
                return data;
            }
        }
        ChunkData chunkData = new ChunkData(this.world.func_212866_a_(cx, cz), this.layer);
        superChunk.setChunk(chunkData);
        return chunkData;
    }

    protected File getFile(int worldId, int cx, int cz) {
        String id = cx + "_" + cz + ".dat";
        File subDir = MappyFileUtil.createSubDir(MappyFileUtil.getSaveDirectory(), "/data/");
        if (!subDir.exists()) {
            Mappy.LOGGER.info("Creating folder 'data'");
            subDir.mkdir();
        }
        if (!(subDir = new File(subDir, worldId + "/")).exists()) {
            Mappy.LOGGER.info("Creating folder '" + worldId + "'");
            subDir.mkdir();
        }
        return new File(subDir, id);
    }

    private ChunkData load(File file) {
        ChunkData chunkData = null;
        if (!file.exists()) {
            return null;
        }
        try {
            CompoundNBT tag = CompressedStreamTools.func_74797_a((File)file);
            if (tag != null) {
                chunkData = ChunkData.fromTag(tag, this.world);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return chunkData;
    }

    private void save(ChunkData data) {
        File file = this.getFile(this.world.field_73011_w.func_186058_p().func_186068_a(), data.cx, data.cz);
        CompoundNBT tag = ChunkData.toTag(data);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            CompressedStreamTools.func_74793_a((CompoundNBT)tag, (File)file);
        }
        catch (IOException e) {
            Mappy.LOGGER.error("Failed to write chunk data to '" + file + "'");
            e.printStackTrace();
        }
    }

    static {
        BLACK_IMAGE.func_195715_a(0, 0, 16, 16, -16777216);
    }
}

