/*
 * Decompiled with CFR 0.152.
 */
package com.naxanria.mappy.map;

import com.naxanria.mappy.Mappy;
import com.naxanria.mappy.event.KeyHandler;
import com.naxanria.mappy.gui.ScreenBase;
import com.naxanria.mappy.map.chunk.ChunkCache;
import com.naxanria.mappy.map.chunk.ChunkData;
import com.naxanria.mappy.util.ImageUtil;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;

public class WorldMapGUI
extends ScreenBase {
    private BlockPos.MutableBlockPos center;
    private ClientPlayerEntity player = (ClientPlayerEntity)this.getLocalPlayer();
    private ChunkCache preLoader;
    private NativeImage backingImage;
    private DynamicTexture texture;
    private ResourceLocation textureIdentifier;
    private KeyHandler keyHandler;

    public WorldMapGUI(Screen parent) {
        super((TextComponent)new StringTextComponent("World Map"), parent);
        this.center = new BlockPos.MutableBlockPos(this.player.func_180425_c());
        this.preLoader = ChunkCache.getPreLoader(this.player.field_70170_p);
        this.keyHandler = KeyHandler.INSTANCE;
        this.keyHandler.watch(263, 65);
        this.keyHandler.watch(262, 68);
        this.keyHandler.watch(265, 87);
        this.keyHandler.watch(264, 83);
    }

    public void renderBackground() {
        WorldMapGUI.fill((int)0, (int)0, (int)this.windowWidth, (int)this.windowHeight, (int)-16777216);
        if (this.backingImage == null || this.backingImage.func_195714_b() != this.windowHeight || this.backingImage.func_195702_a() != this.windowWidth) {
            this.backingImage = new NativeImage(this.windowWidth, this.windowHeight, false);
            if (this.texture != null) {
                this.texture.func_147631_c();
                this.texture = null;
            }
        }
        if (this.texture == null) {
            this.texture = new DynamicTexture(this.backingImage);
            this.update();
            this.textureIdentifier = this.minecraft.func_110434_K().func_110578_a("mappyworld_map_texture", this.texture);
        }
        this.renderTexture(0, 0, this.windowWidth, this.windowHeight, this.textureIdentifier);
        if (Screen.hasControlDown()) {
            this.renderChunkCoords();
        }
        this.drawRightAlignedString(this.font, "WIP", this.windowWidth - 5, this.windowHeight - 20, -1);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private void renderChunkCoords() {
        int centerChunkX = this.center.func_177958_n() / 16;
        int centerChunkZ = this.center.func_177952_p() / 16;
        int xRadius = this.windowWidth / 16 / 2 + 1;
        int zRadius = this.windowHeight / 16 / 2 + 1;
        int chunkXStart = centerChunkX - xRadius;
        int chunkZStart = centerChunkZ - zRadius;
        int chunkXEnd = centerChunkX + xRadius;
        int chunkZEnd = centerChunkZ + zRadius;
        int xp = 0;
        int yp = 0;
        for (int cx = chunkXStart; cx <= chunkXEnd; ++cx) {
            yp = 0;
            for (int cz = chunkZStart; cz < chunkZEnd; ++cz) {
                this.drawCenteredString(this.font, cx + "," + cz, xp + 8, yp + 8, -1);
                yp += 16;
            }
            xp += 16;
        }
    }

    public void tick() {
        boolean update = false;
        if (this.keyHandler.isKeyPressed(263) || this.keyHandler.isKeyPressed(65)) {
            this.center.func_181079_c(this.center.func_177958_n() - 16, 0, this.center.func_177952_p());
            update = true;
        }
        if (this.keyHandler.isKeyPressed(262) || this.keyHandler.isKeyPressed(68)) {
            this.center.func_181079_c(this.center.func_177958_n() + 16, 0, this.center.func_177952_p());
            update = true;
        }
        if (this.keyHandler.isKeyPressed(265) || this.keyHandler.isKeyPressed(87)) {
            this.center.func_181079_c(this.center.func_177958_n(), 0, this.center.func_177952_p() - 16);
            update = true;
        }
        if (this.keyHandler.isKeyPressed(264) || this.keyHandler.isKeyPressed(83)) {
            this.center.func_181079_c(this.center.func_177958_n(), 0, this.center.func_177952_p() + 16);
            update = true;
        }
        if (update) {
            this.update();
        }
    }

    private void update() {
        this.backingImage.func_195715_a(0, 0, this.windowWidth, this.windowHeight, -16777216);
        this.preLoader = ChunkCache.getPreLoader(this.player.field_70170_p);
        Mappy.LOGGER.info("Update");
        int centerChunkX = this.center.func_177958_n() / 16;
        int centerChunkZ = this.center.func_177952_p() / 16;
        int xRadius = this.windowWidth / 16 / 2 + 1;
        int zRadius = this.windowHeight / 16 / 2 + 1;
        int chunkXStart = centerChunkX - xRadius;
        int chunkZStart = centerChunkZ - zRadius;
        int chunkXEnd = centerChunkX + xRadius;
        int chunkZEnd = centerChunkZ + zRadius;
        int xp = 0;
        int yp = 0;
        Mappy.LOGGER.info("StartX=" + chunkXStart + " StartZ=" + chunkZStart + " xRadius=" + xRadius + "zRadius=" + zRadius);
        for (int cx = chunkXStart; cx <= chunkXEnd; ++cx) {
            yp = 0;
            for (int cz = chunkZStart; cz < chunkZEnd; ++cz) {
                ChunkData data = this.preLoader.getChunk(cx, cz, false);
                if (this.checkChunkCoords(data, cx, cz)) {
                    ImageUtil.writeIntoImage(data.image, this.backingImage, xp, yp);
                }
                yp += 16;
            }
            xp += 16;
        }
        this.texture.func_110564_a();
    }

    private boolean checkChunkCoords(ChunkData data, int cx, int cz) {
        if (data == null) {
            return false;
        }
        if (data.chunk == null) {
            return true;
        }
        ChunkPos pos = data.chunk.func_76632_l();
        return data.cx == cx && data.cz == cz && pos.field_77276_a == data.cx && pos.field_77275_b == data.cz;
    }
}

