/*
 * Decompiled with CFR 0.152.
 */
package com.naxanria.mappy.map;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;

public class PlayerHeadIcon {
    public static final int HEAD_SIZE = 8;
    private static HashMap<UUID, PlayerHeadIcon> icons = new HashMap();
    private static boolean initialized = false;
    private UUID uuid;
    private boolean retry = false;
    private int wait = 2;
    private long time = System.currentTimeMillis();
    private ResourceLocation skinId;
    private PlayerEntity player;

    private PlayerHeadIcon(PlayerEntity player) {
        this.player = player;
        this.uuid = player.func_110124_au();
    }

    private static PlayerHeadIcon getIcon(PlayerEntity player) {
        PlayerHeadIcon icon;
        if (!initialized) {
            PlayerHeadIcon.initialize();
        }
        long now = System.currentTimeMillis();
        if (icons.containsKey(player.func_110124_au())) {
            icon = icons.get(player.func_110124_au());
            if (icon.retry) {
                if (now - icon.time - (long)(icon.wait * 1000) > 0L) {
                    PlayerHeadIcon.loadSkin(icon);
                }
            } else if (now - icon.time > 120000L) {
                icon.retry = true;
                icon.wait = 1;
                PlayerHeadIcon.loadSkin(icon);
            }
        } else {
            icon = new PlayerHeadIcon(player);
            PlayerHeadIcon.register(icon);
        }
        return icon;
    }

    public static void drawHead(PlayerEntity player, int x, int y) {
        PlayerHeadIcon icon = PlayerHeadIcon.getIcon(player);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(icon.skinId);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        AbstractGui.blit((int)x, (int)y, (int)8, (int)8, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
    }

    private static void register(PlayerHeadIcon icon) {
        PlayerHeadIcon.loadSkin(icon);
        icons.put(icon.uuid, icon);
    }

    private static void loadSkin(PlayerHeadIcon icon) {
        Minecraft client = Minecraft.func_71410_x();
        SkinManager skinManager = client.func_152342_ad();
        Map map = skinManager.func_152788_a(icon.player.func_146103_bH());
        if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
            icon.skinId = skinManager.func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
            icon.retry = false;
        } else {
            icon.skinId = DefaultPlayerSkin.func_177334_a((UUID)icon.uuid);
            icon.retry = true;
            icon.wait *= 2;
        }
    }

    private static void initialize() {
        System.out.println("Initializing PlayerHeadIcons");
        if (initialized) {
            return;
        }
        initialized = true;
    }
}

