/*
 * Decompiled with CFR 0.152.
 */
package com.naxanria.mappy.map;

import com.naxanria.mappy.config.MappyConfig;
import com.naxanria.mappy.map.chunk.ChunkCache;
import com.naxanria.mappy.map.chunk.ChunkData;
import com.naxanria.mappy.util.StateUtil;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.StainedGlassPaneBlock;
import net.minecraft.block.material.Material;
import net.minecraft.item.DyeColor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class MapLayerProcessor {
    public static final int BLACK = -16777216;
    public static final int VOID_COLOR = -10000778;
    public static final HashMap<Block, Integer> colorMap = new HashMap();

    public static void addStained(Block block) {
        if (block instanceof StainedGlassPaneBlock) {
            MapLayerProcessor.addColor(block, ((StainedGlassPaneBlock)block).func_196457_d());
        }
    }

    public static void addColor(Block block, DyeColor color) {
        MapLayerProcessor.addColor(block, color.getColorValue());
    }

    public static void addColor(Block block, int color) {
        colorMap.put(block, color);
    }

    public static int effectiveHeight(Chunk chunk, int x, int yStart, int z, boolean skipLiquid) {
        Chunk realChunk;
        World world = chunk.func_177412_p();
        BlockPos worldPos = new BlockPos(x + chunk.func_76632_l().field_77276_a * 16, 42, z + chunk.func_76632_l().field_77275_b * 16);
        if (x < 0 || x > 15 || z < 0 || z > 15) {
            realChunk = world.func_175726_f(worldPos);
            if (x < 0) {
                x += 16;
            } else if (x > 15) {
                x -= 16;
            }
            if (z < 0) {
                z += 16;
            } else if (z > 15) {
                z -= 16;
            }
        } else {
            realChunk = chunk;
        }
        ChunkData data = ChunkCache.getPreLoader(chunk.func_177412_p()).getChunk(realChunk.func_76632_l().field_77276_a, realChunk.func_76632_l().field_77275_b, false);
        int y = data.heightmap[x + z * 16];
        if (chunk.func_76621_g() || !world.func_72863_F().func_222865_a(realChunk.func_76632_l())) {
            return y == -1 ? yStart : y;
        }
        worldPos = new BlockPos(worldPos.func_177958_n(), y - 1, worldPos.func_177952_p());
        if (y < 0) {
            y = yStart;
        }
        boolean loop = false;
        do {
            worldPos = new BlockPos(worldPos.func_177958_n(), y - 1, worldPos.func_177952_p());
            BlockState state = world.func_180495_p(worldPos);
            --y;
            if (skipLiquid) {
                loop = state.func_185904_a().func_76224_d();
            }
            if (loop || state.func_185904_a() != Material.field_203243_f) continue;
            loop = true;
        } while (loop &= y > 0);
        return y + 1;
    }

    public static int shadeTopView(ChunkData chunkData, int x, int z) {
        int base_color;
        int y_south;
        int y_diff_south;
        Chunk chunk = chunkData.chunk;
        int y_here = MapLayerProcessor.effectiveHeight(chunk, x, -1, z, true);
        int y_east = MapLayerProcessor.effectiveHeight(chunk, x + 1, y_here, z, true);
        int y_diff_east = y_east - y_here;
        int y_diff = y_diff_east + (y_diff_south = -((y_south = MapLayerProcessor.effectiveHeight(chunk, x, y_here, z - 1, true)) - y_here));
        if (y_diff < 0) {
            base_color = 0x222222;
            y_diff = -y_diff;
        } else {
            base_color = 0xDDDDDD;
        }
        int maxDiff = MappyConfig.maxDifference;
        if (y_diff > maxDiff) {
            y_diff = maxDiff;
        }
        int alpha = (int)(255.0 * (double)y_diff / (double)maxDiff);
        return alpha << 24 | base_color;
    }

    public static int processTopView(ChunkData chunkData, int x, int z) {
        BlockPos worldPos;
        BlockState state;
        Chunk worldChunk = chunkData.chunk;
        World world = worldChunk.func_177412_p();
        int y = chunkData.heightmap[x + z * 16];
        if (y < 0) {
            y = MapLayerProcessor.effectiveHeight(chunkData.chunk, x, 255, z, false);
        }
        if (!StateUtil.isAir(state = world.func_180495_p(worldPos = new BlockPos(x + worldChunk.func_76632_l().field_77276_a * 16, y, z + worldChunk.func_76632_l().field_77275_b * 16)))) {
            if (world.func_180495_p(worldPos.func_177984_a()).func_177230_c() == Blocks.field_150433_aE) {
                return -1;
            }
            return MapLayerProcessor.color(world, state, worldPos);
        }
        return -10000778;
    }

    public static int processTopViewNether(ChunkData chunk, int x, int y, int z) {
        BlockPos worldPos;
        if (y >= 128) {
            return MapLayerProcessor.processTopView(chunk, x, z);
        }
        Chunk worldChunk = chunk.chunk;
        World world = worldChunk.func_177412_p();
        boolean up = !StateUtil.isAir(world.func_180495_p(worldPos = new BlockPos(x, y, z)));
        return MapLayerProcessor.processTopViewNether(chunk, x, y, z, up);
    }

    private static int processTopViewNether(ChunkData chunk, int x, int y, int z, boolean up) {
        Chunk worldChunk = chunk.chunk;
        World world = worldChunk.func_177412_p();
        do {
            y = up ? ++y : --y;
            BlockPos worldPos = new BlockPos(x + worldChunk.func_76632_l().field_77276_a * 16, y, z + worldChunk.func_76632_l().field_77275_b * 16);
            BlockState state = world.func_180495_p(worldPos);
            boolean air = StateUtil.isAir(state);
            if (up && air) {
                worldPos = worldPos.func_177977_b();
                state = world.func_180495_p(worldPos);
                return MapLayerProcessor.color(world, state, worldPos);
            }
            if (up || air) continue;
            worldPos = worldPos.func_177984_a();
            state = world.func_180495_p(worldPos);
            return MapLayerProcessor.color(world, state, worldPos);
        } while (y < world.func_217301_I() && y > 0);
        return -16777216;
    }

    public static int color(World world, BlockState state, BlockPos pos) {
        int brightness = 1;
        Block block = state.func_177230_c();
        if (colorMap.containsKey(block)) {
            return MapLayerProcessor.getMapColor(colorMap.get(block), brightness);
        }
        return state.func_185909_g((IBlockReader)world, pos).func_151643_b(brightness);
    }

    public static int getMapColor(int colorValue, int index) {
        int i = 220;
        if (index == 3) {
            i = 135;
        }
        if (index == 2) {
            i = 255;
        }
        if (index == 1) {
            i = 220;
        }
        if (index == 0) {
            i = 180;
        }
        int j = (colorValue >> 16 & 0xFF) * i / 255;
        int k = (colorValue >> 8 & 0xFF) * i / 255;
        int l = (colorValue & 0xFF) * i / 255;
        return 0xFF000000 | l << 16 | k << 8 | j;
    }

    public static int getHeight(World world, BlockPos pos, boolean ignoreLiquid) {
        return MapLayerProcessor.getHeight(world, pos, ignoreLiquid, world.func_217301_I());
    }

    public static int getHeight(World world, BlockPos pos, boolean ignoreLiquid, int startHeight) {
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos(pos.func_177958_n(), startHeight, pos.func_177952_p());
        while (checkPos.func_177956_o() > 0) {
            BlockState state = world.func_180495_p((BlockPos)checkPos);
            if (StateUtil.isAir(state) || ignoreLiquid && state.func_185904_a().func_76224_d()) {
                checkPos.func_185336_p(checkPos.func_177956_o() - 1);
                continue;
            }
            return checkPos.func_177956_o();
        }
        return 0;
    }

    static {
        MapLayerProcessor.addColor(Blocks.field_150353_l, -30720);
        MapLayerProcessor.addColor(Blocks.field_185764_cQ, DyeColor.WHITE);
        MapLayerProcessor.addColor(Blocks.field_150478_aa, DyeColor.YELLOW);
        MapLayerProcessor.addColor(Blocks.field_150429_aA, DyeColor.RED);
        MapLayerProcessor.addColor(Blocks.field_196677_cy, DyeColor.RED);
        MapLayerProcessor.addColor(Blocks.field_150442_at, DyeColor.GRAY);
        MapLayerProcessor.addColor(Blocks.field_150488_af, DyeColor.RED);
        MapLayerProcessor.addColor(Blocks.field_196762_fd, DyeColor.RED);
        MapLayerProcessor.addColor(Blocks.field_196633_cV, DyeColor.RED);
        MapLayerProcessor.addColor(Blocks.field_150448_aq, DyeColor.GRAY);
        MapLayerProcessor.addColor(Blocks.field_150408_cc, DyeColor.GRAY);
        MapLayerProcessor.addColor(Blocks.field_196552_aC, DyeColor.GRAY);
        MapLayerProcessor.addColor(Blocks.field_150319_E, DyeColor.GRAY);
        MapLayerProcessor.addColor(Blocks.field_150414_aQ, DyeColor.WHITE);
        MapLayerProcessor.addColor(Blocks.field_196605_bc, DyeColor.YELLOW);
        MapLayerProcessor.addColor(Blocks.field_196606_bd, DyeColor.RED);
        MapLayerProcessor.addColor(Blocks.field_196607_be, DyeColor.BLUE);
        MapLayerProcessor.addColor(Blocks.field_196609_bf, DyeColor.PINK);
        MapLayerProcessor.addColor(Blocks.field_196610_bg, DyeColor.WHITE);
        MapLayerProcessor.addColor(Blocks.field_196612_bh, DyeColor.RED);
        MapLayerProcessor.addColor(Blocks.field_196613_bi, DyeColor.ORANGE);
        MapLayerProcessor.addColor(Blocks.field_196614_bj, DyeColor.WHITE);
        MapLayerProcessor.addColor(Blocks.field_196615_bk, DyeColor.PINK);
        MapLayerProcessor.addColor(Blocks.field_196616_bl, DyeColor.LIGHT_GRAY);
        MapLayerProcessor.addColor(Blocks.field_222387_by, DyeColor.LIGHT_BLUE);
        MapLayerProcessor.addColor(Blocks.field_222388_bz, DyeColor.BLACK);
        MapLayerProcessor.addColor(Blocks.field_222383_bA, DyeColor.WHITE);
        MapLayerProcessor.addColor(Blocks.field_150338_P, DyeColor.BROWN);
        MapLayerProcessor.addColor(Blocks.field_150337_Q, DyeColor.RED);
        MapLayerProcessor.addColor(Blocks.field_150388_bm, DyeColor.RED);
        MapLayerProcessor.addColor(Blocks.field_196803_gg, DyeColor.PINK);
        MapLayerProcessor.addColor(Blocks.field_196801_ge, DyeColor.MAGENTA);
        MapLayerProcessor.addColor(Blocks.field_196802_gf, DyeColor.RED);
        MapLayerProcessor.addColor(Blocks.field_196800_gd, DyeColor.YELLOW);
        MapLayerProcessor.addColor(Blocks.field_150457_bL, DyeColor.BROWN);
        MapLayerProcessor.addColor(Blocks.field_196746_es, DyeColor.GREEN);
        MapLayerProcessor.addColor(Blocks.field_196748_et, DyeColor.GREEN);
        MapLayerProcessor.addColor(Blocks.field_196750_eu, DyeColor.GREEN);
        MapLayerProcessor.addColor(Blocks.field_196752_ev, DyeColor.GREEN);
        MapLayerProcessor.addColor(Blocks.field_196754_ew, DyeColor.GREEN);
        MapLayerProcessor.addColor(Blocks.field_196755_ex, DyeColor.GREEN);
        MapLayerProcessor.addColor(Blocks.field_196683_eB, DyeColor.GREEN);
        MapLayerProcessor.addColor(Blocks.field_196744_er, DyeColor.YELLOW);
        MapLayerProcessor.addColor(Blocks.field_196726_ei, DyeColor.RED);
        MapLayerProcessor.addColor(Blocks.field_196728_ej, DyeColor.BLUE);
        MapLayerProcessor.addColor(Blocks.field_196730_ek, DyeColor.PINK);
        MapLayerProcessor.addColor(Blocks.field_196732_el, DyeColor.WHITE);
        MapLayerProcessor.addColor(Blocks.field_196734_em, DyeColor.RED);
        MapLayerProcessor.addColor(Blocks.field_196736_en, DyeColor.ORANGE);
        MapLayerProcessor.addColor(Blocks.field_196738_eo, DyeColor.WHITE);
        MapLayerProcessor.addColor(Blocks.field_196740_ep, DyeColor.PINK);
        MapLayerProcessor.addColor(Blocks.field_196742_eq, DyeColor.LIGHT_GRAY);
        MapLayerProcessor.addColor(Blocks.field_222398_eF, DyeColor.LIGHT_BLUE);
        MapLayerProcessor.addColor(Blocks.field_222399_eG, DyeColor.WHITE);
        MapLayerProcessor.addColor(Blocks.field_222400_eH, DyeColor.BLACK);
        MapLayerProcessor.addColor(Blocks.field_196756_ey, DyeColor.RED);
        MapLayerProcessor.addColor(Blocks.field_196757_ez, DyeColor.BROWN);
        MapLayerProcessor.addColor(Blocks.field_196681_eA, DyeColor.BROWN);
        MapLayerProcessor.addColor(Blocks.field_196685_eC, DyeColor.GREEN);
        MapLayerProcessor.addColor(Blocks.field_150359_w, -2171170);
        MapLayerProcessor.addColor(Blocks.field_150410_aZ, -2171170);
        MapLayerProcessor.addStained(Blocks.field_196825_gz);
        MapLayerProcessor.addStained(Blocks.field_196758_gA);
        MapLayerProcessor.addStained(Blocks.field_196759_gB);
        MapLayerProcessor.addStained(Blocks.field_196760_gC);
        MapLayerProcessor.addStained(Blocks.field_196761_gD);
        MapLayerProcessor.addStained(Blocks.field_196763_gE);
        MapLayerProcessor.addStained(Blocks.field_196764_gF);
        MapLayerProcessor.addStained(Blocks.field_196765_gG);
        MapLayerProcessor.addStained(Blocks.field_196767_gH);
        MapLayerProcessor.addStained(Blocks.field_196768_gI);
        MapLayerProcessor.addStained(Blocks.field_196769_gJ);
        MapLayerProcessor.addStained(Blocks.field_196771_gK);
        MapLayerProcessor.addStained(Blocks.field_196773_gL);
        MapLayerProcessor.addStained(Blocks.field_196774_gM);
        MapLayerProcessor.addStained(Blocks.field_196775_gN);
        MapLayerProcessor.addStained(Blocks.field_196776_gO);
    }
}

