/*
 * Decompiled with CFR 0.152.
 */
package com.naxanria.mappy.map;

import com.naxanria.mappy.map.Map;
import com.naxanria.mappy.map.MapInfoLine;
import java.util.ArrayList;
import java.util.List;

public class MapInfoLineManager {
    private List<MapInfoLine> lines;
    private int x;
    private int y;
    private int spacing = 16;
    private Direction direction = Direction.DOWN;
    private Map map;

    public MapInfoLineManager(Map map) {
        this.lines = new ArrayList<MapInfoLine>();
        this.map = map;
    }

    public void clear() {
        this.lines.clear();
    }

    public void draw() {
        this.spacing = 10;
        int yp = this.y;
        if (this.direction == Direction.UP) {
            yp = this.y - this.spacing * this.lines.size();
        }
        for (MapInfoLine line : this.lines) {
            switch (line.alignment) {
                case Left: {
                    line.x = this.x;
                    break;
                }
                case Center: {
                    line.x = this.x + this.map.getSize() / 2;
                    break;
                }
                case Right: {
                    line.x = this.x + this.map.getSize();
                }
            }
            line.y = yp;
            line.draw();
            yp += this.spacing;
        }
    }

    public void add(MapInfoLine line) {
        this.lines.add(line);
    }

    public MapInfoLineManager setSpacing(int spacing) {
        this.spacing = spacing;
        return this;
    }

    public MapInfoLineManager setPosition(int x, int y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public MapInfoLineManager setDirection(Direction direction) {
        this.direction = direction;
        return this;
    }

    public static enum Direction {
        UP,
        DOWN;

    }
}

