/*
 * Decompiled with CFR 0.152.
 */
package com.naxanria.mappy.map;

import com.naxanria.mappy.config.MappyConfig;
import com.naxanria.mappy.gui.DrawableHelperBase;
import com.naxanria.mappy.map.Map;
import com.naxanria.mappy.map.PlayerHeadIcon;
import com.naxanria.mappy.map.waypoint.WayPoint;
import net.minecraft.entity.player.PlayerEntity;

public abstract class MapIcon<T extends MapIcon<T>>
extends DrawableHelperBase {
    protected Map map;
    public int x;
    public int y;

    public MapIcon(Map map) {
        this.map = map;
    }

    public T setPosition(int x, int y) {
        this.x = x;
        this.y = y;
        return (T)((Object)this);
    }

    public static int getScaled(int val, int startVal, int endVal, int range) {
        return (int)((float)(val - startVal) / (float)(endVal - startVal) * (float)range);
    }

    public abstract void draw(int var1, int var2);

    public static class Entity
    extends MapIcon<Entity> {
        private final net.minecraft.entity.Entity entity;
        boolean hostile;

        public Entity(Map map, net.minecraft.entity.Entity entity, boolean hostile) {
            super(map);
            this.entity = entity;
            this.hostile = hostile;
        }

        @Override
        public void draw(int mapX, int mapY) {
            int size = 1;
            int col = this.hostile ? -30720 : -256;
            Entity.fill((int)(mapX + this.x - size), (int)(mapY + this.y - size), (int)(mapX + this.x + size), (int)(mapY + this.y + size), (int)col);
        }
    }

    public static class Waypoint
    extends MapIcon<Waypoint> {
        private WayPoint wayPoint;

        public Waypoint(Map map, WayPoint wayPoint) {
            super(map);
            this.wayPoint = wayPoint;
        }

        @Override
        public void draw(int mapX, int mapY) {
            int size = 8;
            int col = this.wayPoint.color;
            int drawX = mapX + this.x - size / 2;
            int drawY = mapY + this.y - size / 2;
            this.wayPoint.iconType.draw(drawX, drawY, col);
        }
    }

    public static class Player
    extends MapIcon<Player> {
        public static final int PLAYER_SELF = -16711936;
        public static final int PLAYER_OTHER = -16737997;
        protected boolean self;
        protected PlayerEntity player;

        public Player(Map map, PlayerEntity player, boolean self) {
            super(map);
            this.self = self;
            this.player = player;
        }

        @Override
        public void draw(int mapX, int mapY) {
            int size = this.self ? 4 : 8;
            int drawX = mapX + this.x - size / 2;
            int drawY = mapY + this.y - size / 2;
            if (this.self) {
                if (Player.client.field_71439_g != this.player) {
                    this.player = Player.client.field_71439_g;
                }
                Player.fill((int)drawX, (int)drawY, (int)(drawX + size), (int)(drawY + size), (int)-16711936);
                int l = 4;
                double angle = Math.toRadians((this.player.field_70177_z + 90.0f) % 360.0f);
                Player.line(drawX + size / 2, drawY + size / 2, (int)((double)(drawX + size / 2) + Math.cos(angle) * (double)l), (int)((double)(drawY + size / 2) + Math.sin(angle) * (double)l), -65536);
            } else if (MappyConfig.showPlayerHeads) {
                PlayerHeadIcon.drawHead(this.player, drawX, drawY);
            } else {
                Player.fill((int)drawX, (int)drawY, (int)(drawX + size), (int)(drawY + size), (int)-16737997);
            }
            if (!this.self && MappyConfig.showPlayerNames) {
                this.drawStringCenteredBound(Player.client.field_71466_p, this.player.func_200200_C_().getString(), drawX + size / 2, drawY - size / 2 - 10, 0, Player.client.field_195558_d.func_198107_o(), -1);
            }
        }
    }
}

