/*
 * Decompiled with CFR 0.152.
 */
package com.naxanria.mappy.map;

import com.mojang.blaze3d.platform.GlStateManager;
import com.naxanria.mappy.Mappy;
import com.naxanria.mappy.config.MappyConfig;
import com.naxanria.mappy.gui.DrawPosition;
import com.naxanria.mappy.gui.DrawableHelperBase;
import com.naxanria.mappy.map.EffectState;
import com.naxanria.mappy.map.Map;
import com.naxanria.mappy.map.MapIcon;
import com.naxanria.mappy.map.MapInfoLineManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;

public class MapGUI
extends DrawableHelperBase {
    public static MapGUI instance;
    protected DrawPosition drawPosition;
    protected int border = 2;
    protected int borderColor = -7829368;
    private int offset;
    private final Map map;
    private NativeImage backingImage;
    private DynamicTexture texture;
    private ResourceLocation textureIdentifier;
    private MapInfoLineManager manager;

    public MapGUI(Map map, int offset, DrawPosition position) {
        this.map = map;
        instance = this;
        this.offset = offset;
        this.drawPosition = position;
        this.manager = map.getManager();
    }

    public void markDirty() {
        NativeImage img = this.map.getImage();
        if (img != this.backingImage) {
            this.backingImage = img;
            if (this.texture != null) {
                this.texture.close();
            }
            this.texture = null;
        }
        if (this.texture != null) {
            this.texture.func_110564_a();
        }
    }

    public void draw() {
        if (!Mappy.showMap) {
            return;
        }
        boolean canShowMap = this.map.canShowMap();
        Minecraft client = Minecraft.func_71410_x();
        if (client.field_71439_g == null) {
            return;
        }
        if (!(client.field_71462_r == null || MappyConfig.showInChat && client.field_71462_r instanceof ChatScreen)) {
            return;
        }
        this.offset = MappyConfig.offset;
        this.drawPosition = MappyConfig.drawPosition;
        if (this.texture == null) {
            this.backingImage = this.map.getImage();
            this.texture = new DynamicTexture(this.backingImage);
            this.texture.func_110564_a();
            this.textureIdentifier = client.func_110434_K().func_110578_a("mappy_map_texture", this.texture);
        }
        int x = this.offset;
        int y = this.offset;
        int w = client.field_195558_d.func_198107_o();
        int h = client.field_195558_d.func_198087_p();
        int scale = MappyConfig.scale;
        int iw = this.backingImage.func_195702_a() / scale;
        int ih = this.backingImage.func_195714_b() / scale;
        MapInfoLineManager.Direction direction = MapInfoLineManager.Direction.DOWN;
        switch (this.drawPosition) {
            case TOP_LEFT: {
                break;
            }
            case TOP_CENTER: {
                x = w / 2 - iw / 2;
                break;
            }
            case TOP_RIGHT: {
                EffectState effects;
                x = w - this.offset - iw;
                if (!MappyConfig.moveMapForEffects || (effects = this.map.getEffects()) == EffectState.NONE) break;
                y += effects == EffectState.HARMFUL ? 48 : 24;
                break;
            }
            case BOTTOM_LEFT: {
                direction = MapInfoLineManager.Direction.UP;
                y = h - this.offset - ih;
                break;
            }
            case BOTTOM_RIGHT: {
                direction = MapInfoLineManager.Direction.UP;
                x = w - this.offset - iw;
                y = h - this.offset - ih;
            }
        }
        this.manager.setPosition(x, y + (direction == MapInfoLineManager.Direction.DOWN && canShowMap ? ih + this.border + 2 : -this.border - 2));
        this.manager.setDirection(direction);
        this.manager.setSpacing(12);
        if (canShowMap) {
            MapGUI.fill((int)(x - this.border), (int)(y - this.border), (int)(x + iw + this.border), (int)(y + ih + this.border), (int)this.borderColor);
            this.drawMap(client, x, y, iw, ih);
            GlStateManager.disableDepthTest();
            for (MapIcon.Player player : this.map.getPlayerIcons()) {
                player.draw(x, y);
            }
            for (MapIcon.Entity entity : this.map.getEntities()) {
                entity.draw(x, y);
            }
            for (MapIcon.Waypoint waypoint : this.map.getWaypoints()) {
                waypoint.draw(x, y);
            }
            GlStateManager.enableDepthTest();
        }
        this.manager.draw();
    }

    private void drawMap(Minecraft client, int x, int y, int iw, int ih) {
        client.func_110434_K().func_110577_a(this.textureIdentifier);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        double z = 0.09;
        builder.func_181662_b((double)x, (double)(y + ih), z).func_187315_a(0.0, 1.0).func_181669_b(255, 255, 255, 255).func_181675_d();
        builder.func_181662_b((double)(x + iw), (double)(y + ih), z).func_187315_a(1.0, 1.0).func_181669_b(255, 255, 255, 255).func_181675_d();
        builder.func_181662_b((double)(x + iw), (double)y, z).func_187315_a(1.0, 0.0).func_181669_b(255, 255, 255, 255).func_181675_d();
        builder.func_181662_b((double)x, (double)y, z).func_187315_a(0.0, 0.0).func_181669_b(255, 255, 255, 255).func_181675_d();
        tessellator.func_78381_a();
        if (MappyConfig.drawChunkGrid) {
            this.drawGrid(client, x, y, iw, ih);
        }
    }

    private void drawGrid(Minecraft client, int x, int y, int iw, int ih) {
        int col = -2008791996;
        int px = client.field_71439_g.func_180425_c().func_177958_n();
        int pz = client.field_71439_g.func_180425_c().func_177952_p();
        int xOff = px / 16 * 16 - px;
        int yOff = pz / 16 * 16 - pz;
        GlStateManager.disableDepthTest();
        for (int h = yOff; h < ih; h += 16) {
            int yp = y + h;
            if (yp < y || yp > y + ih) continue;
            MapGUI.line(x, yp, x + iw, yp, col);
        }
        for (int v = xOff; v < iw; v += 16) {
            int xp = x + v;
            if (xp < x || xp >= x + iw) continue;
            MapGUI.line(xp, y, xp, y + ih, col);
        }
        GlStateManager.enableDepthTest();
    }
}

