/*
 * Decompiled with CFR 0.152.
 */
package com.naxanria.mappy.map;

import com.naxanria.mappy.Mappy;
import com.naxanria.mappy.config.ConfigBase;
import com.naxanria.mappy.config.MappyConfig;
import com.naxanria.mappy.event.EventListener;
import com.naxanria.mappy.gui.Alignment;
import com.naxanria.mappy.map.EffectState;
import com.naxanria.mappy.map.MapGUI;
import com.naxanria.mappy.map.MapIcon;
import com.naxanria.mappy.map.MapInfoLine;
import com.naxanria.mappy.map.MapInfoLineManager;
import com.naxanria.mappy.map.WorldMapGUI;
import com.naxanria.mappy.map.chunk.ChunkCache;
import com.naxanria.mappy.map.waypoint.IconType;
import com.naxanria.mappy.map.waypoint.WayPoint;
import com.naxanria.mappy.map.waypoint.WayPointEditor;
import com.naxanria.mappy.map.waypoint.WayPointManager;
import com.naxanria.mappy.util.MathUtil;
import com.naxanria.mappy.util.RandomUtil;
import com.naxanria.mappy.util.StackUtil;
import com.naxanria.mappy.util.TriValue;
import com.naxanria.mappy.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.DeathScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.dimension.DimensionType;

public class Map {
    private static final BlockState AIR_STATE = Blocks.field_150350_a.func_176223_P();
    private static final BlockState CAVE_AIR_STATE = Blocks.field_201941_jj.func_176223_P();
    private static final BlockState VOID_AIR_STATE = Blocks.field_201940_ji.func_176223_P();
    private static final Minecraft client = Minecraft.func_71410_x();
    private MapInfoLineManager manager;
    private MapInfoLine playerPositionInfo = new MapInfoLine(Alignment.Center, "0 0 0");
    private MapInfoLine biomeInfo = new MapInfoLine(Alignment.Center, "plains");
    private MapInfoLine inGameTimeInfo = new MapInfoLine(Alignment.Center, "00:00");
    private MapInfoLine fpsInfo = new MapInfoLine(Alignment.Center, "60 fps");
    private MapInfoLine directionInfo = new MapInfoLine(Alignment.Center, "north");
    private int size;
    private int width = this.size = 64;
    private int height = this.size;
    private int sizeX = this.size;
    private int sizeZ = this.size;
    private int scale = 1;
    private TriValue<BlockPos, BlockState, Integer> debugData;
    private Biome biome;
    private NativeImage image;
    private List<MapIcon.Player> players = new ArrayList<MapIcon.Player>();
    private MapIcon.Player playerIcon;
    private List<MapIcon.Waypoint> waypoints = new ArrayList<MapIcon.Waypoint>();
    private List<MapIcon.Entity> entities = new ArrayList<MapIcon.Entity>();
    private PlayerEntity locPlayer = null;
    private EffectState effects = EffectState.NONE;
    private boolean showMap;
    private boolean showPosition;
    private boolean showTime;
    private boolean showBiome;

    public Map() {
        this.image = new NativeImage(NativeImage.PixelFormat.RGBA, this.width, this.height, false);
        this.manager = new MapInfoLineManager(this);
    }

    public void update() {
        if (!Mappy.showMap) {
            return;
        }
        if (Minecraft.func_71410_x().field_71462_r instanceof WorldMapGUI) {
            return;
        }
        ClientPlayerEntity player = Map.client.field_71439_g;
        if (player != null) {
            if (this.playerIcon == null) {
                this.playerIcon = new MapIcon.Player(this, (PlayerEntity)player, true);
            }
            if (this.locPlayer == null) {
                WayPointManager.INSTANCE.load();
                this.locPlayer = player;
            }
            this.itemCheck();
            this.playerIcon.setPosition(this.size / 2, this.size / 2);
            this.generate((PlayerEntity)player);
            this.updateInfo((PlayerEntity)player);
            this.updateStatusEffects();
            MapGUI.instance.markDirty();
        } else {
            this.locPlayer = null;
        }
    }

    private void itemCheck() {
        boolean inHotBar = MappyConfig.inHotBar;
        this.showMap = MappyConfig.mapItem.equals("") || StackUtil.contains(this.locPlayer.field_71071_by, inHotBar, MappyConfig.mapItem);
        this.showPosition = MappyConfig.showPosition && (MappyConfig.positionItem.equals("") || StackUtil.contains(this.locPlayer.field_71071_by, inHotBar, MappyConfig.positionItem));
        this.showTime = MappyConfig.showTime && (MappyConfig.timeItem.equals("") || StackUtil.contains(this.locPlayer.field_71071_by, inHotBar, MappyConfig.timeItem));
        this.showBiome = MappyConfig.showBiome && (MappyConfig.biomeItem.equals("") || StackUtil.contains(this.locPlayer.field_71071_by, inHotBar, MappyConfig.biomeItem));
    }

    private void updateStatusEffects() {
        Collection statusEffects = this.locPlayer.func_70651_bq();
        if (statusEffects.size() > 0) {
            this.effects = EffectState.BENEFICIAL;
            boolean showing = false;
            for (EffectInstance e : statusEffects) {
                showing |= e.func_205348_f();
                if (e.func_188419_a().func_188408_i()) continue;
                this.effects = EffectState.HARMFUL;
                if (!showing) continue;
                break;
            }
            if (!showing) {
                this.effects = EffectState.NONE;
            }
        } else {
            this.effects = EffectState.NONE;
        }
    }

    private void resize(int newSize) {
        this.image = new NativeImage(NativeImage.PixelFormat.RGBA, newSize, newSize, false);
        System.out.println("Map resized to " + newSize + "x" + newSize);
    }

    public void onConfigChanged() {
        int configScale = MappyConfig.scale;
        int configSize = MappyConfig.mapSize;
        boolean resize = false;
        if (configScale != this.scale) {
            this.scale = configScale;
            resize = true;
        }
        if (configSize != this.size) {
            this.size = configSize;
            resize = true;
        }
        if (resize) {
            this.size = configSize * this.scale;
            this.resize(this.size);
        }
    }

    private void updateInfo(PlayerEntity player) {
        this.manager.clear();
        if (this.showPosition) {
            BlockPos playerPos = Map.client.field_71439_g.func_180425_c();
            this.playerPositionInfo.setText(playerPos.func_177958_n() + " " + playerPos.func_177956_o() + " " + playerPos.func_177952_p());
            this.manager.add(this.playerPositionInfo);
        }
        if (this.showBiome) {
            this.biomeInfo.setText(I18n.func_135052_a((String)this.biome.func_210773_k(), (Object[])new Object[0]));
            this.manager.add(this.biomeInfo);
        }
        if (MappyConfig.showFPS) {
            this.fpsInfo.setText(Minecraft.func_175610_ah() + " fps");
            this.manager.add(this.fpsInfo);
        }
        if (this.showTime) {
            this.inGameTimeInfo.setText(this.getTimeFormatted(Map.client.field_71441_e.func_72820_D()));
            this.manager.add(this.inGameTimeInfo);
        }
        if (MappyConfig.showDirection) {
            Direction direction = player.func_174811_aO();
            this.directionInfo.setText(direction.toString());
            this.manager.add(this.directionInfo);
        }
    }

    public EffectState getEffects() {
        return this.effects;
    }

    private String getTimeFormatted(long time) {
        if (time > 24000L) {
            time %= 24000L;
        }
        int m = (int)((float)(time % 1000L) / 1000.0f * 60.0f);
        int h = (int)time / 1000 + 6;
        if (h >= 24) {
            h -= 24;
        }
        return (h < 10 ? "0" + h : Integer.valueOf(h)) + ":" + (m < 10 ? "0" + m : Integer.valueOf(m));
    }

    public TriValue<BlockPos, BlockState, Integer> getDebugData() {
        return this.debugData;
    }

    public void generate(PlayerEntity player) {
        World world = player.field_70170_p;
        BlockPos pos = player.func_180425_c();
        this.biome = world.func_180494_b(pos);
        DimensionType type = world.field_73011_w.func_186058_p();
        int scaled = this.scale * this.size;
        int startX = pos.func_177958_n() - scaled / 2;
        int startZ = pos.func_177952_p() - scaled / 2;
        int endX = startX + scaled;
        int endZ = startZ + scaled;
        ChunkCache.getPreLoader(world).update(this, startX, startZ);
        this.players.clear();
        this.players.add(this.playerIcon);
        List players = world.func_217369_A();
        for (PlayerEntity p : players) {
            if (p == player || p.func_70093_af() || p.func_175149_v()) continue;
            BlockPos ppos = p.func_180425_c();
            int x = ppos.func_177958_n();
            int z = ppos.func_177952_p();
            if (x < startX || x > endX || z < startZ || z > endZ) continue;
            MapIcon.Player playerIcon1 = new MapIcon.Player(this, p, false);
            playerIcon1.setPosition(MapIcon.getScaled(x, startX, endX, this.size), MapIcon.getScaled(z, startZ, endZ, this.size));
            this.players.add(playerIcon1);
        }
        if (MappyConfig.showEntities) {
            this.entities.clear();
            int checkHeight = 24;
            int y = player.func_180425_c().func_177956_o();
            BlockPos start = new BlockPos(startX, y - checkHeight / 2, startZ);
            BlockPos end = new BlockPos(endX, y + checkHeight / 2, endZ);
            List entities = world.func_217357_a(Entity.class, new AxisAlignedBB(start, end));
            int t = 0;
            for (Entity entity : entities) {
                if (entity instanceof LivingEntity && !(entity instanceof PlayerEntity)) {
                    ++t;
                    LivingEntity livingEntity = (LivingEntity)entity;
                    MapIcon.Entity mie = new MapIcon.Entity(this, entity, livingEntity instanceof MonsterEntity);
                    mie.setPosition(MapIcon.getScaled((int)entity.field_70165_t, startX, endX, this.size), MapIcon.getScaled((int)entity.field_70161_v, startZ, endZ, this.size));
                    this.entities.add(mie);
                }
                if (t < 250) continue;
                break;
            }
        }
        this.waypoints.clear();
        List<WayPoint> wps = WayPointManager.INSTANCE.getWaypoints(world.field_73011_w.func_186058_p().func_186068_a());
        ArrayList<WayPoint> toRemove = new ArrayList<WayPoint>();
        if (wps != null) {
            for (WayPoint wp : wps) {
                boolean show = false;
                if (!wp.hidden || wp.showAlways || wp.deathPoint) {
                    if (wp.showAlways && !wp.deathPoint) {
                        show = true;
                    } else {
                        double distS = MathUtil.getDistanceSqrd(pos, wp.pos);
                        if (wp.deathPoint) {
                            if (MappyConfig.autoRemoveDeathWaypoints && distS <= (double)(MappyConfig.autoRemoveRange * MappyConfig.autoRemoveRange)) {
                                if (EventListener.playerAlive && !(Minecraft.func_71410_x().field_71462_r instanceof DeathScreen)) {
                                    toRemove.add(wp);
                                }
                            } else {
                                show = true;
                            }
                        } else if (distS <= (double)(wp.showRange * wp.showRange)) {
                            show = true;
                        }
                    }
                }
                if (!show) continue;
                MapIcon.Waypoint waypoint = new MapIcon.Waypoint(this, wp);
                waypoint.setPosition(MathUtil.clamp(MapIcon.getScaled(wp.pos.func_177958_n(), startX, endX, this.size), 0, this.size), MathUtil.clamp(MapIcon.getScaled(wp.pos.func_177952_p(), startZ, endZ, this.size), 0, this.size));
                this.waypoints.add(waypoint);
            }
            toRemove.forEach(WayPointManager.INSTANCE::remove);
        }
    }

    public List<MapIcon.Player> getPlayerIcons() {
        return this.players;
    }

    public List<MapIcon.Waypoint> getWaypoints() {
        return this.waypoints;
    }

    public void createWayPoint() {
        this.createWayPoint(false);
    }

    public void createWayPoint(boolean death) {
        ClientPlayerEntity player = Map.client.field_71439_g;
        WayPoint wayPoint = new WayPoint();
        wayPoint.pos = player.func_180425_c();
        wayPoint.dimension = player.field_70170_p.field_73011_w.func_186058_p().func_186068_a();
        if (death) {
            wayPoint.deathPoint = true;
            wayPoint.iconType = IconType.SKULL;
            wayPoint.color = -10066330;
            wayPoint.name = "Death";
            WayPointManager.INSTANCE.add(wayPoint);
            Mappy.LOGGER.info("Created death waypoint [" + wayPoint.dimension + "] " + Util.prettyFy(wayPoint.pos));
            WayPointManager.INSTANCE.save();
        } else {
            wayPoint.name = "Waypoint";
            wayPoint.color = RandomUtil.getElement(WayPoint.WAYPOINT_COLORS);
            client.func_147108_a((Screen)new WayPointEditor(wayPoint, Map.client.field_71462_r, WayPointManager.INSTANCE::add));
        }
    }

    public NativeImage getImage() {
        return this.image;
    }

    public int getSize() {
        return this.size;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getSizeX() {
        return this.sizeX;
    }

    public int getSizeZ() {
        return this.sizeZ;
    }

    public List<MapIcon.Entity> getEntities() {
        return this.entities;
    }

    public MapInfoLineManager getManager() {
        return this.manager;
    }

    public void onConfigChanged(ConfigBase<?> configBase) {
        this.onConfigChanged();
    }

    public boolean canShowMap() {
        return this.showMap;
    }
}

