/*
 * Decompiled with CFR 0.152.
 */
package com.naxanria.mappy.gui.widget;

import com.naxanria.mappy.gui.DrawableHelperBase;
import com.naxanria.mappy.map.waypoint.IconType;
import com.naxanria.mappy.map.waypoint.WayPoint;
import com.naxanria.mappy.map.waypoint.WayPointEditor;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.math.MathHelper;

public class WaypointTypeSelectorWidget
extends Widget {
    private final WayPoint wayPoint;
    private final WayPointEditor editor;
    private int selectedIndex = 0;
    private int selectedBoxColor = -1;
    private int spacing = 20;

    public WaypointTypeSelectorWidget(int xIn, int yIn, String msg, WayPointEditor editor) {
        super(xIn, yIn, msg);
        this.height = 10;
        this.editor = editor;
        this.wayPoint = editor.getWaypoint();
        this.selectedIndex = this.wayPoint.iconType.ordinal();
    }

    public void render(int mouseX, int mouseY, float p_render_3_) {
        int col = this.editor.getPreviewColor();
        int hoveredIndex = this.getMouseOverIndex(mouseX, mouseY);
        IconType[] types = IconType.values();
        for (int i = 0; i < types.length; ++i) {
            int xp = this.x + this.spacing * i + this.spacing / 2;
            int yp = this.y + 5;
            if (i == this.selectedIndex || i == hoveredIndex) {
                DrawableHelperBase.rect(xp - 5, yp - 5, this.height, this.selectedBoxColor);
            }
            types[i].draw(xp, yp, col);
        }
    }

    public void onClick(double mouseX, double mouseY) {
        int index = this.getMouseOverIndex((int)mouseX, (int)mouseY);
        if (index >= 0) {
            this.selectedIndex = index;
        }
    }

    private int getMouseOverIndex(int mouseX, int mouseY) {
        if (this.isInside(mouseX, mouseY)) {
            return MathHelper.func_76125_a((int)((mouseX - this.x) / this.spacing), (int)0, (int)(IconType.values().length - 1));
        }
        return -1;
    }

    private boolean isInside(int mouseX, int mouseY) {
        return mouseX >= this.x && mouseX < this.x + this.width && mouseY >= this.y && mouseY < this.y + this.height;
    }

    public IconType getSelectedType() {
        return IconType.values()[this.selectedIndex];
    }
}

