/*
 * Decompiled with CFR 0.152.
 */
package com.naxanria.mappy.gui.widget;

import com.mojang.blaze3d.platform.GlStateManager;
import com.naxanria.mappy.util.EnumUtil;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;

public class CycleButton
extends Widget {
    private final FontRenderer font;
    protected final String[] values;
    protected int[] colors;
    protected int index;
    protected Consumer<CycleButton> onChangeCallback;

    public CycleButton(int xIn, int yIn, String ... values) {
        this(xIn, yIn, 0, values);
    }

    public CycleButton(int xIn, int yIn, int index, String ... values) {
        super(xIn, yIn, "");
        this.font = Minecraft.func_71410_x().field_71466_p;
        this.index = 0;
        this.values = values;
        this.width = 20;
        this.height = 20;
        for (String value : values) {
            this.width = Math.max(this.width, this.font.func_78256_a(value) + 4);
        }
        this.index = index;
    }

    public CycleButton setColors(int ... colors) {
        this.colors = colors;
        return this;
    }

    public CycleButton setOnChangeCallback(Consumer<CycleButton> onChangeCallback) {
        this.onChangeCallback = onChangeCallback;
        return this;
    }

    public void renderButton(int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
        Minecraft minecraft = Minecraft.func_71410_x();
        FontRenderer fontrenderer = minecraft.field_71466_p;
        minecraft.func_110434_K().func_110577_a(WIDGETS_LOCATION);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        int i = this.getYImage(this.isHovered());
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.blit(this.x, this.y, 0, 46 + i * 20, this.width / 2, this.height);
        this.blit(this.x + this.width / 2, this.y, 200 - this.width / 2, 46 + i * 20, this.width / 2, this.height);
        this.renderBg(minecraft, p_renderButton_1_, p_renderButton_2_);
        String val = this.values[this.index];
        this.drawCenteredString(fontrenderer, val, this.x + this.width / 2, this.y + (this.height - 8) / 2, this.colors == null ? -1 : this.colors[this.index % this.colors.length]);
    }

    public void onClick(double p_onClick_1_, double p_onClick_3_) {
        ++this.index;
        this.index %= this.values.length;
        if (this.onChangeCallback != null) {
            this.onChangeCallback.accept(this);
        }
    }

    public String getValue() {
        return this.values[this.index];
    }

    public int getIndex() {
        return this.index;
    }

    public CycleButton setIndex(int index) {
        this.index = index;
        return this;
    }

    public static class EnumButton<T extends Enum<T>>
    extends CycleButton {
        private final T[] values;
        private final T value;

        public EnumButton(int xIn, int yIn, T value) {
            this(xIn, yIn, ((Enum)value).ordinal(), value);
        }

        public EnumButton(int xIn, int yIn, int index, T value) {
            super(xIn, yIn, index, EnumUtil.getValueNames(value));
            this.value = value;
            this.values = EnumUtil.getValues(value);
        }

        public T get() {
            return this.values[this.index];
        }

        @Override
        public EnumButton<T> setOnChangeCallback(Consumer<CycleButton> onChangeCallback) {
            super.setOnChangeCallback(onChangeCallback);
            return this;
        }
    }

    public static class Boolean
    extends CycleButton {
        public Boolean(int x, int y) {
            this(x, y, true);
        }

        public Boolean(int x, int y, boolean value) {
            super(x, y, value ? 0 : 1, "True", "False");
            this.setColors(-16711936, -7864320);
        }

        public Boolean set(boolean value) {
            this.index = value ? 0 : 1;
            return this;
        }

        public boolean get() {
            return this.getIndex() == 0;
        }

        @Override
        public Boolean setOnChangeCallback(Consumer<CycleButton> onChangeCallback) {
            super.setOnChangeCallback(onChangeCallback);
            return this;
        }
    }
}

