/*
 * Decompiled with CFR 0.152.
 */
package com.naxanria.mappy.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponent;

public class ScreenBase
extends Screen {
    public final Screen parent;
    protected int mouseX;
    protected int mouseY;
    protected int windowWidth;
    protected int windowHeight;

    protected ScreenBase(TextComponent title) {
        this(title, null);
    }

    public ScreenBase(TextComponent title, Screen parent) {
        super((ITextComponent)title);
        this.parent = parent;
        this.minecraft = Minecraft.func_71410_x();
        this.font = this.minecraft.field_71466_p;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.windowWidth = this.minecraft.field_195558_d.func_198107_o();
        this.windowHeight = this.minecraft.field_195558_d.func_198087_p();
        this.renderPre();
        this.renderBackground();
        this.renderPreChildren();
        this.processChildren(mouseX, mouseY, partialTicks);
        this.renderPostChildren();
        this.renderForeground();
        this.renderPost();
    }

    protected void processChildren(int mouseX, int mouseY, float partialTicks) {
        for (IGuiEventListener listener : this.children) {
            this.processChild(mouseX, mouseY, partialTicks, listener);
        }
    }

    protected void processChild(int mouseX, int mouseY, float partialTicks, IGuiEventListener child) {
        if (child instanceof IRenderable) {
            ((IRenderable)child).render(mouseX, mouseY, partialTicks);
        }
    }

    public void renderPre() {
    }

    public void renderPreChildren() {
    }

    public void renderPostChildren() {
    }

    public void renderPost() {
    }

    public void renderForeground() {
    }

    public void onClose() {
        this.minecraft.func_147108_a(this.parent);
    }

    public void renderTexture(int x, int y, int width, int height, String id) {
        this.renderTexture(x, y, width, height, new ResourceLocation(id));
    }

    public void renderTexture(int x, int y, int width, int height, ResourceLocation id) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        this.minecraft.func_110434_K().func_110577_a(id);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        builder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        builder.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a(0.0, 1.0).func_181669_b(255, 255, 255, 255).func_181675_d();
        builder.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a(1.0, 1.0).func_181669_b(255, 255, 255, 255).func_181675_d();
        builder.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a(1.0, 0.0).func_181669_b(255, 255, 255, 255).func_181675_d();
        builder.func_181662_b((double)x, (double)y, 0.0).func_187315_a(0.0, 0.0).func_181669_b(255, 255, 255, 255).func_181675_d();
        tessellator.func_78381_a();
    }

    public void renderTexture(int x, int y, int width, int height, float u, float v, int r, int g, int b, int a, ResourceLocation id) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        this.minecraft.func_110434_K().func_110577_a(id);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        builder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        builder.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a(0.0, (double)v).func_181669_b(r, g, b, a).func_181675_d();
        builder.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)u, (double)v).func_181669_b(r, g, b, a).func_181675_d();
        builder.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a((double)u, 0.0).func_181669_b(r, g, b, a).func_181675_d();
        builder.func_181662_b((double)x, (double)y, 0.0).func_187315_a(0.0, 0.0).func_181669_b(r, g, b, a).func_181675_d();
        tessellator.func_78381_a();
    }

    public void renderTextureModal(int x, int y, int width, int height, int textureWidth, int textureHeight, ResourceLocation id) {
        this.renderTexture(x, y, width, height, (float)width / (float)textureWidth, (float)height / (float)textureHeight, 255, 255, 255, 255, id);
    }

    public void renderTextureRepeating(int x, int y, int width, int height, int textureHeight, int textureWidth, String id) {
        this.renderTextureRepeating(x, y, width, height, textureHeight, textureWidth, new ResourceLocation(id));
    }

    public void renderTextureRepeating(int x, int y, int width, int height, int textureHeight, int textureWidth, ResourceLocation id) {
        for (int xp = 0; xp < width; xp += textureWidth) {
            int w = xp + textureWidth < width ? textureWidth : width - xp;
            for (int yp = 0; yp < height; yp += textureHeight) {
                int h = yp + textureHeight < height ? textureHeight : height - yp;
                this.renderTextureModal(x + xp, y + yp, w, h, textureWidth, textureHeight, id);
            }
        }
    }

    public String lang(String key) {
        return I18n.func_135052_a((String)("mappy.gui." + key), (Object[])new Object[0]);
    }

    public PlayerEntity getLocalPlayer() {
        return this.minecraft.field_71439_g;
    }
}

