/*
 * Decompiled with CFR 0.152.
 */
package com.naxanria.mappy.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public class DrawableHelperBase
extends AbstractGui {
    public static final int WHITE = -1;
    public static final int RED = -65536;
    public static final int GREEN = -16711936;
    public static final int BLUE = -16776961;
    public static final int BLACK = -16777216;
    public static final Minecraft client = Minecraft.func_71410_x();

    public void fillNoDepth(int x, int y, int right, int left, int color) {
        GlStateManager.disableDepthTest();
        DrawableHelperBase.fill((int)x, (int)y, (int)right, (int)left, (int)color);
        GlStateManager.enableDepthTest();
    }

    public void drawStringCenteredBound(FontRenderer font, String string, int x, int y, int leftBound, int rightBound, int color) {
        if (string == null) {
            return;
        }
        int stringWidth = font.func_78256_a(string);
        int drawX = x - stringWidth / 2;
        if (drawX < leftBound) {
            drawX = leftBound;
        } else if (drawX + stringWidth > rightBound) {
            drawX = rightBound - stringWidth;
        }
        this.drawString(font, string, drawX, y, color);
    }

    public static void diamond(int x, int y, int width, int height, int color) {
        DrawableHelperBase.triangle(x, y + height / 2, x + width, y + height / 2, x + width / 2, y, color);
        DrawableHelperBase.triangle(x, y + height / 2, x + width / 2, y + height, x + width, y + height / 2, color);
    }

    public static void triangle(int x1, int y1, int x2, int y2, int x3, int y3, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        GlStateManager.enableBlend();
        GlStateManager.disableTexture();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.color4f((float)r, (float)g, (float)b, (float)a);
        builder.func_181668_a(4, DefaultVertexFormats.field_181705_e);
        builder.func_181662_b((double)x1, (double)y1, 0.0).func_181675_d();
        builder.func_181662_b((double)x2, (double)y2, 0.0).func_181675_d();
        builder.func_181662_b((double)x3, (double)y3, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.enableTexture();
        GlStateManager.disableBlend();
    }

    public static void line(int x1, int y1, int x2, int y2, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        GlStateManager.enableBlend();
        GlStateManager.disableTexture();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.color4f((float)r, (float)g, (float)b, (float)a);
        builder.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        builder.func_181662_b((double)x1, (double)y1, 0.0).func_181675_d();
        builder.func_181662_b((double)x2, (double)y2, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.enableTexture();
        GlStateManager.disableBlend();
    }

    public static void rect(int x, int y, int size, int color) {
        DrawableHelperBase.rect(x, y, size, size, color);
    }

    public static void rect(int x, int y, int width, int height, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        GlStateManager.enableBlend();
        GlStateManager.disableTexture();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.color4f((float)r, (float)g, (float)b, (float)a);
        builder.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        builder.func_181662_b((double)x, (double)y, 0.0).func_181675_d();
        builder.func_181662_b((double)(x + width), (double)y, 0.0).func_181675_d();
        builder.func_181662_b((double)(x + width), (double)y, 0.0).func_181675_d();
        builder.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_181675_d();
        builder.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_181675_d();
        builder.func_181662_b((double)x, (double)(y + height), 0.0).func_181675_d();
        builder.func_181662_b((double)x, (double)y, 0.0).func_181675_d();
        builder.func_181662_b((double)x, (double)(y + height), 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.enableTexture();
        GlStateManager.disableBlend();
    }
}

