/*
 * Decompiled with CFR 0.152.
 */
package com.naxanria.mappy.event;

import com.naxanria.mappy.event.KeyParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public enum KeyHandler {
    INSTANCE;

    private List<KeyParser> parsers = new ArrayList<KeyParser>();
    private Map<Integer, Boolean> keyStates = new HashMap<Integer, Boolean>();
    private Map<Integer, Boolean> previousStates = new HashMap<Integer, Boolean>();
    private List<Integer> toWatch = new ArrayList<Integer>();

    public void register(KeyParser parser) {
        ClientRegistry.registerKeyBinding((KeyBinding)parser.keyBinding);
        this.parsers.add(parser);
    }

    void update() {
        this.previousStates = this.keyStates;
        this.keyStates = new HashMap<Integer, Boolean>();
        Iterator<Object> iterator = this.toWatch.iterator();
        while (iterator.hasNext()) {
            int code = iterator.next();
            this.keyStates.put(code, InputMappings.func_216506_a((long)Minecraft.func_71410_x().field_195558_d.func_198092_i(), (int)code));
        }
        for (KeyParser kp : this.parsers) {
            kp.update();
        }
    }

    public boolean isKeyPressed(int keyCode) {
        if (!this.isWatching(keyCode)) {
            return false;
        }
        return this.previousStates.getOrDefault(keyCode, false) == false && this.keyStates.getOrDefault(keyCode, false) != false;
    }

    public boolean isKeyDown(int keyCode) {
        if (this.isWatching(keyCode)) {
            return this.keyStates.getOrDefault(keyCode, false);
        }
        this.toWatch.add(keyCode);
        return InputMappings.func_216506_a((long)Minecraft.func_71410_x().field_195558_d.func_198092_i(), (int)keyCode);
    }

    public boolean isKeyUp(int keyCode) {
        if (!this.isWatching(keyCode)) {
            return false;
        }
        return this.previousStates.getOrDefault(keyCode, false) != false && this.keyStates.getOrDefault(keyCode, false) == false;
    }

    public void watch(int keyCode) {
        if (!this.toWatch.contains(keyCode)) {
            this.toWatch.add(keyCode);
        }
    }

    public void watch(int ... keyCodes) {
        for (int code : keyCodes) {
            this.watch(code);
        }
    }

    public boolean isWatching(int keyCode) {
        return this.toWatch.contains(keyCode);
    }
}

