/*
 * Decompiled with CFR 0.152.
 */
package com.naxanria.mappy.event;

import com.naxanria.mappy.Mappy;
import com.naxanria.mappy.config.MappyConfig;
import com.naxanria.mappy.event.KeyHandler;
import com.naxanria.mappy.event.KeyParser;
import com.naxanria.mappy.map.MapGUI;
import com.naxanria.mappy.map.WorldMapGUI;
import com.naxanria.mappy.map.waypoint.WayPointListEditor;
import com.naxanria.mappy.util.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="mappy")
public class EventListener {
    public static final String KEY_BIND_CATEGORY = "mappy";
    public static boolean playerAlive = true;

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && Mappy.showMap) {
            Mappy.map.update();
        }
        KeyHandler.INSTANCE.update();
    }

    @SubscribeEvent
    public static void hudUpdate(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        MapGUI gui = MapGUI.instance;
        if (gui != null) {
            gui.draw();
        }
    }

    public static void setupKeyBinds() {
        KeyHandler.INSTANCE.register(new KeyParser(EventListener.createKeyBinding("hide_map", 72, KeyConflictContext.IN_GAME)){

            @Override
            public void onKeyUp() {
                Mappy.showMap = !Mappy.showMap;
            }

            @Override
            public boolean isListening() {
                return 1.mc.field_71462_r == null;
            }
        });
        KeyHandler.INSTANCE.register(new KeyParser(EventListener.createKeyBinding("create_waypoint", 66, KeyConflictContext.IN_GAME)){

            @Override
            public void onKeyUp() {
                Mappy.map.createWayPoint();
            }

            @Override
            public boolean isListening() {
                return 2.mc.field_71439_g != null && 2.mc.field_71462_r == null;
            }
        });
        KeyHandler.INSTANCE.register(new KeyParser(EventListener.createKeyBinding("waypoints_list", 85, KeyConflictContext.IN_GAME)){

            @Override
            public void onKeyUp() {
                mc.func_147108_a((Screen)new WayPointListEditor(null));
            }

            @Override
            public boolean isListening() {
                return 3.mc.field_71439_g != null && 3.mc.field_71462_r == null;
            }
        });
        if (MappyConfig.enableWorldMapKey) {
            KeyHandler.INSTANCE.register(new KeyParser(EventListener.createKeyBinding("map", 77, KeyConflictContext.IN_GAME)){

                @Override
                public void onKeyUp() {
                    mc.func_147108_a((Screen)new WorldMapGUI(null));
                }

                @Override
                public boolean isListening() {
                    return 4.mc.field_71462_r == null;
                }
            });
        }
    }

    private static KeyBinding createKeyBinding(String name, int key, KeyConflictContext conflictContext) {
        return new KeyBinding(name, (IKeyConflictContext)conflictContext, InputMappings.Type.KEYSYM, key, KEY_BIND_CATEGORY);
    }

    @SubscribeEvent
    public static void entityDeath(LivingDeathEvent event) {
        if (event.getEntity() instanceof PlayerEntity) {
            Mappy.LOGGER.info("Detected death");
            PlayerEntity player = (PlayerEntity)event.getEntity();
            if (player.func_110124_au() != Minecraft.func_71410_x().field_71439_g.func_110124_au()) {
                return;
            }
            if (MappyConfig.printDeathPointInChat) {
                player.func_145747_a((ITextComponent)new StringTextComponent("You died at " + Util.prettyFy(player.func_180425_c())));
            }
            if (MappyConfig.createDeathWaypoints) {
                Mappy.map.createWayPoint(true);
            }
            playerAlive = false;
        }
    }

    @SubscribeEvent
    public static void playerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player.func_110124_au() != Minecraft.func_71410_x().field_71439_g.func_110124_au()) {
            return;
        }
        Mappy.LOGGER.info("Respawned");
        playerAlive = true;
    }
}

