/*
 * Decompiled with CFR 0.152.
 */
package com.naxanria.mappy.config.gui;

import com.naxanria.mappy.config.gui.ConfigGuiEntry;
import com.naxanria.mappy.util.Predicates;
import java.util.function.Predicate;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraftforge.common.ForgeConfigSpec;

public class IntegerConfigGuiEntry
extends ConfigGuiEntry<Integer, ForgeConfigSpec.IntValue> {
    private TextFieldWidget integerField;
    private static Predicate<String> validNumber = s -> Predicates.or(s, Predicates.isInteger, Predicates.isEmpty, s1 -> s.equals("-"));

    public IntegerConfigGuiEntry(ForgeConfigSpec configSpec, ForgeConfigSpec.IntValue configValue) {
        super(configSpec, configValue);
    }

    @Override
    public void init() {
        super.init();
        if (this.integerField == null) {
            this.integerField = new TextFieldWidget(font, 0, 0, font.func_78256_a("-999999999"), this.height, ((Integer)this.value).toString());
            this.integerField.func_200675_a(validNumber);
            this.integerField.func_146203_f(11);
            this.integerField.func_146180_a(((Integer)this.displayValue).toString());
            this.integerField.func_212954_a(s -> {
                this.displayValue = this.getValue();
            });
        }
        this.rightAlign((Widget)this.integerField, (Widget)this.resetStartValueButton, 1);
        this.integerField.y = this.y;
        this.integerField.func_146193_g(this.inRange() ? -1 : -65536);
        this.children.add(this.integerField);
    }

    public int getValue() {
        String val = this.integerField.func_146179_b();
        try {
            return val.equals("") || val.equals("-") ? 0 : Integer.parseInt(val);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public boolean inRange() {
        Integer val = this.getValue();
        Object correct = this.valueSpec.correct((Object)val);
        return correct == val;
    }

    @Override
    protected void setDisplayValue(Integer value) {
        super.setDisplayValue(value);
        this.integerField.func_146180_a(value.toString());
    }
}

