/*
 * Decompiled with CFR 0.152.
 */
package com.naxanria.mappy.config.gui;

import com.naxanria.mappy.gui.DrawableHelperBase;
import com.naxanria.mappy.util.BiValue;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;

public class GuiTooltip
extends DrawableHelperBase {
    public static final FontRenderer FONT = Minecraft.func_71410_x().field_71466_p;
    protected int border = 2;
    protected int borderColor = -10000537;
    protected int bgColor = -13421773;
    protected int padding = 4;
    protected int spacing = 2;
    public int x;
    public int y;
    public int width;
    public int height;
    private List<BiValue<String, Integer>> tooltipInfo = new ArrayList<BiValue<String, Integer>>();

    public GuiTooltip addInfo(String info) {
        return this.addInfo(info, -1);
    }

    public GuiTooltip addInfo(String info, int color) {
        int w = FONT.func_78256_a(info);
        if (w + 2 * this.padding + 2 * this.border > this.width) {
            this.width = w + 2 * this.padding + 2 * this.border;
        }
        this.tooltipInfo.add(new BiValue<String, Integer>(info, color));
        FONT.getClass();
        this.height = 2 * this.padding + 2 * this.border + (9 + this.spacing) * this.tooltipInfo.size() - this.spacing;
        return this;
    }

    public GuiTooltip range(int min, int max) {
        return this.addInfo("Range: [" + min + " - " + max + "]", -13391122);
    }

    public GuiTooltip def(boolean val) {
        return this.def(val ? "True" : "False");
    }

    public GuiTooltip def(int val) {
        return this.def("" + val);
    }

    public GuiTooltip def(String val) {
        return this.addInfo("Default: " + val, -16742264);
    }

    public GuiTooltip line() {
        return this.addInfo("---", -7807744);
    }

    public void render(int x, int y) {
        Minecraft minecraft = Minecraft.func_71410_x();
        int windowWidth = minecraft.field_195558_d.func_198107_o();
        int windowHeight = minecraft.field_195558_d.func_198087_p();
        if (x + this.width > windowWidth) {
            x = windowWidth - this.width;
        }
        if (x < 0) {
            x = 0;
        }
        if (y + this.height > windowHeight) {
            y = windowHeight - this.height;
        }
        if (y < 0) {
            y = 0;
        }
        GuiTooltip.fill((int)x, (int)y, (int)(x + this.width), (int)(y + this.height), (int)this.borderColor);
        GuiTooltip.fill((int)(x + this.border), (int)(y + this.border), (int)(x + this.width - this.border), (int)(y + this.height - this.border), (int)this.bgColor);
        int yp = y + this.border + this.padding;
        int xp = x + this.border + this.padding;
        for (BiValue<String, Integer> info : this.tooltipInfo) {
            this.drawCenteredString(FONT, (String)info.A, x + this.width / 2, yp, (Integer)info.B);
            FONT.getClass();
            yp += 9 + this.spacing;
        }
    }

    public boolean isEmpty() {
        return this.tooltipInfo.isEmpty();
    }
}

