/*
 * Decompiled with CFR 0.152.
 */
package com.naxanria.mappy.config.gui;

import com.naxanria.mappy.config.gui.GuiTooltip;
import com.naxanria.mappy.gui.DrawableHelperBase;
import com.naxanria.mappy.gui.widget.TextWidget;
import com.naxanria.mappy.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.INestedGuiEventHandler;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.client.config.GuiButtonExt;

public class ConfigGuiEntry<CV, CT extends ForgeConfigSpec.ConfigValue<CV>>
extends DrawableHelperBase
implements IRenderable,
INestedGuiEventHandler {
    protected static final FontRenderer font = Minecraft.func_71410_x().field_71466_p;
    protected int width = 250;
    protected int height = 20;
    public int x;
    public int y;
    protected ForgeConfigSpec configSpec;
    protected final CT configValue;
    protected final ForgeConfigSpec.ValueSpec valueSpec;
    protected CV displayValue;
    protected final CV value;
    protected final CV def;
    protected String name;
    protected TextWidget nameWidget;
    protected GuiButtonExt resetDefaultButton;
    protected GuiButtonExt resetStartValueButton;
    protected IGuiEventListener focus = null;
    protected boolean dragging = false;
    protected final List<Widget> children = new ArrayList<Widget>();
    protected GuiTooltip tooltip = new GuiTooltip();
    boolean hovered = false;

    public ConfigGuiEntry(ForgeConfigSpec configSpec, CT configValue) {
        this.configSpec = configSpec;
        this.configValue = configValue;
        this.valueSpec = (ForgeConfigSpec.ValueSpec)configSpec.get(configValue.getPath());
        this.value = configValue.get();
        this.def = this.valueSpec.getDefault();
        this.displayValue = this.value;
        String key = this.valueSpec.getTranslationKey();
        this.name = key != null ? I18n.func_135052_a((String)key, (Object[])new Object[0]) : StringUtil.combine(configValue.getPath(), ".");
        int bWidth = 45;
        this.resetDefaultButton = new GuiButtonExt(0, 0, bWidth, this.height, "default", this::resetToDefault);
        this.resetStartValueButton = new GuiButtonExt(0, 0, bWidth, this.height, "reset", this::resetToStartValue);
        this.nameWidget = new TextWidget(0, 0, this.name);
        this.init();
    }

    public void init() {
        this.children.clear();
        this.nameWidget.x = this.x + 2;
        this.nameWidget.y = this.y + this.height / 2 - this.nameWidget.getHeight() / 2;
        this.children.add(this.nameWidget);
        this.resetDefaultButton.y = this.y;
        this.resetDefaultButton.active = !this.isDefault();
        this.children.add(this.rightAlign((Widget)this.resetDefaultButton, this.width));
        this.resetStartValueButton.y = this.y;
        this.resetStartValueButton.active = this.isChanged();
        this.children.add(this.rightAlign((Widget)this.resetStartValueButton, (Widget)this.resetDefaultButton, 1));
    }

    public void resetToDefault(Button ctx) {
        this.setDisplayValue(this.def);
    }

    public void resetToStartValue(Button ctx) {
        this.setDisplayValue(this.value);
    }

    protected void setDisplayValue(CV value) {
        this.displayValue = value;
    }

    public void save() {
        if (this.displayValue != this.value) {
            this.configValue.set(this.displayValue);
        }
    }

    public ConfigGuiEntry<CV, CT> setPosition(int x, int y) {
        this.x = x;
        this.y = y;
        this.init();
        return this;
    }

    protected Widget rightAlign(Widget w, int right) {
        w.x = right - w.getWidth();
        return w;
    }

    protected Widget rightAlign(Widget w, Widget right) {
        return this.rightAlign(w, right, 0);
    }

    protected Widget rightAlign(Widget w, Widget right, int spacing) {
        w.x = right.x - w.getWidth() - spacing;
        return w;
    }

    protected int getXRightAligned(Widget w, int right) {
        return right - w.getWidth();
    }

    protected int getXRightAligned(Widget w, Widget toAlignTo, int spacing) {
        return this.getXRightAligned(w, toAlignTo.x - spacing);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.hovered = this.isMouseOver(mouseX, mouseY);
        ConfigGuiEntry.fill((int)this.x, (int)(this.y + 1), (int)(this.x + this.width), (int)(this.y + this.height - 1), (int)(this.hovered ? -1439419340 : -1442840576));
        for (Widget widget : this.children) {
            widget.render(mouseX, mouseY, partialTicks);
        }
    }

    public List<? extends IGuiEventListener> children() {
        return this.children;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public void setDragging(boolean dragging) {
        this.dragging = dragging;
    }

    @Nullable
    public IGuiEventListener getFocused() {
        return this.focus;
    }

    public void setFocused(@Nullable IGuiEventListener newFocus) {
        if (this.focus != null) {
            this.focus.changeFocus(false);
        }
        this.focus = newFocus;
        if (this.focus != null) {
            this.focus.changeFocus(true);
        }
    }

    public boolean isChanged() {
        return this.displayValue != this.value;
    }

    public boolean isDefault() {
        return this.displayValue == this.def;
    }

    public GuiTooltip getTooltip() {
        return this.hovered && !this.tooltip.isEmpty() ? this.tooltip : null;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height);
    }
}

