/*
 * Decompiled with CFR 0.152.
 */
package com.naxanria.mappy.config.gui;

import com.naxanria.mappy.config.ConfigCategoryNode;
import com.naxanria.mappy.config.MappyConfig;
import com.naxanria.mappy.config.gui.BooleanConfigGuiEntry;
import com.naxanria.mappy.config.gui.CategoryWidget;
import com.naxanria.mappy.config.gui.ConfigGuiEntry;
import com.naxanria.mappy.config.gui.EnumConfigGuiEntry;
import com.naxanria.mappy.config.gui.GuiTooltip;
import com.naxanria.mappy.config.gui.IntegerConfigGuiEntry;
import com.naxanria.mappy.gui.ScreenBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.client.config.GuiButtonExt;

public class ConfigGui
extends ScreenBase {
    private List<ConfigGuiEntry<?, ?>> entries = new ArrayList();
    private List<String> keys = new ArrayList<String>();
    private ForgeConfigSpec spec;
    private GuiTooltip tooltip = null;
    private ConfigGuiEntry<?, ?> lastEntry;
    private Map<ConfigCategoryNode, CategoryWidget> widgetMap = new HashMap<ConfigCategoryNode, CategoryWidget>();
    private ConfigCategoryNode categories = ConfigCategoryNode.create();
    private ConfigCategoryNode currentCategory;
    private List<String> subCategories;
    private CategoryWidget categoryWidget;
    private List<GuiButtonExt> subCategoryButtons = new ArrayList<GuiButtonExt>();
    private GuiButtonExt saveButton;
    private GuiButtonExt cancelButton;

    public ConfigGui(Screen parent) {
        super((TextComponent)new StringTextComponent("Config"), parent);
        this.spec = MappyConfig.getSpec();
        this.currentCategory = this.categories.push("General");
        this.addEntry((ForgeConfigSpec.IntValue)MappyConfig.config.mapSize).tooltip.addInfo("The size of the map.").range(16, 256).def(64);
        this.addEntry((ForgeConfigSpec.IntValue)MappyConfig.config.offset).tooltip.addInfo("Offset of the map").range(0, 8).def(4);
        this.addEntry(MappyConfig.config.drawPosition).tooltip.addInfo("The position of the map").def("TOP_RIGHT");
        this.currentCategory = this.currentCategory.push("Look and Feel");
        this.addEntry((ForgeConfigSpec.BooleanValue)MappyConfig.config.moveMapForEffects).tooltip.addInfo("Should the map move if there are potion effects.").def(true);
        this.addEntry((ForgeConfigSpec.BooleanValue)MappyConfig.config.shaded).tooltip.addInfo("Shade the map.").def(true);
        this.addEntry((ForgeConfigSpec.IntValue)MappyConfig.config.shadeStrength).tooltip.addInfo("Strength of the shading, the lower, the stronger.").range(2, 16).def(10);
        this.addEntry((ForgeConfigSpec.BooleanValue)MappyConfig.config.drawChunkGrid).tooltip.addInfo("The chunk grid").def(false);
        this.addEntry((ForgeConfigSpec.BooleanValue)MappyConfig.config.showInChat).tooltip.addInfo("Show the map while chat is open").def(true);
        this.currentCategory = this.currentCategory.pop().push("Death");
        this.addEntry(MappyConfig.config.createDeathWayPoints);
        this.lastEntry.tooltip.addInfo("Create a way point on death").def(true);
        this.addEntry(MappyConfig.config.printDeathPointInChat);
        this.lastEntry.tooltip.addInfo("Print the death position into your chat.").def(false);
        this.addEntry(MappyConfig.config.autoRemoveDeathWaypoint);
        this.lastEntry.tooltip.addInfo("Remove the death-waypoint when you are close").def(true);
        this.addEntry(MappyConfig.config.autoRemoveRange);
        this.lastEntry.tooltip.addInfo("Distance for when the death-waypoint will be automatically removed.").def(5);
        this.currentCategory = this.currentCategory.getTop().push("Info");
        this.addEntry((ForgeConfigSpec.BooleanValue)MappyConfig.config.showPosition).tooltip.addInfo("Show the current position").def(true);
        this.addEntry((ForgeConfigSpec.BooleanValue)MappyConfig.config.showFPS).tooltip.addInfo("Show the current FPS").def(false);
        this.addEntry((ForgeConfigSpec.BooleanValue)MappyConfig.config.showBiome).tooltip.addInfo("Show biome name").def(true);
        this.addEntry((ForgeConfigSpec.BooleanValue)MappyConfig.config.showTime).tooltip.addInfo("Show in game time").def(true);
        this.addEntry((ForgeConfigSpec.BooleanValue)MappyConfig.config.showDirection).tooltip.addInfo("Show current direction").def(false);
        this.currentCategory = this.currentCategory.push("Map");
        this.addEntry((ForgeConfigSpec.BooleanValue)MappyConfig.config.showPlayerNames).tooltip.addInfo("Show player names of other players").def(true);
        this.addEntry((ForgeConfigSpec.BooleanValue)MappyConfig.config.showPlayerHeads).tooltip.addInfo("Show the player heads instead of dots").def(true);
        this.addEntry((ForgeConfigSpec.BooleanValue)MappyConfig.config.showEntities).tooltip.addInfo("Show entities nearby").def(true);
        this.currentCategory = this.currentCategory.getTop().push("Optimization");
        this.addEntry((ForgeConfigSpec.IntValue)MappyConfig.config.updatePerCycle).tooltip.addInfo("How many chunks on the map to update per tick").range(1, 100).def(10);
        this.addEntry((ForgeConfigSpec.IntValue)MappyConfig.config.pruneDelay).tooltip.addInfo("Delay before pruning cached chunks (in seconds)").range(20, 600).def(60);
        this.addEntry((ForgeConfigSpec.IntValue)MappyConfig.config.pruneAmount).tooltip.addInfo("The max amount of chunks to prune from the cache").range(100, 6000).def(1500);
        this.addEntry((ForgeConfigSpec.BooleanValue)MappyConfig.config.forceHeightmapUse).tooltip.addInfo("Forces use of heightmap for height checking,").addInfo("this is more performing but can be less accurate").def(true);
        if (MappyConfig.showItemConfigInGame) {
            this.currentCategory = this.currentCategory.getTop().push("Items");
            this.addEntry((ForgeConfigSpec.BooleanValue)MappyConfig.config.inHotBar).tooltip.addInfo("Require the items to be in the hotbar").def(false);
            this.addEntry(MappyConfig.config.mapItem).tooltip.addInfo("The item required for showing the map");
            this.addEntry(MappyConfig.config.positionItem).tooltip.addInfo("The item required for showing current position");
            this.addEntry(MappyConfig.config.biomeItem).tooltip.addInfo("The item required for showing current biome");
            this.addEntry(MappyConfig.config.timeItem).tooltip.addInfo("The item required for showing current in game time");
        }
        this.currentCategory = this.currentCategory.getTop();
        String s = I18n.func_135052_a((String)"mappy.gui.save", (Object[])new Object[0]);
        int w = this.font.func_78256_a(s);
        this.saveButton = new GuiButtonExt(8, 0, w + 8, 20, s, this::save);
        s = I18n.func_135052_a((String)"mappy.gui.cancel", (Object[])new Object[0]);
        w = this.font.func_78256_a(s);
        this.cancelButton = new GuiButtonExt(8 + this.saveButton.getWidth(), 0, w + 8, 20, s, this::cancel);
        this.setupCategory();
    }

    public void init() {
        this.windowWidth = this.minecraft.field_195558_d.func_198107_o();
        this.windowHeight = this.minecraft.field_195558_d.func_198087_p();
        this.children.clear();
        int x = 8;
        for (String subCat : this.subCategories) {
            if (subCat.equals("Hidden")) continue;
            int w = this.font.func_78256_a(subCat) + 8;
            GuiButtonExt subButton = new GuiButtonExt(x, 22, w, 20, subCat, this::subCat);
            x += w + 1;
            this.subCategoryButtons.add(subButton);
        }
        this.children.addAll(this.subCategoryButtons);
        this.children.addAll(this.entries);
        if (this.categoryWidget != null) {
            this.children.add(this.categoryWidget);
        }
        this.cancelButton.y = this.saveButton.y = this.windowHeight - 22 + 2;
        this.children.add(this.saveButton);
        this.children.add(this.cancelButton);
    }

    private void subCat(Button b) {
        this.setNode(this.currentCategory.getChild(b.getMessage()));
    }

    public void setupCategory() {
        this.entries.clear();
        this.subCategoryButtons.clear();
        this.subCategories = this.currentCategory.getChildren();
        this.entries.addAll(this.currentCategory.getEntries());
        if (!this.widgetMap.containsKey(this.currentCategory)) {
            this.categoryWidget = new CategoryWidget(8, 2, this.currentCategory, this);
            this.widgetMap.put(this.currentCategory, this.categoryWidget);
        } else {
            this.categoryWidget = this.widgetMap.get(this.currentCategory);
        }
        this.init();
    }

    protected ConfigGui addEntry(ForgeConfigSpec.ConfigValue<String> var) {
        return this.addEntry(new ConfigGuiEntry(this.spec, var));
    }

    protected ConfigGui addEntry(ForgeConfigSpec.IntValue var) {
        return this.addEntry(new IntegerConfigGuiEntry(this.spec, var));
    }

    protected ConfigGui addEntry(ForgeConfigSpec.BooleanValue var) {
        return this.addEntry(new BooleanConfigGuiEntry(this.spec, var));
    }

    protected <T extends Enum<T>> ConfigGui addEntry(ForgeConfigSpec.EnumValue<T> var) {
        return this.addEntry(new EnumConfigGuiEntry<T>(this.spec, var));
    }

    protected ConfigGui addEntry(ConfigGuiEntry<?, ?> entry) {
        this.lastEntry = entry;
        this.currentCategory.add(entry);
        this.tooltip = entry.tooltip;
        return this;
    }

    public void renderBackground() {
        this.renderDirtBackground(0);
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.renderBackground();
        this.renderEntries();
        this.renderTop();
        this.renderBottom();
        this.renderForeground();
    }

    private void renderEntries() {
        int x = 10;
        int y = 48;
        int width = this.windowWidth - x - 20;
        boolean scroll = false;
        int spacing = 2;
        int totHeight = 0;
        ConfigGui.fill((int)0, (int)45, (int)this.windowWidth, (int)(this.windowHeight - 22), (int)-1442840576);
        this.tooltip = null;
        for (ConfigGuiEntry<?, ?> entry : this.entries) {
            entry.width = width;
            entry.setPosition(x, y);
            int h = entry.height;
            totHeight += h + spacing;
            y += h + spacing;
            entry.render(this.mouseX, this.mouseY, 0.0f);
            if (this.tooltip != null) continue;
            this.tooltip = entry.getTooltip();
            if (this.tooltip == null) continue;
            this.tooltip.x = entry.x;
            this.tooltip.y = entry.y - this.tooltip.height - 2;
        }
    }

    private void renderBottom() {
        int h = 22;
        this.saveButton.renderButton(this.mouseX, this.mouseY, 0.0f);
        this.cancelButton.renderButton(this.mouseX, this.mouseY, 0.0f);
    }

    private void renderTop() {
        if (this.categoryWidget != null) {
            this.categoryWidget.render(this.mouseX, this.mouseY, 0.0f);
        }
        for (GuiButtonExt button : this.subCategoryButtons) {
            button.renderButton(this.mouseX, this.mouseY, 0.0f);
        }
    }

    @Override
    public void renderPreChildren() {
        this.tooltip = null;
    }

    @Override
    public void renderForeground() {
        if (this.tooltip != null) {
            this.tooltip.render(this.tooltip.x, this.tooltip.y);
        }
    }

    public void setNode(ConfigCategoryNode node) {
        this.currentCategory = node;
        this.setupCategory();
    }

    private void save(Button button) {
        this.entries.forEach(ConfigGuiEntry::save);
        this.onClose();
    }

    private void cancel(Button button) {
        this.onClose();
    }

    public static class Builder {
        private final Screen parentScreen;
        private final ConfigCategoryNode categories = ConfigCategoryNode.create();

        public Builder(Screen parentScreen) {
            this.parentScreen = parentScreen;
        }

        public static Builder create(Screen parenTScreen) {
            return new Builder(parenTScreen);
        }

        public ConfigGui build() {
            return new ConfigGui(this.parentScreen);
        }
    }
}

