/*
 * Decompiled with CFR 0.152.
 */
package com.naxanria.mappy.config.gui;

import com.naxanria.mappy.config.ConfigCategoryNode;
import com.naxanria.mappy.config.gui.ConfigGui;
import com.naxanria.mappy.gui.DrawableHelperBase;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.INestedGuiEventHandler;
import net.minecraft.client.gui.IRenderable;
import net.minecraftforge.fml.client.config.GuiButtonExt;

public class CategoryWidget
extends DrawableHelperBase
implements IRenderable,
INestedGuiEventHandler {
    protected static final FontRenderer font = Minecraft.func_71410_x().field_71466_p;
    protected final List<IGuiEventListener> children = new ArrayList<IGuiEventListener>();
    protected IGuiEventListener focus = null;
    protected boolean dragging = false;
    public int x;
    public int y;
    public final int height = 20;
    public final int width;
    protected ConfigCategoryNode node;
    protected ConfigGui gui;
    protected List<GuiButtonExt> categoryButtons = new ArrayList<GuiButtonExt>();
    protected final int currentDepth;

    public CategoryWidget(int x, int y, ConfigCategoryNode node, ConfigGui gui) {
        this.x = x;
        this.y = y;
        this.node = node;
        this.gui = gui;
        String full = node.getFullName(false);
        String[] cats = full.split("\\.");
        int xp = x;
        int tw = 0;
        int depth = 0;
        for (String name : cats) {
            int w = font.func_78256_a(name) + 8;
            int d = cats.length - 1 - depth;
            GuiButtonExt b = new GuiButtonExt(xp, y, w, 20, name, button -> this.clicked(d));
            if (d == 0) {
                b.active = false;
            }
            ++depth;
            this.categoryButtons.add(b);
            xp += w + 1;
            tw += w + 1;
        }
        this.currentDepth = depth;
        this.width = tw;
        this.children.addAll(this.categoryButtons);
    }

    private void clicked(int depth) {
        ConfigCategoryNode node = this.node;
        if (node.isTop()) {
            return;
        }
        if (depth == 1) {
            node = node.pop();
        } else {
            for (int i = 0; i < depth; ++i) {
                node = node.pop();
            }
        }
        this.gui.setNode(node);
    }

    public List<? extends IGuiEventListener> children() {
        return this.children;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public void setDragging(boolean dragging) {
        this.dragging = dragging;
    }

    @Nullable
    public IGuiEventListener getFocused() {
        return this.focus;
    }

    public void setFocused(@Nullable IGuiEventListener newFocus) {
        this.focus = newFocus;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        for (IGuiEventListener child : this.children) {
            if (!(child instanceof IRenderable)) continue;
            ((IRenderable)child).render(mouseX, mouseY, partialTicks);
        }
    }
}

