/*
 * Decompiled with CFR 0.152.
 */
package com.naxanria.mappy.config;

import com.naxanria.mappy.Mappy;
import com.naxanria.mappy.gui.DrawPosition;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;

public class MappyConfig {
    public static int offset = 4;
    public static DrawPosition drawPosition = DrawPosition.TOP_RIGHT;
    public static int mapSize = 64;
    public static boolean createDeathWaypoints = true;
    public static boolean autoRemoveDeathWaypoints = true;
    public static int autoRemoveRange = 5;
    public static boolean printDeathPointInChat = false;
    public static boolean showPosition = true;
    public static boolean showFPS = false;
    public static boolean showBiome = true;
    public static boolean showTime = true;
    public static boolean showDirection = false;
    public static boolean showPlayerNames = true;
    public static boolean showPlayerHeads = true;
    public static boolean showEntities = true;
    public static int updatePerCycle = 4;
    public static int pruneDelay = 60;
    public static int pruneAmount = 1500;
    public static boolean forceHeightmap = true;
    public static boolean showMap = true;
    public static boolean moveMapForEffects = true;
    public static boolean shaded = true;
    public static int maxDifference = 10;
    public static boolean drawChunkGrid = false;
    public static int scale = 1;
    public static boolean showInChat = true;
    public static boolean inHotBar = false;
    public static String mapItem = "";
    public static String positionItem = "";
    public static String timeItem = "";
    public static boolean showItemConfigInGame = false;
    public static String biomeItem = "";
    public static boolean enableWorldMapKey = false;
    public static Client config;
    private static ForgeConfigSpec spec;

    private static String key(String key) {
        return "mappy.config." + key;
    }

    public static void register(ModLoadingContext context) {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(MappyConfig::reload);
        context.registerConfig(ModConfig.Type.CLIENT, spec);
    }

    public static void reload(ModConfig.ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == spec) {
            MappyConfig.reloadClient();
        }
    }

    private static void reloadClient() {
        offset = (Integer)MappyConfig.config.offset.get();
        drawPosition = (DrawPosition)((Object)MappyConfig.config.drawPosition.get());
        mapSize = (Integer)MappyConfig.config.mapSize.get();
        createDeathWaypoints = (Boolean)MappyConfig.config.createDeathWayPoints.get();
        autoRemoveDeathWaypoints = (Boolean)MappyConfig.config.autoRemoveDeathWaypoint.get();
        autoRemoveRange = (Integer)MappyConfig.config.autoRemoveRange.get();
        printDeathPointInChat = (Boolean)MappyConfig.config.printDeathPointInChat.get();
        showPosition = (Boolean)MappyConfig.config.showPosition.get();
        showFPS = (Boolean)MappyConfig.config.showFPS.get();
        showBiome = (Boolean)MappyConfig.config.showBiome.get();
        showTime = (Boolean)MappyConfig.config.showTime.get();
        showDirection = (Boolean)MappyConfig.config.showDirection.get();
        showPlayerNames = (Boolean)MappyConfig.config.showPlayerNames.get();
        showPlayerHeads = (Boolean)MappyConfig.config.showPlayerHeads.get();
        showEntities = (Boolean)MappyConfig.config.showEntities.get();
        updatePerCycle = (Integer)MappyConfig.config.updatePerCycle.get();
        pruneDelay = (Integer)MappyConfig.config.pruneDelay.get();
        pruneAmount = (Integer)MappyConfig.config.pruneAmount.get();
        forceHeightmap = (Boolean)MappyConfig.config.forceHeightmapUse.get();
        showMap = (Boolean)MappyConfig.config.showMap.get();
        moveMapForEffects = (Boolean)MappyConfig.config.moveMapForEffects.get();
        shaded = (Boolean)MappyConfig.config.shaded.get();
        maxDifference = (Integer)MappyConfig.config.shadeStrength.get();
        drawChunkGrid = (Boolean)MappyConfig.config.drawChunkGrid.get();
        scale = (Integer)MappyConfig.config.scale.get();
        showInChat = (Boolean)MappyConfig.config.showInChat.get();
        showItemConfigInGame = (Boolean)MappyConfig.config.showItemConfigInGame.get();
        inHotBar = (Boolean)MappyConfig.config.inHotBar.get();
        mapItem = (String)MappyConfig.config.mapItem.get();
        positionItem = (String)MappyConfig.config.positionItem.get();
        timeItem = (String)MappyConfig.config.timeItem.get();
        biomeItem = (String)MappyConfig.config.biomeItem.get();
        enableWorldMapKey = (Boolean)MappyConfig.config.enableWorldMapKey.get();
        Mappy.map.onConfigChanged();
    }

    public static ForgeConfigSpec getSpec() {
        return spec;
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        spec = (ForgeConfigSpec)specPair.getRight();
        config = (Client)specPair.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.IntValue offset;
        public final ForgeConfigSpec.EnumValue<DrawPosition> drawPosition;
        public final ForgeConfigSpec.IntValue mapSize;
        public final ForgeConfigSpec.BooleanValue createDeathWayPoints;
        public final ForgeConfigSpec.BooleanValue printDeathPointInChat;
        public final ForgeConfigSpec.BooleanValue autoRemoveDeathWaypoint;
        public final ForgeConfigSpec.IntValue autoRemoveRange;
        public final ForgeConfigSpec.BooleanValue showPosition;
        public final ForgeConfigSpec.BooleanValue showFPS;
        public final ForgeConfigSpec.BooleanValue showBiome;
        public final ForgeConfigSpec.BooleanValue showTime;
        public final ForgeConfigSpec.BooleanValue showDirection;
        public final ForgeConfigSpec.BooleanValue showPlayerNames;
        public final ForgeConfigSpec.BooleanValue showPlayerHeads;
        public final ForgeConfigSpec.BooleanValue showEntities;
        public final ForgeConfigSpec.IntValue updatePerCycle;
        public final ForgeConfigSpec.IntValue pruneDelay;
        public final ForgeConfigSpec.IntValue pruneAmount;
        public final ForgeConfigSpec.BooleanValue forceHeightmapUse;
        public final ForgeConfigSpec.BooleanValue showMap;
        public final ForgeConfigSpec.BooleanValue moveMapForEffects;
        public final ForgeConfigSpec.BooleanValue shaded;
        public final ForgeConfigSpec.IntValue shadeStrength;
        public final ForgeConfigSpec.BooleanValue drawChunkGrid;
        public final ForgeConfigSpec.IntValue scale;
        public final ForgeConfigSpec.BooleanValue showInChat;
        public final ForgeConfigSpec.BooleanValue inHotBar;
        public final ForgeConfigSpec.ConfigValue<String> mapItem;
        public final ForgeConfigSpec.ConfigValue<String> positionItem;
        public final ForgeConfigSpec.ConfigValue<String> timeItem;
        public final ForgeConfigSpec.BooleanValue showItemConfigInGame;
        public final ForgeConfigSpec.ConfigValue<String> biomeItem;
        public final ForgeConfigSpec.BooleanValue enableWorldMapKey;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Mappy settings");
            builder.push("general");
            this.offset = builder.comment("Offset from screen edge").translation(MappyConfig.key("offset")).defineInRange("offset", 4, 0, 50);
            this.drawPosition = builder.comment("Draw position of the map").translation(MappyConfig.key("draw_position")).defineEnum("draw_position", (Enum)DrawPosition.TOP_RIGHT);
            this.mapSize = builder.comment("The map size").translation(MappyConfig.key("map_size")).defineInRange("map_size", 64, 16, 256);
            builder.comment("Death waypoints for when you die.").push("death");
            this.createDeathWayPoints = builder.comment("Create a waypoint when you die").translation(MappyConfig.key("death_waypoint")).define("waypoint", true);
            this.autoRemoveDeathWaypoint = builder.comment("Auto remove the death point when you get close").translation(MappyConfig.key("death_auto_remove")).define("auto_remove", true);
            this.autoRemoveRange = builder.comment("Range for when to remove the death waypoint").translation(MappyConfig.key("death_remove_range")).defineInRange("remove_range", 5, 1, 40);
            this.printDeathPointInChat = builder.comment("Print the death position into your chat.").translation(MappyConfig.key("death_print")).define("print", false);
            builder.pop();
            this.shaded = builder.comment("Show the map shaded").translation(MappyConfig.key("shaded")).define("shaded", true);
            this.shadeStrength = builder.comment("Lower numbers are stronger").translation(MappyConfig.key("shade_strength")).defineInRange("shade_strength", 10, 2, 16);
            this.drawChunkGrid = builder.comment("Show the chunk grid").translation(MappyConfig.key("draw_grid")).define("draw_grid", false);
            this.scale = builder.comment("The scale of the map - WIP").translation("scale").defineInRange("scale", 1, 1, 8);
            this.showInChat = builder.comment("Show map while chat is open").translation(MappyConfig.key("show_in_chat")).define("show_in_chat", true);
            builder.pop().comment("The info to show").push("info");
            this.showPosition = builder.comment("Show the position in the info").translation(MappyConfig.key("show_position")).define("show_position", true);
            this.showFPS = builder.comment("Show fps in the info").translation(MappyConfig.key("show_fps")).define("show_fps", false);
            this.showBiome = builder.comment("Show biome name in info").translation(MappyConfig.key("show_biome")).define("show_biome", true);
            this.showTime = builder.comment("Show in game time in info").translation(MappyConfig.key("show_time")).define("show_time", true);
            this.showDirection = builder.comment("Show direction currently facing in info").translation(MappyConfig.key("show_direction")).define("show_direction", false);
            this.showPlayerNames = builder.comment("Show player names on the map").translation(MappyConfig.key("show_player_names")).define("show_player_names", true);
            this.showPlayerHeads = builder.comment("Show player heads on the map").translation(MappyConfig.key("show_player_heads")).define("show_player_heads", true);
            this.showEntities = builder.comment("Show entities on the map").translation(MappyConfig.key("show_entities")).define("show_entities", true);
            this.moveMapForEffects = builder.comment("Moves map to show effects").translation(MappyConfig.key("move_map_for_effects")).define("move_map_for_effects", true);
            builder.pop().comment("These options are for performance").push("performance");
            this.updatePerCycle = builder.comment("Updated chunks per cycle").translation(MappyConfig.key("update_per_cycle")).defineInRange("update_per_cycle", 10, 1, 100);
            this.pruneDelay = builder.comment("Delay before pruning old not visited chunks").translation(MappyConfig.key("prune_delay")).defineInRange("prune_delay", 60, 20, 600);
            this.pruneAmount = builder.comment("Max amount to purge per prune cycle").translation(MappyConfig.key("prune_amount")).defineInRange("prune_amount", 1500, 100, 6000);
            this.forceHeightmapUse = builder.comment("Forces use of heightmap for height checking, this is more performing but can be less accurate").translation(MappyConfig.key("force_heightmap")).define("force_heightmap", true);
            builder.pop().comment("Items required for showing").push("items");
            this.showItemConfigInGame = builder.comment("Showing this part of the config in game - wip").define("show_item_config_in_game", false);
            this.inHotBar = builder.comment("Does the item need to be in the hotbar?").translation(MappyConfig.key("in_hot_bar")).define("in_hot_bar", false);
            builder.comment("An empty value means an item is not required");
            this.mapItem = builder.comment("The item required to show the map.").translation(MappyConfig.key("map_item")).define("map_item", (Object)"");
            this.positionItem = builder.comment("The item required to show position.").translation(MappyConfig.key("position_item")).define("position_item", (Object)"");
            this.timeItem = builder.comment("The item required to see the time").translation(MappyConfig.key("time_item")).define("time_item", (Object)"");
            this.biomeItem = builder.comment("The item required to see current biome").translation(MappyConfig.key("biome_item")).define("biome_item", (Object)"");
            builder.pop().comment("Some internally used config options").push("hidden");
            this.showMap = builder.comment("Showing the map or not").define("show_map", true);
            builder.pop();
            this.enableWorldMapKey = builder.push("Extra settings").comment("Enable the show world map key, needs restart").translation(MappyConfig.key("enable_world_map_key")).define("enable_world_map_key", false);
        }
    }
}

