/*
 * Decompiled with CFR 0.152.
 */
package com.naxanria.mappy.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public class DataMap {
    private final Map<String, String> dataMap = new HashMap<String, String>();
    private final File dataLocation;
    private boolean createOnMissing = false;

    public DataMap(File dataLocation) {
        this.dataLocation = dataLocation;
    }

    public DataMap(File dataLocation, boolean createOnMissing) {
        this.dataLocation = dataLocation;
        this.createOnMissing = createOnMissing;
    }

    public DataMap load() throws IOException {
        return this.load(false);
    }

    public DataMap load(boolean createFile) throws IOException {
        if (!this.dataLocation.exists()) {
            if (createFile) {
                boolean success = this.dataLocation.createNewFile();
                if (!success) {
                    throw new IOException();
                }
            } else {
                throw new FileNotFoundException(this.dataLocation.getAbsolutePath());
            }
        }
        this.dataMap.clear();
        Stream<String> stream = Files.lines(this.dataLocation.toPath());
        stream.forEach(this::deSerialize);
        return this;
    }

    public DataMap save() throws IOException {
        return this.save(true);
    }

    public DataMap save(boolean createFile) throws IOException {
        if (!this.dataLocation.exists()) {
            if (createFile) {
                boolean success = this.dataLocation.createNewFile();
                if (!success) {
                    throw new IOException();
                }
            } else {
                throw new FileNotFoundException(this.dataLocation.getAbsolutePath());
            }
        }
        ArrayList<String> lines = new ArrayList<String>();
        for (String key : this.dataMap.keySet()) {
            lines.add(this.serialize(key));
        }
        Files.write(this.dataLocation.toPath(), lines, new OpenOption[0]);
        return this;
    }

    private String serialize(String key) {
        String val = this.dataMap.get(key);
        return key + "=" + val;
    }

    private void deSerialize(String line) {
        if (line.isEmpty() || !line.contains("=")) {
            return;
        }
        int p = line.indexOf("=");
        String key = line.substring(0, p);
        String val = line.substring(p + 1);
        if (key.contains(" ")) {
            key = key.replaceAll(" ", "");
        }
        if (val.startsWith(" ")) {
            val = val.length() == 1 ? "" : val.substring(1);
        }
        this.dataMap.put(key, val);
    }

    public String get(String key, String defaultValue) {
        if (!this.createOnMissing) {
            return this.dataMap.getOrDefault(key, defaultValue);
        }
        if (!this.dataMap.containsKey(key)) {
            this.dataMap.put(key, defaultValue);
            return defaultValue;
        }
        return this.dataMap.get(key);
    }

    public int getInt(String key, int defaultValue) {
        Integer i;
        String val = this.get(key, defaultValue + "");
        try {
            i = Integer.valueOf(val);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
        return i;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String val = this.get(key, defaultValue ? "true" : "false");
        return val.equalsIgnoreCase("true");
    }

    public DataMap set(String key, String value) {
        this.dataMap.put(key, value);
        return this;
    }

    public DataMap set(String key, int value) {
        return this.set(key, value + "");
    }

    public DataMap set(String key, boolean value) {
        return this.set(key, value ? "true" : "false");
    }

    public boolean isCreateOnMissing() {
        return this.createOnMissing;
    }

    public DataMap setCreateOnMissing(boolean createOnMissing) {
        this.createOnMissing = createOnMissing;
        return this;
    }

    public int size() {
        return this.dataMap.size();
    }

    public Set<String> keys() {
        return this.dataMap.keySet();
    }

    public File getDataLocation() {
        return this.dataLocation;
    }

    public boolean contains(String key) {
        return this.dataMap.containsKey(key);
    }
}

