/*
 * Decompiled with CFR 0.152.
 */
package com.naxanria.mappy.config;

import com.google.common.collect.ImmutableList;
import com.naxanria.mappy.config.DataMap;
import com.naxanria.mappy.util.MathUtil;
import java.util.function.Consumer;
import java.util.function.Supplier;

public abstract class ConfigEntry<T> {
    public final String name;
    protected DataMap map;
    protected final T defaultValue;
    protected final Consumer<T> setter;
    protected final Supplier<T> getter;

    public ConfigEntry(String name, T defaultValue, Consumer<T> setter, Supplier<T> getter) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.setter = setter;
        this.getter = getter;
    }

    public abstract T getValue();

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public abstract void setValue(T var1);

    public abstract void saveDefault();

    public abstract void save();

    public abstract void load();

    public ConfigEntry<T> setMap(DataMap map) {
        this.map = map;
        return this;
    }

    public static class EnumEntry<T extends Enum<?>>
    extends ConfigEntry<T> {
        private final ImmutableList<T> values;
        private final int defaultIndex;

        public EnumEntry(String name, Class<T> clazz, T defaultValue, Consumer<T> setter, Supplier<T> getter) {
            super(name, defaultValue, setter, getter);
            Object[] enumValues = (Enum[])clazz.getEnumConstants();
            this.values = enumValues != null ? ImmutableList.copyOf((Object[])enumValues) : ImmutableList.of(defaultValue);
            this.defaultIndex = this.values.indexOf(defaultValue);
        }

        @Override
        public T getValue() {
            int index = this.map.getInt(this.name, this.defaultIndex);
            if (index < 0 || index >= this.values.size()) {
                index = this.defaultIndex;
                this.map.set(this.name, this.defaultIndex);
            }
            return (T)((Enum)this.values.get(index));
        }

        @Override
        public void setValue(T value) {
            int index = this.values.indexOf(value);
            this.map.set(this.name, index);
        }

        @Override
        public void saveDefault() {
            this.setValue((T)((Enum)this.defaultValue));
        }

        @Override
        public void save() {
            this.setValue((T)((Enum)this.getter.get()));
        }

        @Override
        public void load() {
            this.setter.accept(this.getValue());
        }
    }

    public static class BooleanEntry
    extends ConfigEntry<Boolean> {
        public BooleanEntry(String name, Boolean defaultValue, Consumer<Boolean> setter, Supplier<Boolean> getter) {
            super(name, defaultValue, setter, getter);
        }

        @Override
        public Boolean getValue() {
            return this.map.getBoolean(this.name, (Boolean)this.defaultValue);
        }

        @Override
        public void setValue(Boolean value) {
            this.map.set(this.name, value);
        }

        @Override
        public void saveDefault() {
            this.map.set(this.name, (Boolean)this.defaultValue);
        }

        @Override
        public void save() {
            this.setValue((Boolean)this.getter.get());
        }

        @Override
        public void load() {
            this.setter.accept(this.getValue());
        }
    }

    public static class IntegerRangeEntry
    extends IntegerEntry {
        protected int min;
        protected int max;

        public IntegerRangeEntry(String name, Integer defaultValue, int max, Consumer<Integer> setter, Supplier<Integer> getter) {
            this(name, defaultValue, 0, max, setter, getter);
        }

        public IntegerRangeEntry(String name, Integer defaultValue, int min, int max, Consumer<Integer> setter, Supplier<Integer> getter) {
            super(name, defaultValue, setter, getter);
            this.min = min;
            this.max = max;
        }

        private int clamped(int val) {
            return MathUtil.clamp(val, this.min, this.max);
        }

        @Override
        public Integer getValue() {
            return this.clamped(super.getValue());
        }

        @Override
        public void setValue(Integer value) {
            super.setValue(this.clamped(value));
        }
    }

    public static class IntegerEntry
    extends ConfigEntry<Integer> {
        public IntegerEntry(String name, Integer defaultValue, Consumer<Integer> setter, Supplier<Integer> getter) {
            super(name, defaultValue, setter, getter);
        }

        @Override
        public Integer getValue() {
            return this.map.getInt(this.name, (Integer)this.defaultValue);
        }

        @Override
        public void setValue(Integer value) {
            this.map.set(this.name, value);
        }

        @Override
        public void saveDefault() {
            this.map.set(this.name, (Integer)this.defaultValue);
        }

        @Override
        public void save() {
            this.map.set(this.name, (Integer)this.getter.get());
        }

        @Override
        public void load() {
            this.setter.accept(this.map.getInt(this.name, (Integer)this.defaultValue));
        }
    }

    public static class StringEntry
    extends ConfigEntry<String> {
        public StringEntry(String name, String defaultValue, Consumer<String> setter, Supplier<String> getter) {
            super(name, defaultValue, setter, getter);
        }

        @Override
        public String getValue() {
            return this.map.get(this.name, (String)this.defaultValue);
        }

        @Override
        public void setValue(String value) {
            this.map.set(this.name, value);
        }

        @Override
        public void saveDefault() {
            this.map.set(this.name, (String)this.defaultValue);
        }

        @Override
        public void save() {
            this.map.set(this.name, (String)this.getter.get());
        }

        @Override
        public void load() {
            this.setter.accept(this.map.get(this.name, (String)this.defaultValue));
        }
    }
}

