/*
 * Decompiled with CFR 0.152.
 */
package com.naxanria.mappy.config;

import com.google.common.base.Preconditions;
import com.naxanria.mappy.config.gui.ConfigGuiEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.I18n;

public class ConfigCategoryNode {
    private String name;
    private String translationKey = null;
    private ConfigCategoryNode parent;
    private Map<String, ConfigCategoryNode> children = new HashMap<String, ConfigCategoryNode>();
    private List<ConfigGuiEntry<?, ?>> entries = new ArrayList();

    private ConfigCategoryNode(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.getFullName(true);
    }

    public String getFullName(boolean skipTOP) {
        if (this.isTop()) {
            return skipTOP ? "" : this.name;
        }
        String full = this.parent != null ? this.parent.getFullName(skipTOP) : "";
        return full.equals("") ? this.name : full + "." + this.name;
    }

    public String getTranslation() {
        return this.translationKey == null ? I18n.func_135052_a((String)this.name, (Object[])new Object[0]) : I18n.func_135052_a((String)this.translationKey, (Object[])new Object[0]);
    }

    public ConfigCategoryNode setTranslationKey(String translationKey) {
        this.translationKey = translationKey;
        return this;
    }

    public ConfigCategoryNode getParent() {
        return this.parent;
    }

    public List<String> getChildren() {
        return new ArrayList<String>(this.children.keySet());
    }

    public ConfigCategoryNode getChild(String name) {
        if (this.children.containsKey(name)) {
            return this.children.get(name);
        }
        throw new IllegalArgumentException("No such child found: " + name);
    }

    public ConfigCategoryNode push(String name) {
        Preconditions.checkArgument((!this.children.containsKey(name) ? 1 : 0) != 0, (Object)("Category " + this.getFullName(true) + " already exists"));
        ConfigCategoryNode node = new ConfigCategoryNode(name);
        this.children.put(name, node);
        node.parent = this;
        return node;
    }

    public ConfigCategoryNode pop() {
        Preconditions.checkArgument((!this.isTop() ? 1 : 0) != 0, (Object)"Can't pop the top category node!");
        return this.parent;
    }

    public ConfigCategoryNode add(ConfigGuiEntry<?, ?> entry) {
        this.entries.add(entry);
        return this;
    }

    public boolean isTop() {
        return this.parent == null;
    }

    public ConfigCategoryNode getTop() {
        return this.isTop() ? this : this.parent.getTop();
    }

    public List<ConfigGuiEntry<?, ?>> getEntries() {
        return this.entries;
    }

    public static ConfigCategoryNode create() {
        return new ConfigCategoryNode("TOP");
    }
}

