/*
 * Decompiled with CFR 0.152.
 */
package com.naxanria.mappy.config;

import com.naxanria.mappy.config.ConfigEntry;
import com.naxanria.mappy.config.DataMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ConfigBase<T extends ConfigBase> {
    private static List<ConfigChangedListener> listeners = new ArrayList<ConfigChangedListener>();
    public final DataMap dataMap;
    private Map<String, ConfigEntry<?>> entryMap = new HashMap();

    public static void registerListener(ConfigChangedListener listener) {
        listeners.add(listener);
    }

    public ConfigBase(File file) {
        this.dataMap = new DataMap(file, true);
        this.init();
        this.load();
        for (String key : this.entryMap.keySet()) {
            ConfigEntry<?> entry = this.entryMap.get(key);
            if (this.dataMap.contains(key)) continue;
            System.out.println("Entry for " + entry.name + " not found, going to default value " + entry.defaultValue);
            entry.saveDefault();
        }
        this.save();
        this.onConfigChanged();
    }

    protected abstract void init();

    public T addEntry(ConfigEntry entry) {
        entry.setMap(this.dataMap);
        this.entryMap.put(entry.name, entry);
        return (T)this;
    }

    public void load() {
        try {
            this.dataMap.load();
            for (String name : this.entryMap.keySet()) {
                ConfigEntry<?> entry = this.entryMap.get(name);
                entry.load();
            }
            this.onConfigChanged();
        }
        catch (IOException e) {
            System.err.println("Could not load the config!");
            e.printStackTrace();
        }
    }

    public void save() {
        try {
            for (String name : this.entryMap.keySet()) {
                ConfigEntry<?> entry = this.entryMap.get(name);
                entry.save();
            }
            this.dataMap.save();
        }
        catch (IOException e) {
            System.err.println("Could not save the config!");
            e.printStackTrace();
        }
    }

    public void onConfigChanged() {
        for (ConfigChangedListener listener : listeners) {
            listener.onConfigChanged(this);
        }
    }

    public ConfigEntry<?> getEntry(String key) {
        return this.entryMap.getOrDefault(key, null);
    }

    public ConfigEntry.IntegerEntry getIntEntry(String key) {
        ConfigEntry<?> entry = this.getEntry(key);
        if (entry != null && entry instanceof ConfigEntry.IntegerEntry) {
            return (ConfigEntry.IntegerEntry)entry;
        }
        return null;
    }

    public ConfigEntry.BooleanEntry getBooleanEntry(String key) {
        ConfigEntry<?> entry = this.getEntry(key);
        if (entry != null && entry instanceof ConfigEntry.BooleanEntry) {
            return (ConfigEntry.BooleanEntry)entry;
        }
        return null;
    }

    public ConfigEntry.StringEntry getStringEntry(String key) {
        ConfigEntry<?> entry = this.getEntry(key);
        if (entry != null && entry instanceof ConfigEntry.StringEntry) {
            return (ConfigEntry.StringEntry)entry;
        }
        return null;
    }

    public int getInt(String key) {
        ConfigEntry.IntegerEntry entry = this.getIntEntry(key);
        if (entry != null) {
            return entry.getValue();
        }
        return 1;
    }

    public T setInt(String key, int value) {
        ConfigEntry.IntegerEntry entry = this.getIntEntry(key);
        if (entry != null) {
            entry.setValue(value);
        }
        return (T)this;
    }

    public boolean getBoolean(String key) {
        ConfigEntry.BooleanEntry entry = this.getBooleanEntry(key);
        if (entry != null) {
            return entry.getValue();
        }
        return false;
    }

    public T setBoolean(String key, boolean value) {
        ConfigEntry.BooleanEntry entry = this.getBooleanEntry(key);
        if (entry != null) {
            entry.setValue(value);
        }
        return (T)this;
    }

    public String getString(String key) {
        ConfigEntry.StringEntry entry = this.getStringEntry(key);
        if (entry != null) {
            return entry.getValue();
        }
        return "";
    }

    public T setString(String key, String value) {
        ConfigEntry.StringEntry entry = this.getStringEntry(key);
        if (entry != null) {
            entry.setValue(value);
        }
        return (T)this;
    }

    public static interface ConfigChangedListener {
        public void onConfigChanged(ConfigBase<?> var1);
    }
}

