/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.minions.IMinion;
import de.teamlapen.vampirism.api.entity.minions.IMinionLord;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class MinionHelper {
    public static boolean isLordPlayer(@Nullable IMinion m) {
        return m != null && m.getLord() instanceof IFactionPlayer;
    }

    public static boolean isLordSafe(@Nonnull IMinion m, @Nullable Entity e) {
        IMinionLord l = m.getLord();
        return l != null && l.getRepresentingEntity().equals((Object)e);
    }

    public static boolean isLordSafe(@Nullable EntityLivingBase e, @Nonnull IMinionLord l) {
        if (e == null) {
            return false;
        }
        if (e instanceof IMinion) {
            return l.equals(((IMinion)e).getLord());
        }
        return false;
    }

    public static boolean isLordSafe(@Nullable IMinion m, @Nullable IMinionLord l) {
        if (m == null || l == null) {
            return false;
        }
        return l.equals(m.getLord());
    }

    public static void sendMessageToLord(IMinion m, String ... message) {
        if (message == null || message.length < 1) {
            return;
        }
        IMinionLord l = m.getLord();
        if (l != null && l.getRepresentingEntity() instanceof EntityPlayer) {
            EntityCreature entity = MinionHelper.entity(m);
            Object c1 = entity.func_145818_k_() ? new TextComponentString(entity.func_95999_t()) : new TextComponentTranslation("text.vampirism.minion", new Object[0]);
            c1.func_150258_a(": ");
            c1.func_150256_b().func_150238_a(TextFormatting.GREEN);
            Object c2 = message[0].startsWith("\\") ? new TextComponentString(message[0].replace("\\", "")) : new TextComponentTranslation(message[0], new Object[0]);
            for (int i = 1; i < message.length; ++i) {
                if (message[i].startsWith("\\")) {
                    c2.func_150257_a((ITextComponent)new TextComponentString(message[i].replace("\\", "")));
                    continue;
                }
                c2.func_150257_a((ITextComponent)new TextComponentTranslation(message[i], new Object[0]));
            }
            c1.func_150257_a((ITextComponent)c2);
            c2.func_150256_b().func_150238_a(TextFormatting.WHITE);
            l.getRepresentingEntity().func_145747_a((ITextComponent)c1);
        }
    }

    public static EntityCreature entity(@Nonnull IMinion minion) {
        try {
            return (EntityCreature)minion;
        }
        catch (ClassCastException e) {
            VampirismMod.log.e("Minion", "All classes that implement IMinion have to extend EntityCreature. %s does not. This is a implementation fault.", minion.getClass());
            throw e;
        }
    }
}

