/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.tileentity;

import de.teamlapen.lib.lib.util.FluidTankWithListener;
import de.teamlapen.vampirism.api.general.BloodConversionRegistry;
import de.teamlapen.vampirism.core.ModFluids;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileSieve
extends TileEntity
implements ITickable,
FluidTankWithListener.IFluidTankListener {
    private FluidTank tank = new FilteringFluidTank(2000).setListener(this);
    private int cooldownPull = 0;
    private int cooldownProcess = 0;
    private boolean active;

    public TileSieve() {
        this.tank.setCanDrain(false);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if ((facing == null || facing != EnumFacing.DOWN) && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tank;
        }
        return (T)super.getCapability(capability, facing);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("active", this.isActive());
        return nbt;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return (facing == null || facing != EnumFacing.DOWN) && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public boolean isActive() {
        return this.active;
    }

    private void setActive(boolean active) {
        if (this.active != active) {
            this.active = active;
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        } else {
            this.active = active;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        boolean old = this.active;
        this.active = pkt.func_148857_g().func_74767_n("active");
        if (this.active != old) {
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        }
    }

    @Override
    public void onTankContentChanged() {
        this.setActive(true);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.tank.readFromNBT(tag);
        this.cooldownProcess = tag.func_74762_e("cooldown_process");
        this.cooldownPull = tag.func_74762_e("cooldown_pull");
    }

    public void func_73660_a() {
        IFluidHandler handler;
        if (--this.cooldownProcess < 0) {
            this.cooldownProcess = 15;
            if (this.tank.getFluidAmount() > 0) {
                handler = FluidUtil.getFluidHandler((World)this.func_145831_w(), (BlockPos)this.field_174879_c.func_177977_b(), (EnumFacing)EnumFacing.UP);
                if (handler != null) {
                    this.tank.setCanDrain(true);
                    FluidStack transferred = FluidUtil.tryFluidTransfer((IFluidHandler)handler, (IFluidHandler)this.tank, (int)200, (boolean)true);
                    this.tank.setCanDrain(false);
                    if (transferred != null && transferred.amount > 0) {
                        this.cooldownProcess = 30;
                        this.setActive(true);
                    }
                }
            } else if (this.active) {
                this.setActive(false);
            }
        }
        if (--this.cooldownPull < 0) {
            this.cooldownPull = 10;
            handler = FluidUtil.getFluidHandler((World)this.func_145831_w(), (BlockPos)this.field_174879_c.func_177984_a(), (EnumFacing)EnumFacing.DOWN);
            if (handler != null) {
                FluidStack fluidStack = FluidUtil.tryFluidTransfer((IFluidHandler)this.tank, (IFluidHandler)handler, (int)200, (boolean)true);
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        this.tank.writeToNBT(tag);
        this.cooldownProcess = tag.func_74762_e("cooldown_process");
        this.cooldownPull = tag.func_74762_e("cooldown_pull");
        return tag;
    }

    private class FilteringFluidTank
    extends FluidTankWithListener {
        private FilteringFluidTank(int capacity) {
            super(capacity);
        }

        public int fillInternal(FluidStack resource, boolean doFill) {
            float factor = BloodConversionRegistry.getFluidBloodConversionFactor(resource.getFluid().getName());
            if (factor == 0.0f) {
                return 0;
            }
            FluidStack converted = new FluidStack(ModFluids.blood, (int)(factor * (float)resource.amount));
            int filled = super.fillInternal(converted, doFill);
            if (doFill) {
                TileSieve.this.cooldownPull = 10;
            }
            return (int)((float)filled / factor);
        }
    }
}

