/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.tileentity;

import de.teamlapen.lib.VampLib;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.player.vampire.VampireLevelingConf;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.TileFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileAltarInspiration
extends TileFluidHandler
implements ITickable {
    public static final int CAPACITY = 10000;
    private final int RITUAL_TIME = 60;
    private int ritualTicksLeft = 0;
    private EntityPlayer ritualPlayer;

    public TileAltarInspiration() {
        this.tank = new InternalTank(10000);
    }

    public FluidTankInfo getTankInfo() {
        return this.tank.getInfo();
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, this.func_189517_E_());
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        FluidStack old = this.tank.getFluid();
        this.func_145839_a(pkt.func_148857_g());
        if (old != null && !old.isFluidStackIdentical(this.tank.getFluid()) || old == null && this.tank.getFluid() != null) {
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        }
    }

    public void startRitual(EntityPlayer p) {
        if (this.ritualTicksLeft > 0) {
            return;
        }
        VampirePlayer player = VampirePlayer.get(p);
        int targetLevel = player.getLevel() + 1;
        VampireLevelingConf levelingConf = VampireLevelingConf.getInstance();
        if (!levelingConf.isLevelValidForAltarInspiration(targetLevel)) {
            if (p.field_70170_p.field_72995_K) {
                p.func_145747_a((ITextComponent)new TextComponentTranslation("text.vampirism.ritual_level_wrong", new Object[0]));
            }
            return;
        }
        int neededBlood = levelingConf.getRequiredBloodForAltarInspiration(targetLevel) * 100;
        if (this.tank.getFluidAmount() + 99 < neededBlood) {
            if (p.field_70170_p.field_72995_K) {
                p.func_145747_a((ITextComponent)new TextComponentTranslation("text.vampirism.not_enough_blood", new Object[0]));
            }
            return;
        }
        if (!p.field_70170_p.field_72995_K) {
            VampLib.proxy.getParticleHandler().spawnParticles(p.field_70170_p, ModParticles.FLYING_BLOOD_ENTITY, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 40, (double)0.1f, p.func_70681_au(), player.getRepresentingPlayer(), false);
        } else {
            ((InternalTank)this.tank).doDrain(neededBlood, true);
            IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
        this.ritualPlayer = p;
        this.ritualTicksLeft = 60;
    }

    public void func_73660_a() {
        if (this.ritualTicksLeft == 0) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            switch (this.ritualTicksLeft) {
                case 5: {
                    this.field_145850_b.func_72942_c((Entity)new EntityLightningBolt(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), true));
                    this.ritualPlayer.func_70606_j(this.ritualPlayer.func_110138_aP());
                    VampirePlayer.get(this.ritualPlayer).drinkBlood(100, 0.0f);
                    break;
                }
                case 1: {
                    VampirePlayer player = VampirePlayer.get(this.ritualPlayer);
                    int targetLevel = player.getLevel() + 1;
                    VampireLevelingConf levelingConf = VampireLevelingConf.getInstance();
                    int blood = levelingConf.getRequiredBloodForAltarInspiration(targetLevel) * 100;
                    ((InternalTank)this.tank).doDrain(blood, true);
                    this.ritualPlayer.func_70690_d(new PotionEffect(MobEffects.field_76428_l, targetLevel * 10 * 20));
                    FactionPlayerHandler.get(this.ritualPlayer).setFactionLevel(VReference.VAMPIRE_FACTION, targetLevel);
                    VampirePlayer.get(this.ritualPlayer).drinkBlood(Integer.MAX_VALUE, 0.0f, false);
                    this.func_70296_d();
                    IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
                    this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
                    break;
                }
            }
        }
        --this.ritualTicksLeft;
    }

    private class InternalTank
    extends FluidTank {
        public InternalTank(int capacity) {
            super(capacity);
            this.setCanDrain(false);
        }

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid != null && this.canFill() && ModFluids.blood.equals(fluid.getFluid());
        }

        public FluidStack doDrain(int maxDrain, boolean doDrain) {
            this.setCanDrain(true);
            FluidStack s = super.drain(maxDrain, doDrain);
            this.setCanDrain(false);
            return s;
        }
    }
}

