/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.tests;

import com.google.common.base.Stopwatch;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.blocks.BlockCastleBlock;
import de.teamlapen.vampirism.blocks.BlockWeaponTable;
import de.teamlapen.vampirism.core.ModBiomes;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEnchantments;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModPotions;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.fluids.BloodHelper;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class Tests {
    public static void runTests(World world, EntityPlayer player) {
        Tests.sendMsg(player, "Starting tests");
        Tests.log("Clearing area", new Object[0]);
        Tests.clearArea(world);
        boolean wasCreative = player.func_184812_l_();
        player.func_71033_a(GameType.SURVIVAL);
        player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 40, 100));
        player.func_184595_k(0.0, 5.0, 0.0);
        TestInfo info = new TestInfo(world, player, new BlockPos(-20, 2, -20), "BloodFluidHandler");
        Tests.runTest(Tests::bloodFluidHandler, info);
        Tests.runTest(Tests::blockWeaponTableFluids, info.next("BlockWeaponTableFluids"));
        Tests.runLightTest(Tests::checkObjectHolders, "Object holders", player);
        Tests.log("Finished tests -> teleporting player", new Object[0]);
        player.func_184595_k(0.0, 5.0, 0.0);
        if (wasCreative) {
            player.func_71033_a(GameType.CREATIVE);
        }
        Tests.sendMsg(player, "Finished tests");
    }

    private static void runTest(Tester tester, TestInfo info) {
        boolean result;
        try {
            result = tester.run(info);
        }
        catch (Throwable t) {
            Tests.log(info.name + " failed with exception %s", t);
            result = false;
        }
        Tests.sendMsg(info.player, info.name + " test " + (result ? "\u00a72was successful\u00a7r" : "\u00a74failed\u00a7r"));
    }

    private static void runLightTest(LightTester tester, String name, @Nullable EntityPlayer player) {
        boolean result;
        try {
            result = tester.run();
        }
        catch (Throwable t) {
            Tests.log(name + " failed with exception %s", t);
            result = false;
        }
        if (player != null) {
            Tests.sendMsg(player, name + " test " + (result ? "\u00a72was successful\u00a7r" : "\u00a74failed\u00a7r"));
        } else {
            Tests.log(name + "test " + (result ? "was successful" : "failed"), new Object[0]);
        }
    }

    public static void runBackgroundTests() {
        Tests.log("Running background tests", new Object[0]);
        Stopwatch w = Stopwatch.createStarted();
        Tests.runLightTest(Tests::checkObjectHolders, "Object holders", null);
        Tests.log("Finished background tests after %s ms", w.stop().elapsed(TimeUnit.MILLISECONDS));
    }

    private static boolean checkObjectHolders() {
        boolean failed = !Tests.checkObjectHolders(ModBiomes.class);
        failed |= !Tests.checkObjectHolders(ModBlocks.class);
        failed |= !Tests.checkObjectHolders(ModEnchantments.class);
        failed |= !Tests.checkObjectHolders(ModEntities.class);
        failed |= !Tests.checkObjectHolders(ModFluids.class);
        failed |= !Tests.checkObjectHolders(ModItems.class);
        failed |= !Tests.checkObjectHolders(ModPotions.class);
        return !(failed |= !Tests.checkObjectHolders(ModSounds.class));
    }

    private static boolean checkObjectHolders(@Nonnull Class clazz) {
        boolean failed = false;
        for (Field f : clazz.getFields()) {
            boolean isMatch;
            int mods = f.getModifiers();
            boolean bl = isMatch = Modifier.isPublic(mods) && Modifier.isStatic(mods) && Modifier.isFinal(mods);
            if (!isMatch) continue;
            try {
                if (f.get(null) != null) continue;
                Tests.log("Field %s in class %s is null", f.getName(), clazz.getName());
                failed = true;
            }
            catch (IllegalAccessException e) {
                VampirismMod.log.e("TEST", e, "Failed to check fields of class %s", clazz.getName());
                return false;
            }
        }
        return !failed;
    }

    private static boolean bloodFluidHandler(TestInfo info) {
        info.world.func_175656_a(info.pos, ModBlocks.blood_container.func_176223_P());
        TileEntity t = info.world.func_175625_s(info.pos);
        IFluidHandler handler = (IFluidHandler)t.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.func_176741_a((Random)info.world.field_73012_v));
        handler.fill(new FluidStack(ModFluids.blood, 10000000), true);
        int blood = BloodHelper.getBlood(handler);
        assert (blood > 0) : "Could not fill blood container";
        ItemStack bloodBottle1 = new ItemStack((Item)ModItems.blood_bottle);
        ItemStack bloodBottle2 = new ItemStack((Item)ModItems.blood_bottle);
        FluidActionResult result1 = FluidUtil.tryFillContainer((ItemStack)bloodBottle1, (IFluidHandler)handler, (int)Integer.MAX_VALUE, null, (boolean)true);
        assert (result1.isSuccess()) : "Transaction 1 failed";
        bloodBottle1 = result1.getResult();
        FluidActionResult result2 = FluidUtil.tryFillContainer((ItemStack)bloodBottle2, (IFluidHandler)handler, (int)Integer.MAX_VALUE, null, (boolean)true);
        assert (result2.isSuccess()) : "Transaction 2 failed";
        bloodBottle2 = result2.getResult();
        assert (BloodHelper.getBlood(handler) < blood) : "Failed to drain from container into bottles";
        FluidActionResult result3 = FluidUtil.tryEmptyContainer((ItemStack)bloodBottle1, (IFluidHandler)handler, (int)Integer.MAX_VALUE, null, (boolean)true);
        assert (result3.isSuccess()) : "Transaction 3 failed";
        bloodBottle1 = result3.getResult();
        FluidActionResult result4 = FluidUtil.tryEmptyContainer((ItemStack)bloodBottle2, (IFluidHandler)handler, (int)Integer.MAX_VALUE, null, (boolean)true);
        assert (result4.isSuccess()) : "Transaction 4 failed";
        bloodBottle2 = result4.getResult();
        Tests.log("%d %d", BloodHelper.getBlood(handler), blood);
        assert (BloodHelper.getBlood(handler) == blood) : "Lost blood somewhere";
        return true;
    }

    private static boolean blockWeaponTableFluids(TestInfo info) {
        info.world.func_175656_a(info.pos, ModBlocks.weapon_table.func_176223_P());
        info.player.func_184611_a(info.player.func_184600_cs(), new ItemStack(Items.field_151129_at));
        IBlockState block = info.world.func_180495_p(info.pos);
        block.func_177230_c().func_180639_a(info.world, info.pos, block, info.player, info.player.func_184600_cs(), EnumFacing.func_176741_a((Random)info.world.field_73012_v), 0.0f, 0.0f, 0.0f);
        block = info.world.func_180495_p(info.pos);
        assert (info.player.func_184586_b(info.player.func_184600_cs()).func_77973_b().equals(Items.field_151133_ar)) : "Incorrect Fluid Container Handling";
        Tests.log("Block lava level: %s", block.func_177229_b((IProperty)BlockWeaponTable.LAVA));
        assert ((Integer)block.func_177229_b((IProperty)BlockWeaponTable.LAVA) * 200 == 1000) : "Incorrect Fluid Transaction";
        return true;
    }

    private static void log(String msg, Object ... format) {
        VampirismMod.log.w("TEST", msg, format);
    }

    private static void sendMsg(EntityPlayer player, String msg) {
        player.func_145747_a((ITextComponent)new TextComponentString("\u00a71[V-TEST]\u00a7r " + msg));
    }

    private static void clearArea(World world) {
        for (int x = -21; x < 22; ++x) {
            for (int y = 1; y < 22; ++y) {
                for (int z = -21; z < 22; ++z) {
                    IBlockState s = y == 1 || x == -21 || x == 21 || z == -21 || z == 21 || y == 21 ? ModBlocks.castle_block.func_176223_P().func_177226_a(BlockCastleBlock.VARIANT, (Comparable)((Object)BlockCastleBlock.EnumType.DARK_STONE)) : Blocks.field_150350_a.func_176223_P();
                    world.func_175656_a(new BlockPos(x, y, z), s);
                }
            }
        }
    }

    private static class TestInfo {
        final World world;
        final EntityPlayer player;
        BlockPos pos;
        String name;

        private TestInfo(World world, EntityPlayer player, BlockPos pos, String name) {
            this.world = world;
            this.player = player;
            this.pos = pos;
            this.name = name;
        }

        private TestInfo next(String name) {
            int x = this.pos.func_177958_n();
            int z = this.pos.func_177952_p();
            if ((x += 5) > 20) {
                x = -20;
                if ((z += 5) > 20) {
                    throw new IllegalStateException("Not enough room -> Too many tests");
                }
            }
            this.pos = new BlockPos(x, this.pos.func_177956_o(), z);
            this.name = name;
            return this;
        }
    }

    @FunctionalInterface
    private static interface LightTester {
        public Boolean run() throws Throwable;
    }

    @FunctionalInterface
    private static interface Tester {
        public Boolean run(TestInfo var1) throws Throwable;
    }
}

