/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.entity.vampire.IVampireMob;
import de.teamlapen.vampirism.api.items.IEntityCrossbowArrow;
import de.teamlapen.vampirism.api.items.IVampirismCrossbowArrow;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.entity.EntityCrossbowArrow;
import de.teamlapen.vampirism.items.VampirismItem;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCrossbowArrow
extends VampirismItem
implements IVampirismCrossbowArrow<EntityCrossbowArrow> {
    private static final String regName = "crossbow_arrow";

    @Nonnull
    public static EnumArrowType getType(@Nonnull ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("type")) {
            String type = stack.func_77978_p().func_74779_i("type");
            for (EnumArrowType enumType : EnumArrowType.values()) {
                if (!enumType.name.equals(type)) continue;
                return enumType;
            }
        }
        return EnumArrowType.NORMAL;
    }

    @Nonnull
    public static ItemStack setType(@Nonnull ItemStack stack, EnumArrowType type) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        nbt.func_74778_a("type", type.name);
        stack.func_77982_d(nbt);
        return stack;
    }

    public ItemCrossbowArrow() {
        super(regName);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        EnumArrowType type = ItemCrossbowArrow.getType(stack);
        if (type != EnumArrowType.NORMAL) {
            tooltip.add(UtilLib.translate("item.vampirism.crossbow_arrow." + type.name + ".tooltip"));
        }
    }

    @Override
    public EntityCrossbowArrow createEntity(ItemStack stack, World world, EntityPlayer player, double heightOffset, double centerOffset, boolean rightHand) {
        EntityCrossbowArrow entity = EntityCrossbowArrow.createWithShooter(world, (EntityLivingBase)player, heightOffset, centerOffset, rightHand, stack);
        EnumArrowType type = ItemCrossbowArrow.getType(stack);
        entity.func_70239_b(type.baseDamage);
        if (type == EnumArrowType.SPITFIRE) {
            entity.func_70015_d(100);
        }
        return entity;
    }

    public String func_77653_i(ItemStack stack) {
        EnumArrowType type = ItemCrossbowArrow.getType(stack);
        if (type != EnumArrowType.NORMAL) {
            return UtilLib.translate("item.vampirism.crossbow_arrow." + type.name + ".name");
        }
        return super.func_77653_i(stack);
    }

    public ItemStack getStack(EnumArrowType type) {
        return ItemCrossbowArrow.setType(new ItemStack((Item)this), type);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (EnumArrowType type : EnumArrowType.values()) {
                items.add((Object)ItemCrossbowArrow.setType(new ItemStack((Item)this), type));
            }
        }
    }

    @Override
    public boolean isBurning(ItemStack arrow) {
        EnumArrowType type = ItemCrossbowArrow.getType(arrow);
        return type == EnumArrowType.SPITFIRE;
    }

    @Override
    public boolean isCanBeInfinite(ItemStack stack) {
        EnumArrowType type = ItemCrossbowArrow.getType(stack);
        return type != EnumArrowType.VAMPIRE_KILLER && type != EnumArrowType.SPITFIRE;
    }

    @Override
    public void onHitBlock(ItemStack arrow, BlockPos blockPos, IEntityCrossbowArrow arrowEntity, Entity shootingEntity) {
        EntityCrossbowArrow entity = (EntityCrossbowArrow)arrowEntity;
        EnumArrowType type = ItemCrossbowArrow.getType(arrow);
        if (type == EnumArrowType.SPITFIRE) {
            for (int dx = -1; dx < 2; ++dx) {
                for (int dy = -2; dy < 2; ++dy) {
                    for (int dz = -1; dz < 2; ++dz) {
                        BlockPos pos = blockPos.func_177982_a(dx, dy, dz);
                        if (entity.func_130014_f_().func_180495_p(pos).func_185904_a() != Material.field_151579_a && !entity.func_130014_f_().func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)entity.func_130014_f_(), pos) || !entity.func_130014_f_().func_180495_p(pos.func_177977_b()).func_185913_b() || entity.getRNG().nextInt(4) == 0) continue;
                        entity.func_130014_f_().func_175656_a(pos, ModBlocks.alchemical_fire.func_176223_P());
                    }
                }
            }
        }
    }

    @Override
    public void onHitEntity(ItemStack arrow, EntityLivingBase entity, IEntityCrossbowArrow arrowEntity, Entity shootingEntity) {
        float max;
        EnumArrowType type = ItemCrossbowArrow.getType(arrow);
        if (type == EnumArrowType.VAMPIRE_KILLER && entity instanceof IVampireMob && (max = entity.func_110138_aP()) < (float)Balance.general.ARROW_VAMPIRE_KILLER_MAX_HEALTH) {
            entity.func_70097_a(DamageSource.func_76353_a((EntityArrow)((EntityArrow)arrowEntity), (Entity)shootingEntity), max);
        }
    }

    public static enum EnumArrowType {
        NORMAL("normal", 2.0, 0xFFFFFF),
        VAMPIRE_KILLER("vampire_killer", 0.5, 7995507),
        SPITFIRE("spitfire", 0.5, 0xFF2211);

        public final int color;
        final String name;
        final double baseDamage;

        private EnumArrowType(String name, double baseDamage, int color) {
            this.name = name;
            this.baseDamage = baseDamage;
            this.color = color;
        }
    }
}

