/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.fluids;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.config.Configs;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModItems;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class BloodHelper {
    public static ItemStack getBloodContainerInHotbar(InventoryPlayer inventory) {
        int hotbarSize = InventoryPlayer.func_70451_h();
        for (int i = 0; i < hotbarSize; ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_190926_b() || !BloodHelper.canStoreBlood(stack)) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static boolean canStoreBlood(@Nonnull ItemStack stack) {
        IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)stack);
        return handler != null && handler.fill(new FluidStack(ModFluids.blood, 1000), false) > 0;
    }

    public static ItemStack getGlassBottleInHotbar(InventoryPlayer inventory) {
        int hotbarSize = InventoryPlayer.func_70451_h();
        for (int i = 0; i < hotbarSize; ++i) {
            ItemStack itemStack = inventory.func_70301_a(i);
            if (itemStack.func_190926_b() || !itemStack.func_77973_b().equals(Items.field_151069_bo)) continue;
            return itemStack;
        }
        return ItemStack.field_190927_a;
    }

    public static int getBlood(@Nonnull ItemStack stack) {
        FluidStack stack1 = FluidUtil.getFluidContained((ItemStack)stack);
        return stack1 == null ? 0 : stack1.amount;
    }

    public static int getBlood(@Nonnull IFluidHandler cap) {
        FluidStack stack = cap.drain(new FluidStack(ModFluids.blood, Integer.MAX_VALUE), false);
        return stack == null ? 0 : stack.amount;
    }

    public static int drain(@Nonnull ItemStack stack, int amount, boolean doDrain, boolean exact) {
        if (exact && doDrain && BloodHelper.drain(stack, amount, false, false) != amount) {
            return 0;
        }
        IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)stack);
        if (handler != null) {
            FluidStack fluidStack = handler.drain(amount, doDrain);
            return fluidStack == null ? 0 : fluidStack.amount;
        }
        return 0;
    }

    public static int fill(@Nonnull ItemStack stack, int amount, boolean doFill) {
        IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)stack);
        if (handler != null) {
            return handler.fill(new FluidStack(ModFluids.blood, amount), doFill);
        }
        return 0;
    }

    public static int fillBloodIntoInventory(EntityPlayer player, int amt) {
        int filled;
        if (amt <= 0) {
            return 0;
        }
        ItemStack stack = BloodHelper.getBloodContainerInHotbar(player.field_71071_by);
        if (!stack.func_190926_b() && (filled = BloodHelper.fill(stack, amt, true)) > 0) {
            if (filled < amt) {
                return BloodHelper.fillBloodIntoInventory(player, amt - filled);
            }
            return 0;
        }
        ItemStack glas = BloodHelper.getGlassBottleInHotbar(player.field_71071_by);
        if (!glas.func_190926_b() && Configs.autoConvertGlasBottles) {
            ItemStack bloodBottle = new ItemStack((Item)ModItems.blood_bottle, 1, 0);
            int filled2 = BloodHelper.fill(bloodBottle, amt, true);
            if (filled2 == 0) {
                VampirismMod.log.w("BloodHelper", "Failed to fill blood bottle with blood", new Object[0]);
            }
            glas.func_190918_g(1);
            if (glas.func_190926_b()) {
                player.field_71071_by.func_184437_d(glas);
            }
            if (!player.field_71071_by.func_70441_a(bloodBottle)) {
                player.func_71019_a(bloodBottle, false);
            }
            return BloodHelper.fillBloodIntoInventory(player, amt - filled2);
        }
        return amt;
    }
}

