/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.vampire;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.difficulty.Difficulty;
import de.teamlapen.vampirism.api.entity.minions.IMinion;
import de.teamlapen.vampirism.api.entity.minions.ISaveableMinionHandler;
import de.teamlapen.vampirism.api.entity.vampire.IVampireBaron;
import de.teamlapen.vampirism.api.entity.vampire.IVampireMinion;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.ai.EntityAIAttackRangedDarkBlood;
import de.teamlapen.vampirism.entity.ai.EntityAIWatchClosestVisible;
import de.teamlapen.vampirism.entity.ai.VampireAIFleeGarlic;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.minions.SaveableMinionHandler;
import de.teamlapen.vampirism.entity.minions.vampire.EntityVampireMinionSaveable;
import de.teamlapen.vampirism.entity.vampire.EntityVampireBase;
import de.teamlapen.vampirism.items.ItemHunterCoat;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.world.loot.LootHandler;
import java.util.Collections;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityVampireBaron
extends EntityVampireBase
implements IVampireBaron {
    private static final DataParameter<Integer> LEVEL = EntityDataManager.func_187226_a(EntityVampireBaron.class, (DataSerializer)DataSerializers.field_187192_b);
    private final SaveableMinionHandler<IVampireMinion.Saveable> minionHandler = new SaveableMinionHandler(this);
    public static final int MAX_LEVEL = 5;
    private int attackDecisionCounter = 0;
    private boolean rangedAttack = false;
    private boolean prevAttacking = false;

    public EntityVampireBaron(World world) {
        super(world, true);
        this.func_70105_a(0.6f, 1.95f);
        this.garlicResist = EnumStrength.MEDIUM;
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        boolean flag = super.func_70652_k(entity);
        if (flag && entity instanceof EntityLivingBase) {
            float tm = 1.0f;
            int mr = 1;
            if (entity instanceof EntityPlayer) {
                float pld = (float)(this.getLevel() + 1) - (float)VampirePlayer.get((EntityPlayer)entity).getLevel() / 3.0f;
                tm = pld + 1.0f;
                int n = pld < 1.5f ? 1 : (mr = pld < 3.0f ? 2 : 3);
                if (ItemHunterCoat.isFullyEquipped((EntityPlayer)entity)) {
                    tm *= 0.5f;
                }
            }
            if (entity instanceof EntityVampireBaron) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76420_g, 40, 5));
            }
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76437_t, (int)(200.0f * tm), this.field_70146_Z.nextInt(mr)));
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76421_d, (int)(100.0f * tm), this.field_70146_Z.nextInt(mr)));
            this.attackDecisionCounter = 0;
        }
        return flag;
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float amount) {
        ++this.attackDecisionCounter;
        return super.func_70097_a(damageSource, amount);
    }

    public boolean func_94059_bO() {
        return true;
    }

    @Override
    public boolean func_70601_bi() {
        int i = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
        if (i < 60) {
            return false;
        }
        BlockPos blockpos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        return ((Object)((Object)ModBlocks.cursed_earth)).equals(this.field_70170_p.func_180495_p(blockpos.func_177977_b()).func_177230_c()) && super.func_70601_bi();
    }

    @Override
    public long getLastComebackCall() {
        return 0L;
    }

    @Override
    public int getLevel() {
        return (Integer)this.func_184212_Q().func_187225_a(LEVEL);
    }

    @Override
    public void setLevel(int level) {
        if (level >= 0) {
            this.func_184212_Q().func_187227_b(LEVEL, (Object)level);
            this.updateEntityAttributes(false);
            float hp = this.func_110143_aJ() / this.func_110138_aP();
            this.func_70606_j(this.func_110138_aP() * hp);
            VampirismMod.log.t("Lev %s", level);
        }
    }

    public int func_82145_z() {
        return 500;
    }

    @Override
    public int getMaxLevel() {
        return 5;
    }

    @Override
    public int getMaxMinionCount() {
        return 15;
    }

    @Override
    public EntityLivingBase getMinionTarget() {
        return this.func_70638_az();
    }

    @Nonnull
    public String func_70005_c_() {
        return super.func_70005_c_() + " " + UtilLib.translate("text.vampirism.entity_level") + " " + (this.getLevel() + 1);
    }

    @Override
    public EntityLivingBase getRepresentingEntity() {
        return this;
    }

    @Override
    public ISaveableMinionHandler<IVampireMinion.Saveable> getSaveableMinionHandler() {
        return this.minionHandler;
    }

    @Override
    public double getTheDistanceSquared(Entity e) {
        return this.func_70068_e(e);
    }

    @Override
    public UUID getThePersistentID() {
        return this.getPersistentID();
    }

    @Override
    public boolean isTheEntityAlive() {
        return this.func_70089_S();
    }

    public void func_70074_a(EntityLivingBase entity) {
        super.func_70074_a(entity);
        if (entity instanceof EntityVampireBaron) {
            this.func_70606_j(this.func_110138_aP());
        }
    }

    @Override
    public void func_70636_d() {
        if (!this.prevAttacking && this.func_70638_az() != null) {
            this.prevAttacking = true;
            this.updateEntityAttributes(true);
        }
        if (this.prevAttacking && this.func_70638_az() == null) {
            this.prevAttacking = false;
            this.rangedAttack = false;
            this.attackDecisionCounter = 0;
            this.updateEntityAttributes(false);
        }
        this.getSaveableMinionHandler().checkMinions();
        if (!this.field_70170_p.field_72995_K && this.shouldSpawnMinion()) {
            int i = 0;
            if (this.field_70718_bc > 0) {
                i = this.field_70146_Z.nextInt(3);
            }
            IMinion m = null;
            if (i == 1) {
                EntityVampireMinionSaveable e = new EntityVampireMinionSaveable(this.field_70170_p);
                if (e == null) {
                    VampirismMod.log.w("VampireBaron", "Failed to create saveable minion", new Object[0]);
                } else {
                    e.func_82149_j((Entity)this);
                    this.field_70170_p.func_72838_d((Entity)e);
                    m = e;
                }
            } else if (i == 2 && this.func_70638_az() != null) {
                m = (IVampireMinion.Saveable)UtilLib.spawnEntityBehindEntity(this.func_70638_az(), new ResourceLocation("vampirism", "vampire_minion_s"));
            }
            if (m == null) {
                m = (IVampireMinion.Saveable)UtilLib.spawnEntityInWorld(this.field_70170_p, this.func_174813_aQ().func_72314_b(19.0, 4.0, 19.0), new ResourceLocation("vampirism", "vampire_minion_s"), 3, Collections.emptyList());
            }
            if (m != null) {
                m.setLord(this);
            }
        }
        if (!this.field_70170_p.field_72995_K && this.isGettingSundamage()) {
            this.teleportAway();
        }
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null && this.field_70173_aa % 128 == 0) {
            if (this.rangedAttack) {
                if (this.field_70146_Z.nextInt(2) == 0 && this.field_70699_by.func_75494_a((Entity)this.func_70638_az()) != null) {
                    this.rangedAttack = false;
                }
            } else if (this.attackDecisionCounter > 4 || this.field_70146_Z.nextInt(6) == 0) {
                this.rangedAttack = true;
                this.attackDecisionCounter = 0;
            }
            if (this.getLevel() > 3 && this.field_70146_Z.nextInt(9) == 0) {
                this.func_70690_d(new PotionEffect(MobEffects.field_76441_p, 60));
            }
        }
        super.func_70636_d();
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setLevel(MathHelper.func_76125_a((int)nbt.func_74762_e("level"), (int)0, (int)5));
        this.minionHandler.loadMinions(nbt.func_150295_c("minions", 10));
    }

    @Override
    public int suggestLevel(Difficulty d) {
        return Math.min(4, this.suggestLevelInt(d));
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.getLevel() == 4 && ((Object)((Object)ModItems.vampire_book)).equals(stack.func_77973_b())) {
            this.setLevel(5);
            player.func_184611_a(hand, ItemStack.field_190927_a);
            this.func_70606_j(this.func_110138_aP());
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("level", this.getLevel());
        nbt.func_74782_a("minions", (NBTBase)this.minionHandler.getMinionsToSave());
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.updateEntityAttributes(false);
    }

    @Override
    protected float calculateFireDamage(float amount) {
        return (float)((double)amount * Balance.mobProps.VAMPIRE_BARON_FIRE_VULNERABILITY);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(LEVEL, (Object)-1);
    }

    protected int func_70693_a(EntityPlayer player) {
        return 20 + 5 * this.getLevel();
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootHandler.VAMPIRE_BARON;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new VampireAIFleeGarlic(this, (double)0.9f, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new BaronAIAttackMelee(this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new BaronAIAttackRanged(this, 60, 64, 6.0f, 4.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, input -> input != null && !this.isLowerLevel((EntityPlayer)input), 6.0f, 0.6, (double)0.7f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.2));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosestVisible((EntityLiving)this, EntityPlayer.class, 10.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 10, true, false, input -> input != null && this.isLowerLevel((EntityPlayer)input)));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVampireBaron.class, true, false));
    }

    protected boolean shouldSpawnMinion() {
        if (this.field_70173_aa % 30 == 7) {
            int count = this.getSaveableMinionHandler().getMinionCount();
            if (count < this.getLevel() + 1) {
                return true;
            }
            return this.field_70718_bc > 0 && count < 2 + this.getLevel();
        }
        return false;
    }

    protected void updateEntityAttributes(boolean aggressive) {
        if (aggressive) {
            this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(Balance.mobProps.VAMPIRE_BARON_MOVEMENT_SPEED * Math.pow((Balance.mobProps.VAMPIRE_BARON_IMPROVEMENT_PER_LEVEL - 1.0) / 5.0 + 1.0, this.getLevel()));
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(5.0);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(Balance.mobProps.VAMPIRE_BARON_MOVEMENT_SPEED * Math.pow(Balance.mobProps.VAMPIRE_BARON_IMPROVEMENT_PER_LEVEL, this.getLevel()) / 3.0);
        }
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Balance.mobProps.VAMPIRE_BARON_MAX_HEALTH * Math.pow(Balance.mobProps.VAMPIRE_BARON_IMPROVEMENT_PER_LEVEL, this.getLevel()));
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(Balance.mobProps.VAMPIRE_BARON_ATTACK_DAMAGE * Math.pow(Balance.mobProps.VAMPIRE_BARON_IMPROVEMENT_PER_LEVEL, this.getLevel()));
    }

    private boolean isLowerLevel(EntityPlayer player) {
        int playerLevel = FactionPlayerHandler.get(player).getCurrentLevel();
        return (float)(playerLevel - 8) / 2.0f - (float)this.getLevel() <= 0.0f;
    }

    private int suggestLevelInt(Difficulty d) {
        int avg = Math.round(((float)d.avgPercLevel / 100.0f - 0.35714287f) / 0.64285713f * 5.0f);
        int max = Math.round(((float)d.maxPercLevel / 100.0f - 0.35714287f) / 0.64285713f * 5.0f);
        int min = Math.round(((float)d.minPercLevel / 100.0f - 0.35714287f) / 0.64285713f * 5.0f);
        switch (this.field_70146_Z.nextInt(7)) {
            case 0: {
                return min;
            }
            case 1: {
                return max + 1;
            }
            case 2: {
                return avg;
            }
            case 3: {
                return avg + 1;
            }
            case 4: 
            case 5: {
                return this.field_70146_Z.nextInt(6);
            }
        }
        return this.field_70146_Z.nextInt(max + 2 - min) + min;
    }

    private class BaronAIAttackRanged
    extends EntityAIAttackRangedDarkBlood {
        BaronAIAttackRanged(EntityVampireBaron entity, int cooldown, int maxDistance, float damage, float indirectDamage) {
            super(entity, cooldown, maxDistance, damage, indirectDamage);
        }

        @Override
        public boolean func_75250_a() {
            return EntityVampireBaron.this.func_70638_az() != null && (EntityVampireBaron.this.rangedAttack || !EntityVampireBaron.this.func_70781_l());
        }
    }

    private class BaronAIAttackMelee
    extends EntityAIAttackMelee {
        BaronAIAttackMelee(EntityCreature creature, double speedIn) {
            super(creature, speedIn, false);
        }

        public boolean func_75253_b() {
            return !EntityVampireBaron.this.rangedAttack && super.func_75253_b();
        }

        public boolean func_75250_a() {
            return !EntityVampireBaron.this.rangedAttack && super.func_75250_a();
        }
    }
}

