/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.hunter;

import de.teamlapen.vampirism.api.entity.hunter.IHunter;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModVillages;
import de.teamlapen.vampirism.entity.EntityFactionVillager;
import de.teamlapen.vampirism.util.Helper;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;

public class EntityHunterFactionVillager
extends EntityFactionVillager
implements IHunter {
    private static final EntityVillager.ITradeList[][] TRADES = new EntityVillager.ITradeList[][]{{new ItemsForSouls(new EntityVillager.PriceInfo(10, 15), EntityHunterFactionVillager.createTiers(IItemWithTier.TIER.NORMAL, ModItems.hunter_coat_feet, ModItems.obsidian_armor_feet, ModItems.armor_of_swiftness_feet), new EntityVillager.PriceInfo(1, 1)), new ItemsForSouls(new EntityVillager.PriceInfo(25, 35), EntityHunterFactionVillager.createTiers(IItemWithTier.TIER.NORMAL, ModItems.hunter_coat_legs, ModItems.obsidian_armor_legs, ModItems.armor_of_swiftness_legs), new EntityVillager.PriceInfo(1, 1)), new ItemsForSouls(new EntityVillager.PriceInfo(30, 40), EntityHunterFactionVillager.createTiers(IItemWithTier.TIER.NORMAL, ModItems.hunter_coat_chest, ModItems.obsidian_armor_chest, ModItems.armor_of_swiftness_chest), new EntityVillager.PriceInfo(1, 1)), new ItemsForSouls(new EntityVillager.PriceInfo(20, 30), EntityHunterFactionVillager.createTiers(IItemWithTier.TIER.NORMAL, ModItems.hunter_coat_head, ModItems.obsidian_armor_head, ModItems.armor_of_swiftness_head), new EntityVillager.PriceInfo(1, 1)), new ItemsForSouls(new EntityVillager.PriceInfo(10, 20), ModItems.item_garlic, new EntityVillager.PriceInfo(2, 5)), new ItemsForSouls(new EntityVillager.PriceInfo(50, 100), Items.field_151045_i, new EntityVillager.PriceInfo(1, 1))}, {new ItemsForSouls(new EntityVillager.PriceInfo(10, 15), EntityHunterFactionVillager.createTiers(IItemWithTier.TIER.ENHANCED, ModItems.hunter_coat_feet, ModItems.obsidian_armor_feet, ModItems.armor_of_swiftness_feet), new EntityVillager.PriceInfo(1, 1)), new ItemsForSouls(new EntityVillager.PriceInfo(25, 35), EntityHunterFactionVillager.createTiers(IItemWithTier.TIER.ENHANCED, ModItems.hunter_coat_legs, ModItems.obsidian_armor_legs, ModItems.armor_of_swiftness_legs), new EntityVillager.PriceInfo(1, 1)), new ItemsForSouls(new EntityVillager.PriceInfo(30, 40), EntityHunterFactionVillager.createTiers(IItemWithTier.TIER.ENHANCED, ModItems.hunter_coat_chest, ModItems.obsidian_armor_chest, ModItems.armor_of_swiftness_chest), new EntityVillager.PriceInfo(1, 1)), new ItemsForSouls(new EntityVillager.PriceInfo(20, 30), EntityHunterFactionVillager.createTiers(IItemWithTier.TIER.ENHANCED, ModItems.hunter_coat_head, ModItems.obsidian_armor_head, ModItems.armor_of_swiftness_head), new EntityVillager.PriceInfo(1, 1)), new ItemsForSouls(new EntityVillager.PriceInfo(40, 90), Items.field_151045_i, new EntityVillager.PriceInfo(1, 2))}, {new ItemsForSouls(new EntityVillager.PriceInfo(100, 128), EntityHunterFactionVillager.createTiers(IItemWithTier.TIER.ULTIMATE, ModItems.hunter_coat_feet, ModItems.obsidian_armor_feet, ModItems.armor_of_swiftness_feet, ModItems.hunter_coat_legs, ModItems.obsidian_armor_legs, ModItems.armor_of_swiftness_legs, ModItems.hunter_coat_chest, ModItems.obsidian_armor_chest, ModItems.armor_of_swiftness_chest, ModItems.hunter_coat_head, ModItems.obsidian_armor_head, ModItems.armor_of_swiftness_head), new EntityVillager.PriceInfo(1, 1))}};

    private static ItemStack[] createTiers(IItemWithTier.TIER tier, IItemWithTier ... items) {
        ItemStack[] stacks = new ItemStack[items.length];
        for (int i = 0; i < items.length; ++i) {
            stacks[i] = items[i].setTier(new ItemStack((Item)items[i]), tier);
        }
        return stacks;
    }

    public EntityHunterFactionVillager(World worldIn) {
        super(worldIn);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        this.setProfession(ModVillages.profession_hunter_expert);
        return this.func_190672_a(difficulty, livingdata, false);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (player.func_184812_l_() || Helper.isHunter((Entity)player)) {
            return super.func_184645_a(player, hand);
        }
        if (player.field_70170_p.field_72995_K) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation(Helper.isVampire((Entity)player) ? "text.vampirism.hunter_villager.decline_trade_vampire" : "text.vampirism.hunter_villager.decline_trade_normal", new Object[0]), false);
        }
        return true;
    }

    public void func_70933_a(MerchantRecipe recipe) {
        super.func_70933_a(recipe);
        EntityPlayer player = this.func_70931_l_();
        if (player != null) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("text.vampirism.hunter_villager.trade_successful", new Object[0]), false);
        }
    }

    @Override
    @Nonnull
    protected EntityVillager.ITradeList[] getTrades(int level) {
        if (level >= 2) {
            return (EntityVillager.ITradeList[])ArrayUtils.addAll((Object[])TRADES[1], (Object[])TRADES[2]);
        }
        return TRADES[level];
    }

    private static class ItemsForSouls
    implements EntityVillager.ITradeList {
        private ItemStack[] sellingStacks;
        private EntityVillager.PriceInfo buying;
        private EntityVillager.PriceInfo selling;

        ItemsForSouls(EntityVillager.PriceInfo price, Item sell, EntityVillager.PriceInfo amount) {
            this(price, new ItemStack[]{new ItemStack(sell)}, amount);
        }

        ItemsForSouls(EntityVillager.PriceInfo price, ItemStack sell, EntityVillager.PriceInfo amount) {
            this(price, new ItemStack[]{sell}, amount);
        }

        ItemsForSouls(EntityVillager.PriceInfo price, ItemStack[] sellingStacks, EntityVillager.PriceInfo amount) {
            assert ((Integer)price.func_76340_b() > 128) : "Cannot sell items for more than 128 souls, as we have only two slots to accept them";
            this.sellingStacks = sellingStacks;
            this.buying = price;
            this.selling = amount;
        }

        public void func_190888_a(IMerchant merchant, MerchantRecipeList recipeList, Random random) {
            int price = this.buying.func_179412_a(random);
            int count = this.selling.func_179412_a(random);
            ItemStack selling = this.sellingStacks[random.nextInt(this.sellingStacks.length)].func_77946_l();
            selling.func_190920_e(count);
            ItemStack first = new ItemStack((Item)ModItems.soul_orb_vampire, price);
            ItemStack second = ItemStack.field_190927_a;
            if (price > 64) {
                second = new ItemStack((Item)ModItems.soul_orb_vampire, price - 64);
                first.func_190920_e(price - second.func_190916_E());
            }
            recipeList.add((Object)new MerchantRecipe(first, second, selling));
        }
    }
}

