/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.hunter;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.difficulty.Difficulty;
import de.teamlapen.vampirism.api.entity.actions.EntityActionTier;
import de.teamlapen.vampirism.api.entity.actions.IEntityActionUser;
import de.teamlapen.vampirism.api.entity.hunter.IBasicHunter;
import de.teamlapen.vampirism.api.world.IVampirismVillage;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.action.EntityActionHandler;
import de.teamlapen.vampirism.entity.ai.EntityAIAttackRangedCrossbow;
import de.teamlapen.vampirism.entity.ai.EntityAIAttackVillage;
import de.teamlapen.vampirism.entity.ai.EntityAIDefendVillage;
import de.teamlapen.vampirism.entity.ai.EntityAIMoveThroughVillageCustom;
import de.teamlapen.vampirism.entity.ai.HunterAILookAtTrainee;
import de.teamlapen.vampirism.entity.hunter.EntityHunterBase;
import de.teamlapen.vampirism.entity.vampire.EntityVampireBase;
import de.teamlapen.vampirism.inventory.HunterBasicContainer;
import de.teamlapen.vampirism.items.ItemSimpleCrossbow;
import de.teamlapen.vampirism.items.VampirismItemCrossbow;
import de.teamlapen.vampirism.player.hunter.HunterLevelingConf;
import de.teamlapen.vampirism.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.world.loot.LootHandler;
import de.teamlapen.vampirism.world.villages.VampirismVillageHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityBasicHunter
extends EntityHunterBase
implements IBasicHunter,
HunterAILookAtTrainee.ITrainer,
EntityAIAttackRangedCrossbow.IAttackWithCrossbow,
IEntityActionUser {
    private static final DataParameter<Integer> LEVEL = EntityDataManager.func_187226_a(EntityBasicHunter.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> SWINGING_ARMS = EntityDataManager.func_187226_a(EntityBasicHunter.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> WATCHED_ID = EntityDataManager.func_187226_a(EntityBasicHunter.class, (DataSerializer)DataSerializers.field_187192_b);
    private final int MAX_LEVEL = 3;
    private final int MOVE_TO_RESTRICT_PRIO = 3;
    private final EntityAIAttackMelee attackMelee;
    private final EntityAIAttackRangedCrossbow attackRange;
    @Nullable
    private EntityPlayer trainee;
    @Nullable
    private IVampirismVillage cachedVillage;
    private float targetAngle = 0.0f;
    @Nullable
    private AxisAlignedBB village_attack_area;
    @Nullable
    private AxisAlignedBB village_defense_area;

    public boolean func_70097_a(DamageSource source, float amount) {
        IVampirismVillage v = this.getCurrentFriendlyVillage();
        if (v != null) {
            v.addOrRenewAggressor(source.func_76346_g());
        }
        return super.func_70097_a(source, amount);
    }

    public EntityBasicHunter(World world) {
        super(world, true);
        this.saveHome = true;
        ((PathNavigateGround)this.func_70661_as()).func_179691_c(true);
        this.func_70105_a(0.6f, 1.95f);
        this.setDontDropEquipment();
        this.attackMelee = new EntityAIAttackMelee((EntityCreature)this, 1.0, false);
        this.attackRange = new EntityAIAttackRangedCrossbow(this, this, 0.6, 60, 20.0f);
        this.updateCombatTask();
        this.entitytier = EntityActionTier.Medium;
        this.entityActionHandler = new EntityActionHandler<EntityBasicHunter>(this);
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        boolean flag = super.func_70652_k(entity);
        if (flag && this.func_184614_ca().func_190926_b()) {
            this.func_184609_a(EnumHand.MAIN_HAND);
        }
        return flag;
    }

    @Override
    @Nonnull
    public ItemStack getArrowStackForAttack(EntityLivingBase target) {
        return new ItemStack((Item)ModItems.crossbow_arrow);
    }

    @Override
    @Nullable
    public IVampirismVillage getCurrentFriendlyVillage() {
        return this.cachedVillage != null ? (this.cachedVillage.getControllingFaction() == VReference.HUNTER_FACTION ? this.cachedVillage : null) : null;
    }

    @Override
    public int getLevel() {
        return (Integer)this.func_184212_Q().func_187225_a(LEVEL);
    }

    @Override
    public void setLevel(int level) {
        if (level >= 0) {
            this.func_184212_Q().func_187227_b(LEVEL, (Object)level);
            this.updateEntityAttributes();
            if (level == 3) {
                this.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 1000000, 1));
            }
        }
    }

    @Override
    public int getMaxLevel() {
        return 3;
    }

    public float getTargetAngle() {
        return this.targetAngle;
    }

    @Override
    public EntityPlayer getTrainee() {
        return this.trainee;
    }

    @Override
    public boolean isCrossbowInMainhand() {
        return !this.func_184614_ca().func_190926_b() && this.func_184614_ca().func_77973_b() instanceof VampirismItemCrossbow;
    }

    @Override
    public boolean isLookingForHome() {
        return !this.func_110175_bO();
    }

    public boolean isSwingingArms() {
        return (Boolean)this.func_184212_Q().func_187225_a(SWINGING_ARMS);
    }

    public void setSwingingArms(boolean b) {
        this.func_184212_Q().func_187227_b(SWINGING_ARMS, (Object)b);
    }

    @Override
    public void makeCampHunter(AxisAlignedBB box) {
        super.setHome(box);
        this.setMoveTowardsRestriction(3, true);
    }

    @Override
    public void makeNormalHunter() {
        super.setHome(null);
        this.disableMoveTowardsRestriction();
    }

    @Override
    public void makeVillageHunter(AxisAlignedBB box) {
        super.setHome(box);
        this.setMoveTowardsRestriction(3, true);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        if (this.func_70681_au().nextInt(4) == 0) {
            this.func_184641_n(true);
            ItemSimpleCrossbow crossBow = this.getLevel() > 1 ? ModItems.enhanced_crossbow : ModItems.basic_crossbow;
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)crossBow));
        } else {
            this.func_184641_n(false);
        }
        this.updateCombatTask();
        return livingdata;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.trainee != null && !(this.trainee.field_71070_bA instanceof HunterBasicContainer)) {
            this.trainee = null;
        }
        if (!this.field_70170_p.field_72995_K) {
            EntityLivingBase target = this.func_70638_az();
            int id = target == null ? 0 : target.func_145782_y();
            this.updateWatchedId(id);
        } else {
            Entity target;
            int id;
            this.targetAngle = 0.0f;
            if (this.isSwingingArms() && (id = this.getWatchedId()) != 0 && (target = this.field_70170_p.func_73045_a(id)) instanceof EntityLivingBase) {
                double dx = target.field_70165_t - this.field_70165_t;
                double dy = target.field_70163_u - this.field_70163_u;
                double dz = target.field_70161_v - this.field_70161_v;
                float dist = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
                this.targetAngle = (float)Math.atan(dy / (double)dist);
            }
        }
    }

    public void func_70020_e(NBTTagCompound tagCompund) {
        super.func_70020_e(tagCompund);
        if (tagCompund.func_74764_b("level")) {
            this.setLevel(tagCompund.func_74762_e("level"));
        }
        if (tagCompund.func_74764_b("crossbow") && tagCompund.func_74767_n("crossbow")) {
            this.func_184641_n(true);
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)ModItems.basic_crossbow));
        } else {
            this.func_184641_n(false);
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
        }
        this.updateCombatTask();
        if (tagCompund.func_74764_b("village_attack_area")) {
            this.attackVillage(UtilLib.intToBB(tagCompund.func_74759_k("village_attack_area")));
        } else if (tagCompund.func_74764_b("village_defense_area")) {
            this.defendVillage(UtilLib.intToBB(tagCompund.func_74759_k("village_defense_area")));
        }
    }

    @Override
    public void startTargeting() {
        this.setSwingingArms(true);
    }

    @Override
    public void stopTargeting() {
        this.setSwingingArms(false);
    }

    @Override
    public int suggestLevel(Difficulty d) {
        switch (this.field_70146_Z.nextInt(5)) {
            case 0: {
                return (int)((float)d.minPercLevel / 100.0f * 3.0f);
            }
            case 1: {
                return (int)((float)d.avgPercLevel / 100.0f * 3.0f);
            }
            case 2: {
                return (int)((float)d.maxPercLevel / 100.0f * 3.0f);
            }
        }
        return this.field_70146_Z.nextInt(4);
    }

    public void updateCombatTask() {
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.attackMelee);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.attackRange);
            ItemStack stack = this.func_184614_ca();
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof VampirismItemCrossbow) {
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.attackRange);
            } else {
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.attackMelee);
            }
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("level", this.getLevel());
        nbt.func_74757_a("crossbow", this.isCrossbowInMainhand());
        if (this.village_attack_area != null) {
            nbt.func_74783_a("village_attack_area", UtilLib.bbToInt(this.village_attack_area));
        } else if (this.village_defense_area != null) {
            nbt.func_74783_a("village_defense_area", UtilLib.bbToInt(this.village_defense_area));
        }
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.updateEntityAttributes();
    }

    protected boolean func_70692_ba() {
        return this.isLookingForHome() && super.func_70692_ba();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(LEVEL, (Object)-1);
        this.func_184212_Q().func_187214_a(SWINGING_ARMS, (Object)false);
        this.func_184212_Q().func_187214_a(WATCHED_ID, (Object)0);
    }

    protected int func_70693_a(EntityPlayer player) {
        return 6 + this.getLevel();
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootHandler.BASIC_HUNTER;
    }

    @Override
    public void attackVillage(AxisAlignedBB area) {
        this.village_attack_area = area;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(3, new HunterAILookAtTrainee<EntityBasicHunter>(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveThroughVillageCustom(this, 0.7f, false, 300));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.7, 50));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 13.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityVampireBase.class, 17.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, new EntityAIAttackVillage<EntityBasicHunter>(this));
        this.field_70715_bh.func_75776_a(2, new EntityAIDefendVillage<EntityBasicHunter>(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), true, false, false, false, null)));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget<EntityCreature>((EntityCreature)this, EntityCreature.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, null)){

            protected double func_111175_f() {
                return super.func_111175_f() / 2.0;
            }
        });
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityZombie.class, true, true));
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        int hunterLevel = HunterPlayer.get(player).getLevel();
        if (this.func_70089_S() && !player.func_70093_af()) {
            if (!this.field_70170_p.field_72995_K) {
                if (HunterLevelingConf.instance().isLevelValidForBasicHunter(hunterLevel + 1)) {
                    if (this.trainee == null) {
                        player.openGui((Object)VampirismMod.instance, 8, this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
                        this.trainee = player;
                    } else {
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("text.vampirism.i_am_busy_right_now", new Object[0]));
                    }
                } else if (hunterLevel > 0) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("text.vampirism.basic_hunter.cannot_train_you_any_further", new Object[0]));
                }
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public void defendVillage(AxisAlignedBB area) {
        this.village_defense_area = area;
    }

    @Override
    @Nullable
    public AxisAlignedBB getTargetVillageArea() {
        return this.village_attack_area == null ? this.village_defense_area : this.village_attack_area;
    }

    @Override
    public boolean isAttackingVillage() {
        return this.village_attack_area != null;
    }

    @Override
    public void stopVillageAttackDefense() {
        this.func_96094_a("");
        if (this.village_defense_area != null) {
            this.village_defense_area = null;
        } else if (this.village_attack_area != null) {
            this.village_attack_area = null;
        }
    }

    @Override
    protected void onRandomTick() {
        super.onRandomTick();
        this.cachedVillage = VampirismVillageHelper.getNearestVillage((Entity)this);
    }

    protected void updateEntityAttributes() {
        int l = Math.max(this.getLevel(), 0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Balance.mobProps.VAMPIRE_HUNTER_MAX_HEALTH + Balance.mobProps.VAMPIRE_HUNTER_MAX_HEALTH_PL * (double)l);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(Balance.mobProps.VAMPIRE_HUNTER_ATTACK_DAMAGE + Balance.mobProps.VAMPIRE_HUNTER_ATTACK_DAMAGE_PL * (double)l);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(Balance.mobProps.VAMPIRE_HUNTER_SPEED);
    }

    private int getWatchedId() {
        return (Integer)this.func_184212_Q().func_187225_a(WATCHED_ID);
    }

    private void updateWatchedId(int id) {
        this.func_184212_Q().func_187227_b(WATCHED_ID, (Object)id);
    }
}

