/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.factions;

import com.google.common.base.Predicate;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.api.entity.factions.IFactionRegistry;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.entity.factions.Faction;
import de.teamlapen.vampirism.entity.factions.PlayableFaction;
import de.teamlapen.vampirism.entity.factions.PredicateFaction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;

public class FactionRegistry
implements IFactionRegistry {
    private static final String TAG = "FactionRegistry";
    private List<Faction> temp = new ArrayList<Faction>();
    private Faction[] allFactions;
    private PlayableFaction[] playableFactions;
    private Map<Integer, Predicate<Entity>> predicateMap = new HashMap<Integer, Predicate<Entity>>();

    public void finish() {
        this.allFactions = this.temp.toArray(new Faction[this.temp.size()]);
        this.temp = null;
        ArrayList<PlayableFaction> temp2 = new ArrayList<PlayableFaction>();
        for (Faction allFaction : this.allFactions) {
            if (!(allFaction instanceof PlayableFaction)) continue;
            temp2.add((PlayableFaction)allFaction);
        }
        this.playableFactions = temp2.toArray(new PlayableFaction[temp2.size()]);
    }

    @Override
    @Nullable
    public IFaction getFaction(Entity entity) {
        if (entity instanceof IFactionEntity) {
            return ((IFactionEntity)entity).getFaction();
        }
        if (entity instanceof EntityPlayer) {
            return VampirismAPI.getFactionPlayerHandler((EntityPlayer)entity).getCurrentFaction();
        }
        return null;
    }

    @Override
    @Nullable
    public IFaction getFactionByName(String name) {
        if (this.allFactions == null) {
            return null;
        }
        for (Faction f : this.allFactions) {
            if (!f.name().equals(name)) continue;
            return f;
        }
        return null;
    }

    public Faction[] getFactions() {
        return this.allFactions;
    }

    public PlayableFaction[] getPlayableFactions() {
        return this.playableFactions;
    }

    @Override
    public Predicate<Entity> getPredicate(IFaction thisFaction, boolean ignoreDisguise) {
        return this.getPredicate(thisFaction, true, true, true, ignoreDisguise, null);
    }

    @Override
    public Predicate<Entity> getPredicate(IFaction thisFaction, boolean player, boolean mob, boolean neutralPlayer, boolean ignoreDisguise, IFaction otherFaction) {
        PredicateFaction predicate;
        int id;
        int key = 0;
        if (otherFaction != null) {
            id = ((Faction)otherFaction).getId();
            if (id > 63) {
                VampirismMod.log.w(TAG, "Faction id over 64, predicates won't work", new Object[0]);
            }
            key |= (id & 0x3F) << 10;
        }
        if (player) {
            key |= 0x200;
        }
        if (mob) {
            key |= 0x100;
        }
        if (neutralPlayer) {
            key |= 0x80;
        }
        if (ignoreDisguise) {
            key |= 0x40;
        }
        if ((id = ((Faction)thisFaction).getId()) > 64) {
            VampirismMod.log.w(TAG, "Faction id over 64, predicates won't work", new Object[0]);
        }
        if (this.predicateMap.containsKey(key |= id & 0x3F)) {
            predicate = this.predicateMap.get(key);
        } else {
            predicate = new PredicateFaction(thisFaction, player, mob, neutralPlayer, ignoreDisguise, otherFaction);
            this.predicateMap.put(key, predicate);
        }
        return predicate;
    }

    @Override
    public <T extends IFactionEntity> IFaction registerFaction(String name, Class<T> entityInterface, int color) {
        if (!UtilLib.isNonNull(name, entityInterface)) {
            throw new IllegalArgumentException("[Vampirism]Parameter for faction cannot be null");
        }
        if (!Loader.instance().isInState(LoaderState.PREINITIALIZATION)) {
            throw new IllegalStateException("Factions have to be registered during PRE-INIT");
        }
        Faction<T> f = new Faction<T>(name, entityInterface, color);
        this.addFaction(f);
        return f;
    }

    @Override
    public <T extends IFactionPlayer> IPlayableFaction registerPlayableFaction(String name, Class<T> entityInterface, int color, ResourceLocation key, Capability<T> playerCapabiltiy, int highestLevel) {
        if (!UtilLib.isNonNull(name, entityInterface, playerCapabiltiy)) {
            throw new IllegalArgumentException("[Vampirism]Parameters for faction cannot be null");
        }
        if (!Loader.instance().isInState(LoaderState.PREINITIALIZATION)) {
            throw new IllegalStateException("Factions have to be registered during PRE-INIT");
        }
        PlayableFaction<T> f = new PlayableFaction<T>(name, entityInterface, color, key, playerCapabiltiy, highestLevel);
        this.addFaction(f);
        return f;
    }

    private void addFaction(Faction faction) {
        if (this.temp == null) {
            throw new IllegalStateException(String.format("[Vampirism]You have to register factions BEFORE post init. (%s)", faction.name));
        }
        this.temp.add(faction);
    }
}

