/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.converted;

import de.teamlapen.vampirism.entity.converted.DefaultConvertingHandler;
import de.teamlapen.vampirism.entity.converted.EntityConvertedCreature;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class EntityConvertedSheep
extends EntityConvertedCreature<EntitySheep>
implements IShearable {
    private static final DataParameter<Byte> COAT = EntityDataManager.func_187226_a(EntityConvertedSheep.class, (DataSerializer)DataSerializers.field_187191_a);
    private Boolean lastSheared = null;

    public EntityConvertedSheep(World world) {
        super(world);
    }

    public EnumDyeColor getFleeceColor() {
        return this.nil() ? EnumDyeColor.WHITE : ((EntitySheep)this.getOldCreature()).func_175509_cj();
    }

    public boolean getSheared() {
        return ((Byte)this.field_70180_af.func_187225_a(COAT) & 0x10) != 0;
    }

    public void setSheared(boolean sheared) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(COAT);
        if (sheared) {
            this.field_70180_af.func_187227_b(COAT, (Object)((byte)(b0 | 0x10)));
        } else {
            this.field_70180_af.func_187227_b(COAT, (Object)((byte)(b0 & 0xFFFFFFEF)));
        }
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return !this.getSheared();
    }

    @Override
    public void func_70030_z() {
        super.func_70030_z();
        boolean t = this.getSheared();
        if (!(this.nil() || this.lastSheared != null && this.lastSheared == t)) {
            this.lastSheared = t;
            ((EntitySheep)this.getOldCreature()).func_70893_e(this.lastSheared.booleanValue());
        }
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        this.setSheared(true);
        int i = 1 + this.field_70146_Z.nextInt(3);
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (int j = 0; j < i; ++j) {
            ret.add(new ItemStack(Item.func_150898_a((Block)Blocks.field_150325_L), 1, this.getFleeceColor().func_176765_a()));
        }
        this.func_184185_a(SoundEvents.field_187763_eJ, 1.0f, 1.0f);
        return ret;
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setSheared(nbt.func_74767_n("Sheared"));
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("Sheared", this.getSheared());
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COAT, (Object)0);
    }

    public static class ConvertingHandler
    extends DefaultConvertingHandler<EntitySheep> {
        public ConvertingHandler() {
            super(null);
        }

        public EntityConvertedCreature createFrom(EntitySheep entity) {
            EntityConvertedSheep creature = new EntityConvertedSheep(entity.func_130014_f_());
            this.copyImportantStuff(creature, entity);
            creature.setSheared(entity.func_70892_o());
            return creature;
        }
    }
}

