/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.ISundamageRegistry;
import de.teamlapen.vampirism.util.Helper;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SundamageRegistry
implements ISundamageRegistry {
    private static final String TAG = "SundamageRegistry";
    private HashMap<Integer, Boolean> sundamageDims = new HashMap();
    private HashMap<Integer, Boolean> sundamageConfiguredDims = new HashMap();
    private Set<ResourceLocation> noSundamageBiomesIDs = new CopyOnWriteArraySet<ResourceLocation>();
    private Set<ResourceLocation> noSundamageConfiguredBiomesIDs = new CopyOnWriteArraySet<ResourceLocation>();
    private Set<Class> noSundamageBiomes = new CopyOnWriteArraySet<Class>();
    private boolean defaultSundamage = false;

    public SundamageRegistry() {
        this.sundamageDims.put(0, true);
        this.sundamageDims.put(-1, false);
        this.sundamageDims.put(1, false);
    }

    @Override
    public void addNoSundamageBiome(ResourceLocation registryName) {
        this.noSundamageBiomesIDs.add(registryName);
    }

    @Override
    public void addNoSundamageBiome(Class clazz) {
        this.noSundamageBiomes.add(clazz);
    }

    public void addNoSundamageBiomeConfigured(ResourceLocation id) {
        this.noSundamageConfiguredBiomesIDs.add(id);
    }

    @Override
    public void addNoSundamageBiomes(Biome ... biomes) {
        for (Biome b : biomes) {
            this.addNoSundamageBiome(b.func_150562_l());
        }
    }

    @Override
    @Deprecated
    public boolean getSundamageInBiome(ResourceLocation registryName) {
        return !this.noSundamageBiomesIDs.contains(registryName) && !this.noSundamageConfiguredBiomesIDs.contains(registryName);
    }

    @Override
    public boolean getSundamageInBiome(@Nonnull Biome biome) {
        if (!this.getSundamageInBiome(biome.getRegistryName())) {
            return false;
        }
        for (Class clazz : this.noSundamageBiomes) {
            if (!clazz.isAssignableFrom(biome.func_150562_l())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean getSundamageInDim(int dim) {
        Boolean r = this.sundamageConfiguredDims.get(dim);
        if (r == null) {
            r = this.sundamageDims.get(dim);
        }
        return r == null ? this.defaultSundamage : r;
    }

    @Override
    public boolean isGettingSundamage(EntityLivingBase entity) {
        return Helper.gettingSundamge(entity);
    }

    @SideOnly(value=Side.CLIENT)
    public void readFromNBTClient(NBTTagCompound nbt) {
        if (nbt.func_74764_b("sundamage")) {
            NBTTagCompound sundamage = nbt.func_74775_l("sundamage");
            this.defaultSundamage = sundamage.func_74767_n("default");
            this.sundamageConfiguredDims.clear();
            NBTTagCompound dimensions = sundamage.func_74775_l("dimensions");
            for (String s : dimensions.func_150296_c()) {
                try {
                    int dim = Integer.parseInt(s);
                    boolean value = sundamage.func_74767_n(s);
                    this.specifyConfiguredSundamageForDim(dim, value);
                }
                catch (NumberFormatException e) {
                    VampirismMod.log.e(TAG, "Failed to parse dimension id (%s) in update packet ", s);
                }
            }
            this.noSundamageConfiguredBiomesIDs.clear();
            NBTTagCompound biomes = sundamage.func_74775_l("biomes");
            for (String s : biomes.func_150296_c()) {
                ResourceLocation res = new ResourceLocation(s);
                this.addNoSundamageBiomeConfigured(res);
            }
        }
    }

    public void resetConfigurations() {
        this.sundamageConfiguredDims.clear();
        this.noSundamageConfiguredBiomesIDs.clear();
    }

    public void setDefaultDimsSundamage(boolean val) {
        this.defaultSundamage = val;
    }

    public void specifyConfiguredSundamageForDim(int dimensionId, boolean sundamage) {
        this.sundamageConfiguredDims.put(dimensionId, sundamage);
    }

    @Override
    public void specifySundamageForDim(int dimensionId, boolean sundamage) {
        this.sundamageDims.put(dimensionId, sundamage);
    }

    public void writeToNBTServer(NBTTagCompound nbt) {
        NBTTagCompound sundamage = new NBTTagCompound();
        NBTTagCompound dimensions = new NBTTagCompound();
        for (Map.Entry<Integer, Boolean> entry : this.sundamageConfiguredDims.entrySet()) {
            dimensions.func_74757_a(entry.getKey().toString(), entry.getValue().booleanValue());
        }
        sundamage.func_74782_a("dimensions", (NBTBase)dimensions);
        NBTTagCompound biomes = new NBTTagCompound();
        for (ResourceLocation s : this.noSundamageConfiguredBiomesIDs) {
            biomes.func_74757_a(s.toString(), true);
        }
        sundamage.func_74782_a("biomes", (NBTBase)biomes);
        sundamage.func_74757_a("default", this.defaultSundamage);
        nbt.func_74782_a("sundamage", (NBTBase)sundamage);
    }
}

