/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.difficulty.Difficulty;
import de.teamlapen.vampirism.api.difficulty.IAdjustableLevel;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.minions.IMinionLordWithSaveable;
import de.teamlapen.vampirism.api.items.IFactionSlayerItem;
import de.teamlapen.vampirism.blocks.BlockCastleBlock;
import de.teamlapen.vampirism.blocks.BlockCastleStairs;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.entity.ai.GolemAITargetVampire;
import de.teamlapen.vampirism.inventory.BloodPotionTableContainer;
import de.teamlapen.vampirism.items.VampirismVampireSword;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.util.DifficultyCalculator;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.util.REFERENCE;
import de.teamlapen.vampirism.world.villages.VampirismVillage;
import de.teamlapen.vampirism.world.villages.VampirismVillageHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ModEntityEventHandler {
    private boolean skipAttackDamageOnceClient = false;
    private boolean skipAttackDamageOnceServer = false;
    private boolean warnAboutCreeper = true;
    private boolean warnAboutZombie = true;

    @SubscribeEvent
    public void onAttachCapabilityEntity(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityCreature) {
            event.addCapability(REFERENCE.EXTENDED_CREATURE_KEY, ExtendedCreature.createNewCapability((EntityCreature)event.getObject()));
        }
    }

    @SubscribeEvent
    public void onEntityAttacked(LivingAttackEvent event) {
        boolean client = FMLCommonHandler.instance().getEffectiveSide().isClient();
        if (!(!client ? this.skipAttackDamageOnceServer : this.skipAttackDamageOnceClient)) {
            ItemStack stack;
            if ("player".equals(event.getSource().func_76355_l()) && event.getSource().func_76346_g() instanceof EntityPlayer && !(stack = ((EntityPlayer)event.getSource().func_76346_g()).func_184614_ca()).func_190926_b() && stack.func_77973_b() instanceof IFactionSlayerItem) {
                IFactionSlayerItem item = (IFactionSlayerItem)stack.func_77973_b();
                IFaction faction = VampirismAPI.factionRegistry().getFaction(event.getEntity());
                if (faction != null && faction.equals(item.getSlayedFaction())) {
                    float amt = event.getAmount() * item.getDamageMultiplierForFaction(stack);
                    if (client) {
                        this.skipAttackDamageOnceClient = true;
                    } else {
                        this.skipAttackDamageOnceServer = true;
                    }
                    boolean result = event.getEntityLiving().func_70097_a(event.getSource(), amt);
                    if (client) {
                        this.skipAttackDamageOnceClient = false;
                    } else {
                        this.skipAttackDamageOnceServer = false;
                    }
                    event.setCanceled(!result);
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityCheckSpawn(LivingSpawnEvent.CheckSpawn event) {
        IBlockState blockState = event.getWorld().func_180495_p(new BlockPos((double)(event.getX() - 0.4f), (double)event.getY(), (double)(event.getZ() - 0.4f)).func_177977_b());
        if (blockState.func_177230_c().equals((Object)ModBlocks.castle_block)) {
            if (BlockCastleBlock.EnumType.DARK_STONE.equals(blockState.func_177229_b(BlockCastleBlock.VARIANT)) || !event.getEntity().isCreatureType(VReference.VAMPIRE_CREATURE_TYPE, false)) {
                event.setResult(Event.Result.DENY);
            }
        } else if (blockState.func_177230_c() instanceof BlockCastleStairs && (ModBlocks.castle_stairs_dark_stone.equals(blockState.func_177230_c()) || !event.getEntity().isCreatureType(VReference.VAMPIRE_CREATURE_TYPE, false))) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        EntityAIBase target;
        VampirismVillage village;
        IAdjustableLevel entity2;
        if (!event.getWorld().field_72995_K && event.getEntity() instanceof IAdjustableLevel && (entity2 = (IAdjustableLevel)event.getEntity()).getLevel() == -1) {
            Difficulty d = DifficultyCalculator.findDifficultyForPos(event.getWorld(), event.getEntity().func_180425_c(), 30);
            int l = entity2.suggestLevel(d);
            if (l > entity2.getMaxLevel()) {
                l = entity2.getMaxLevel();
            } else if (l < 0) {
                event.setCanceled(true);
            }
            entity2.setLevel(l);
            if (entity2 instanceof EntityCreature) {
                ((EntityCreature)entity2).func_70606_j(((EntityCreature)entity2).func_110138_aP());
            }
        }
        if (event.getEntity() instanceof EntityVillager && !event.getWorld().field_72995_K && (village = VampirismVillageHelper.getNearestVillage(event.getWorld(), event.getEntity().func_180425_c(), 5)) != null && village.getControllingFaction() != null && village.getControllingFaction().equals(VReference.HUNTER_FACTION)) {
            ExtendedCreature.get((EntityCreature)event.getEntity()).setPoisonousBlood(true);
        }
        if (!event.getWorld().field_72995_K && !Balance.vps.DISABLE_AVOIDED_BY_CREEPERS && event.getEntity() instanceof EntityCreeper) {
            ((EntityCreeper)event.getEntity()).field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)((EntityCreeper)event.getEntity()), EntityPlayer.class, input -> input != null && VampirePlayer.get((EntityPlayer)input).getSpecialAttributes().avoided_by_creepers, 20.0f, 1.1, 1.3));
            target = null;
            for (EntityAITasks.EntityAITaskEntry t : ((EntityCreeper)event.getEntity()).field_70715_bh.field_75782_a) {
                if (!(t.field_75733_a instanceof EntityAINearestAttackableTarget) || t.field_75731_b != 1) continue;
                target = t.field_75733_a;
            }
            if (target != null) {
                ((EntityCreeper)event.getEntity()).field_70715_bh.func_85156_a(target);
                ((EntityCreeper)event.getEntity()).field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)((EntityCreeper)event.getEntity()), EntityPlayer.class, 10, true, false, input -> input != null && !VampirePlayer.get((EntityPlayer)input).getSpecialAttributes().avoided_by_creepers));
            } else if (this.warnAboutCreeper) {
                VampirismMod.log.w("EntityEventHandler", "Could not replace creeper target task", new Object[0]);
                this.warnAboutCreeper = false;
            }
        }
        if (!event.getWorld().field_72995_K && Balance.general.ZOMBIE_IGNORE_VAMPIRE && event.getEntity() instanceof EntityZombie) {
            target = null;
            for (EntityAITasks.EntityAITaskEntry t : ((EntityZombie)event.getEntity()).field_70715_bh.field_75782_a) {
                if (!(t.field_75733_a instanceof EntityAINearestAttackableTarget) || t.field_75731_b != 2) continue;
                target = t.field_75733_a;
            }
            if (target != null) {
                ((EntityZombie)event.getEntity()).field_70715_bh.func_85156_a(target);
                ((EntityZombie)event.getEntity()).field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)((EntityZombie)event.getEntity()), EntityPlayer.class, 10, true, false, entity -> !Helper.isVampire((Entity)entity)));
            } else if (this.warnAboutZombie) {
                VampirismMod.log.w("EntityEventHandler", "Could not replace zombie target task", new Object[0]);
                this.warnAboutZombie = false;
            }
        }
        if (!event.getWorld().field_72995_K && Balance.general.GOLEM_ATTACK_VAMPIRE && event.getEntity() instanceof EntityIronGolem) {
            ((EntityIronGolem)event.getEntity()).field_70715_bh.func_75776_a(4, (EntityAIBase)new GolemAITargetVampire((EntityIronGolem)event.getEntity()));
        }
        if (event.getEntity() instanceof IMinionLordWithSaveable) {
            ((IMinionLordWithSaveable)event.getEntity()).getSaveableMinionHandler().addLoadedMinions();
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity() instanceof EntityCreature) {
            event.getEntity().func_130014_f_().field_72984_F.func_76320_a("vampirism_extended_creature");
            ExtendedCreature.get((EntityCreature)event.getEntity()).onUpdate();
            event.getEntity().func_130014_f_().field_72984_F.func_76319_b();
        } else if (!event.getEntity().func_130014_f_().field_72995_K && event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            if (player.field_71070_bA instanceof BloodPotionTableContainer) {
                ((BloodPotionTableContainer)player.field_71070_bA).tick();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onLivingEquipmentChange(LivingEquipmentChangeEvent event) {
        if (event.getTo().func_77973_b() instanceof VampirismVampireSword) {
            ((VampirismVampireSword)event.getTo().func_77973_b()).updateTrainedCached(event.getTo(), event.getEntityLiving());
        }
    }
}

