/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.potion.PotionPoison;
import de.teamlapen.vampirism.potion.PotionSanguinare;
import de.teamlapen.vampirism.potion.PotionThirst;
import de.teamlapen.vampirism.potion.VampirismNightVisionPotion;
import de.teamlapen.vampirism.potion.VampirismPotion;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@GameRegistry.ObjectHolder(value="vampirism")
public class ModPotions {
    public static final Potion sanguinare = (Potion)UtilLib.getNull();
    public static final Potion thirst = (Potion)UtilLib.getNull();
    public static final Potion saturation = (Potion)UtilLib.getNull();
    public static final Potion sunscreen = (Potion)UtilLib.getNull();
    public static final Potion disguise_as_vampire = (Potion)UtilLib.getNull();
    public static final Potion fire_protection = (Potion)UtilLib.getNull();
    public static final Potion garlic = (Potion)UtilLib.getNull();
    public static final Potion poison = (Potion)UtilLib.getNull();
    private static Potion modded_night_vision;
    private static Potion vanilla_night_vision;

    static void registerPotions(IForgeRegistry<Potion> registry) {
        registry.register((IForgeRegistryEntry)new PotionThirst("thirst", true, 859494));
        vanilla_night_vision = MobEffects.field_76439_r;
        modded_night_vision = new VampirismNightVisionPotion();
        registry.register((IForgeRegistryEntry)modded_night_vision);
        registry.register((IForgeRegistryEntry)new PotionSanguinare("sanguinare", false, 6949000));
        registry.register((IForgeRegistryEntry)new VampirismPotion("saturation", false, 14483200).setIconIndex(2, 0).func_188413_j());
        Potion sunscreen = new VampirismPotion("sunscreen", false, 0xFFF100).setIconIndex(3, 0).func_188413_j();
        sunscreen.func_111184_a(VReference.sunDamage, "9dc9420c-3e5e-41c7-9ba4-ff70e9dc69fc", -0.5, 2);
        registry.register((IForgeRegistryEntry)sunscreen);
        registry.register((IForgeRegistryEntry)new VampirismPotion("fire_protection", false, 14981690).setIconIndex(6, 0).func_188413_j());
        registry.register((IForgeRegistryEntry)new VampirismPotion("disguise_as_vampire", false, 0x999900).setIconIndex(4, 0).func_188413_j());
        registry.register((IForgeRegistryEntry)new VampirismPotion("garlic", true, 0xFFFFFF).setIconIndex(5, 0));
        registry.register((IForgeRegistryEntry)new PotionPoison("poison", true, 5149489));
    }

    static void fixNightVisionPotionTypes() {
        VampirismMod.log.i("Potion", "Fixing vanilla night vision potion types", new Object[0]);
        try {
            for (PotionEffect effect : PotionTypes.field_185234_f.func_185170_a()) {
                if (!effect.func_188419_a().equals(vanilla_night_vision)) continue;
                ReflectionHelper.setPrivateValue(PotionEffect.class, (Object)effect, (Object)modded_night_vision, (String[])new String[]{"potion", "field_188420_b"});
            }
            for (PotionEffect effect : PotionTypes.field_185235_g.func_185170_a()) {
                if (!effect.func_188419_a().equals(vanilla_night_vision)) continue;
                ReflectionHelper.setPrivateValue(PotionEffect.class, (Object)effect, (Object)modded_night_vision, (String[])new String[]{"potion", "field_188420_b"});
            }
        }
        catch (ReflectionHelper.UnableToAccessFieldException e) {
            VampirismMod.log.e("Potion", e, "Unable to modify vanilla night vision types. Potion items and more might not work", new Object[0]);
        }
    }

    static void fixMapping(RegistryEvent.MissingMappings.Mapping<Potion> m) {
        if ("night_vision".equals(m.key.func_110623_a())) {
            m.ignore();
        }
    }

    static boolean checkNightVision() {
        if (!(MobEffects.field_76439_r instanceof VampirismNightVisionPotion)) {
            VampirismMod.log.w("Potion", "Vampirism was not able to register it's night vision potion", new Object[0]);
            return false;
        }
        return true;
    }
}

